/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.UnsupportedCollisionException;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Ray;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.terrain.geomipmap.LODGeomap;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.util.EntropyComputeUtil;
import com.jme3.util.BufferUtils;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;

public class TerrainPatch
extends Geometry {
    protected LODGeomap geomap;
    protected int lod = 0;
    private int maxLod = -1;
    protected int previousLod = -1;
    protected int lodLeft;
    protected int lodTop;
    protected int lodRight;
    protected int lodBottom;
    protected int size;
    protected int totalSize;
    protected short quadrant = 1;
    protected Vector3f stepScale;
    protected Vector2f offset;
    protected float offsetAmount;
    protected TerrainPatch leftNeighbour;
    protected TerrainPatch topNeighbour;
    protected TerrainPatch rightNeighbour;
    protected TerrainPatch bottomNeighbour;
    protected boolean searchedForNeighboursAlready = false;
    protected Vector3f worldTranslationCached;
    protected Vector3f worldScaleCached;
    protected float[] lodEntropy;

    public TerrainPatch() {
        super("TerrainPatch");
        this.setBatchHint(Spatial.BatchHint.Never);
    }

    public TerrainPatch(String name) {
        super(name);
        this.setBatchHint(Spatial.BatchHint.Never);
    }

    public TerrainPatch(String name, int size) {
        this(name, size, new Vector3f(1.0f, 1.0f, 1.0f), null, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public TerrainPatch(String name, int size, Vector3f stepScale, float[] heightMap, Vector3f origin) {
        this(name, size, stepScale, heightMap, origin, size, new Vector2f(), 0.0f);
    }

    public TerrainPatch(String name, int size, Vector3f stepScale, float[] heightMap, Vector3f origin, int totalSize, Vector2f offset, float offsetAmount) {
        super(name);
        this.setBatchHint(Spatial.BatchHint.Never);
        this.size = size;
        this.stepScale = stepScale;
        this.totalSize = totalSize;
        this.offsetAmount = offsetAmount;
        this.offset = offset;
        this.setLocalTranslation(origin);
        this.geomap = new LODGeomap(size, heightMap);
        Mesh m = this.geomap.createMesh(stepScale, new Vector2f(1.0f, 1.0f), offset, offsetAmount, totalSize, false);
        this.setMesh(m);
    }

    public void generateLodEntropies() {
        float[] entropies = new float[this.getMaxLod() + 1];
        for (int i = 0; i <= this.getMaxLod(); ++i) {
            int curLod = (int)Math.pow(2.0, i);
            IndexBuffer idxB = this.geomap.writeIndexArrayLodDiff(curLod, false, false, false, false, this.totalSize);
            Buffer ib = idxB.getBuffer();
            entropies[i] = EntropyComputeUtil.computeLodEntropy(this.mesh, ib);
        }
        this.lodEntropy = entropies;
    }

    public float[] getLodEntropies() {
        if (this.lodEntropy == null) {
            this.generateLodEntropies();
        }
        return this.lodEntropy;
    }

    public float[] getHeightMap() {
        return this.geomap.getHeightArray();
    }

    public int getMaxLod() {
        if (this.maxLod < 0) {
            this.maxLod = Math.max(1, (int)(FastMath.log((float)(this.size - 1)) / FastMath.log((float)2.0f)) - 1);
        }
        return this.maxLod;
    }

    protected void reIndexGeometry(HashMap<String, UpdatedTerrainPatch> updated, boolean useVariableLod) {
        UpdatedTerrainPatch utp = updated.get(this.getName());
        if (utp != null && utp.isReIndexNeeded()) {
            int pow = (int)Math.pow(2.0, utp.getNewLod());
            boolean left = utp.getLeftLod() > utp.getNewLod();
            boolean top = utp.getTopLod() > utp.getNewLod();
            boolean right = utp.getRightLod() > utp.getNewLod();
            boolean bottom = utp.getBottomLod() > utp.getNewLod();
            IndexBuffer idxB = useVariableLod ? this.geomap.writeIndexArrayLodVariable(pow, (int)Math.pow(2.0, utp.getRightLod()), (int)Math.pow(2.0, utp.getTopLod()), (int)Math.pow(2.0, utp.getLeftLod()), (int)Math.pow(2.0, utp.getBottomLod()), this.totalSize) : this.geomap.writeIndexArrayLodDiff(pow, right, top, left, bottom, this.totalSize);
            Buffer b = idxB.getBuffer();
            utp.setNewIndexBuffer(b);
        }
    }

    public Vector2f getTex(float x, float z, Vector2f store) {
        if (x < 0.0f || z < 0.0f || x >= (float)this.size || z >= (float)this.size) {
            store.set(Vector2f.ZERO);
            return store;
        }
        int idx = (int)(z * (float)this.size + x);
        return store.set(this.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord).get(idx * 2), this.getMesh().getFloatBuffer(VertexBuffer.Type.TexCoord).get(idx * 2 + 1));
    }

    public float getHeightmapHeight(float x, float z) {
        if (x < 0.0f || z < 0.0f || x >= (float)this.size || z >= (float)this.size) {
            return 0.0f;
        }
        int idx = (int)(z * (float)this.size + x);
        return this.getMesh().getFloatBuffer(VertexBuffer.Type.Position).get(idx * 3 + 1);
    }

    public Triangle getTriangle(float x, float z) {
        return this.geomap.getTriangleAtPoint(x, z, this.getWorldScale(), this.getWorldTranslation());
    }

    public Triangle[] getGridTriangles(float x, float z) {
        return this.geomap.getGridTrianglesAtPoint(x, z, this.getWorldScale(), this.getWorldTranslation());
    }

    protected void setHeight(List<TerrainQuad.LocationHeight> locationHeights, boolean overrideHeight) {
        float[] heightArray = this.geomap.getHeightArray();
        VertexBuffer vertexBuffer = this.mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer floatBuffer = this.mesh.getFloatBuffer(VertexBuffer.Type.Position);
        for (TerrainQuad.LocationHeight lh : locationHeights) {
            if (lh.x < 0 || lh.z < 0 || lh.x >= this.size || lh.z >= this.size) continue;
            int idx = lh.z * this.size + lh.x;
            if (overrideHeight) {
                heightArray[idx] = lh.h;
                continue;
            }
            float currentHeight = floatBuffer.get(idx * 3 + 1);
            heightArray[idx] = currentHeight + lh.h;
        }
        floatBuffer.clear();
        this.geomap.writeVertexArray(floatBuffer, this.stepScale, false);
        vertexBuffer.setUpdateNeeded();
    }

    protected void updateNormals() {
        FloatBuffer newNormalBuffer = this.geomap.writeNormalArray(null, this.getWorldScale());
        this.getMesh().getBuffer(VertexBuffer.Type.Normal).updateData((Buffer)newNormalBuffer);
        FloatBuffer newTangentBuffer = null;
        FloatBuffer newBinormalBuffer = null;
        FloatBuffer[] tb = this.geomap.writeTangentArray(newNormalBuffer, newTangentBuffer, newBinormalBuffer, (FloatBuffer)this.getMesh().getBuffer(VertexBuffer.Type.TexCoord).getData(), this.getWorldScale());
        newTangentBuffer = tb[0];
        newBinormalBuffer = tb[1];
        this.getMesh().getBuffer(VertexBuffer.Type.Tangent).updateData((Buffer)newTangentBuffer);
        this.getMesh().getBuffer(VertexBuffer.Type.Binormal).updateData((Buffer)newBinormalBuffer);
    }

    private void setInBuffer(Mesh mesh, int index, Vector3f normal, Vector3f tangent, Vector3f binormal) {
        VertexBuffer NB = mesh.getBuffer(VertexBuffer.Type.Normal);
        VertexBuffer TB = mesh.getBuffer(VertexBuffer.Type.Tangent);
        VertexBuffer BB = mesh.getBuffer(VertexBuffer.Type.Binormal);
        BufferUtils.setInBuffer((Vector3f)normal, (FloatBuffer)((FloatBuffer)NB.getData()), (int)index);
        BufferUtils.setInBuffer((Vector3f)tangent, (FloatBuffer)((FloatBuffer)TB.getData()), (int)index);
        BufferUtils.setInBuffer((Vector3f)binormal, (FloatBuffer)((FloatBuffer)BB.getData()), (int)index);
        NB.setUpdateNeeded();
        TB.setUpdateNeeded();
        BB.setUpdateNeeded();
    }

    protected void fixNormalEdges(TerrainPatch right, TerrainPatch bottom, TerrainPatch top, TerrainPatch left, TerrainPatch bottomRight, TerrainPatch bottomLeft, TerrainPatch topRight, TerrainPatch topLeft) {
        int i;
        Vector3f rootPoint = new Vector3f();
        Vector3f rightPoint = new Vector3f();
        Vector3f leftPoint = new Vector3f();
        Vector3f topPoint = new Vector3f();
        Vector3f bottomPoint = new Vector3f();
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        Vector3f normal = new Vector3f();
        int s = this.getSize() - 1;
        if (right != null) {
            for (i = 0; i < s + 1; ++i) {
                rootPoint.set(0.0f, this.getHeightmapHeight(s, i), 0.0f);
                leftPoint.set(-1.0f, this.getHeightmapHeight(s - 1, i), 0.0f);
                rightPoint.set(1.0f, right.getHeightmapHeight(1.0f, i), 0.0f);
                if (i == 0) {
                    bottomPoint.set(0.0f, this.getHeightmapHeight(s, i + 1), 1.0f);
                    if (top == null) {
                        this.averageNormalsTangents(null, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                        this.setInBuffer(this.getMesh(), s, normal, tangent, binormal);
                        this.setInBuffer(right.getMesh(), 0, normal, tangent, binormal);
                        continue;
                    }
                    topPoint.set(0.0f, top.getHeightmapHeight(s, s - 1), -1.0f);
                    this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                    this.setInBuffer(this.getMesh(), s, normal, tangent, binormal);
                    this.setInBuffer(right.getMesh(), 0, normal, tangent, binormal);
                    this.setInBuffer(top.getMesh(), (s + 1) * (s + 1) - 1, normal, tangent, binormal);
                    if (topRight == null) continue;
                    continue;
                }
                if (i == s) {
                    topPoint.set(0.0f, this.getHeightmapHeight(s, s - 1), -1.0f);
                    if (bottom == null) {
                        this.averageNormalsTangents(topPoint, rootPoint, leftPoint, null, rightPoint, normal, tangent, binormal);
                        this.setInBuffer(this.getMesh(), (s + 1) * (s + 1) - 1, normal, tangent, binormal);
                        this.setInBuffer(right.getMesh(), (s + 1) * s, normal, tangent, binormal);
                        continue;
                    }
                    bottomPoint.set(0.0f, bottom.getHeightmapHeight(s, 1.0f), 1.0f);
                    this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                    this.setInBuffer(this.getMesh(), (s + 1) * (s + 1) - 1, normal, tangent, binormal);
                    this.setInBuffer(right.getMesh(), (s + 1) * s, normal, tangent, binormal);
                    this.setInBuffer(bottom.getMesh(), s, normal, tangent, binormal);
                    if (bottomRight == null) continue;
                    continue;
                }
                topPoint.set(0.0f, this.getHeightmapHeight(s, i - 1), -1.0f);
                bottomPoint.set(0.0f, this.getHeightmapHeight(s, i + 1), 1.0f);
                this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                this.setInBuffer(this.getMesh(), (s + 1) * (i + 1) - 1, normal, tangent, binormal);
                this.setInBuffer(right.getMesh(), (s + 1) * i, normal, tangent, binormal);
            }
        }
        if (left != null) {
            for (i = 0; i < s + 1; ++i) {
                rootPoint.set(0.0f, this.getHeightmapHeight(0.0f, i), 0.0f);
                leftPoint.set(-1.0f, left.getHeightmapHeight(s - 1, i), 0.0f);
                rightPoint.set(1.0f, this.getHeightmapHeight(1.0f, i), 0.0f);
                if (i == 0) {
                    bottomPoint.set(0.0f, this.getHeightmapHeight(0.0f, i + 1), 1.0f);
                    if (top == null) {
                        this.averageNormalsTangents(null, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                        this.setInBuffer(this.getMesh(), 0, normal, tangent, binormal);
                        this.setInBuffer(left.getMesh(), s, normal, tangent, binormal);
                        continue;
                    }
                    topPoint.set(0.0f, top.getHeightmapHeight(0.0f, s - 1), -1.0f);
                    this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                    this.setInBuffer(this.getMesh(), 0, normal, tangent, binormal);
                    this.setInBuffer(left.getMesh(), s, normal, tangent, binormal);
                    this.setInBuffer(top.getMesh(), (s + 1) * s, normal, tangent, binormal);
                    if (topLeft == null) continue;
                    continue;
                }
                if (i == s) {
                    topPoint.set(0.0f, this.getHeightmapHeight(0.0f, i - 1), -1.0f);
                    if (bottom == null) {
                        this.averageNormalsTangents(topPoint, rootPoint, leftPoint, null, rightPoint, normal, tangent, binormal);
                        this.setInBuffer(this.getMesh(), (s + 1) * s, normal, tangent, binormal);
                        this.setInBuffer(left.getMesh(), (s + 1) * (s + 1) - 1, normal, tangent, binormal);
                        continue;
                    }
                    bottomPoint.set(0.0f, bottom.getHeightmapHeight(0.0f, 1.0f), 1.0f);
                    this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                    this.setInBuffer(this.getMesh(), (s + 1) * s, normal, tangent, binormal);
                    this.setInBuffer(left.getMesh(), (s + 1) * (s + 1) - 1, normal, tangent, binormal);
                    this.setInBuffer(bottom.getMesh(), 0, normal, tangent, binormal);
                    if (bottomLeft == null) continue;
                    continue;
                }
                topPoint.set(0.0f, this.getHeightmapHeight(0.0f, i - 1), -1.0f);
                bottomPoint.set(0.0f, this.getHeightmapHeight(0.0f, i + 1), 1.0f);
                this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                this.setInBuffer(this.getMesh(), (s + 1) * i, normal, tangent, binormal);
                this.setInBuffer(left.getMesh(), (s + 1) * (i + 1) - 1, normal, tangent, binormal);
            }
        }
        if (top != null) {
            for (i = 0; i < s + 1; ++i) {
                rootPoint.set(0.0f, this.getHeightmapHeight(i, 0.0f), 0.0f);
                topPoint.set(0.0f, top.getHeightmapHeight(i, s - 1), -1.0f);
                bottomPoint.set(0.0f, this.getHeightmapHeight(i, 1.0f), 1.0f);
                if (i == 0 || i == s) continue;
                leftPoint.set(-1.0f, this.getHeightmapHeight(i - 1, 0.0f), 0.0f);
                rightPoint.set(1.0f, this.getHeightmapHeight(i + 1, 0.0f), 0.0f);
                this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                this.setInBuffer(this.getMesh(), i, normal, tangent, binormal);
                this.setInBuffer(top.getMesh(), (s + 1) * s + i, normal, tangent, binormal);
            }
        }
        if (bottom != null) {
            for (i = 0; i < s + 1; ++i) {
                rootPoint.set(0.0f, this.getHeightmapHeight(i, s), 0.0f);
                topPoint.set(0.0f, this.getHeightmapHeight(i, s - 1), -1.0f);
                bottomPoint.set(0.0f, bottom.getHeightmapHeight(i, 1.0f), 1.0f);
                if (i == 0 || i == s) continue;
                leftPoint.set(-1.0f, this.getHeightmapHeight(i - 1, s), 0.0f);
                rightPoint.set(1.0f, this.getHeightmapHeight(i + 1, s), 0.0f);
                this.averageNormalsTangents(topPoint, rootPoint, leftPoint, bottomPoint, rightPoint, normal, tangent, binormal);
                this.setInBuffer(this.getMesh(), (s + 1) * s + i, normal, tangent, binormal);
                this.setInBuffer(bottom.getMesh(), i, normal, tangent, binormal);
            }
        }
    }

    protected void averageNormalsTangents(Vector3f topPoint, Vector3f rootPoint, Vector3f leftPoint, Vector3f bottomPoint, Vector3f rightPoint, Vector3f normal, Vector3f tangent, Vector3f binormal) {
        Vector3f scale = this.getWorldScale();
        Vector3f n1 = new Vector3f(0.0f, 0.0f, 0.0f);
        if (topPoint != null && leftPoint != null) {
            n1.set(this.calculateNormal(topPoint.mult(scale), rootPoint.mult(scale), leftPoint.mult(scale)));
        }
        Vector3f n2 = new Vector3f(0.0f, 0.0f, 0.0f);
        if (leftPoint != null && bottomPoint != null) {
            n2.set(this.calculateNormal(leftPoint.mult(scale), rootPoint.mult(scale), bottomPoint.mult(scale)));
        }
        Vector3f n3 = new Vector3f(0.0f, 0.0f, 0.0f);
        if (rightPoint != null && bottomPoint != null) {
            n3.set(this.calculateNormal(bottomPoint.mult(scale), rootPoint.mult(scale), rightPoint.mult(scale)));
        }
        Vector3f n4 = new Vector3f(0.0f, 0.0f, 0.0f);
        if (rightPoint != null && topPoint != null) {
            n4.set(this.calculateNormal(rightPoint.mult(scale), rootPoint.mult(scale), topPoint.mult(scale)));
        }
        normal.set(n1.add(n2).add(n3).add(n4).normalize());
        tangent.set(normal.cross(new Vector3f(0.0f, 0.0f, 1.0f)).normalize());
        binormal.set(new Vector3f(1.0f, 0.0f, 0.0f).cross(normal).normalize());
    }

    private Vector3f calculateNormal(Vector3f firstPoint, Vector3f rootPoint, Vector3f secondPoint) {
        Vector3f normal = new Vector3f();
        normal.set(firstPoint).subtractLocal(rootPoint).crossLocal(secondPoint.subtract(rootPoint)).normalizeLocal();
        return normal;
    }

    protected Vector3f getMeshNormal(int x, int z) {
        if (x >= this.size || z >= this.size) {
            return null;
        }
        int index = (z * this.size + x) * 3;
        FloatBuffer nb = (FloatBuffer)this.getMesh().getBuffer(VertexBuffer.Type.Normal).getData();
        Vector3f normal = new Vector3f();
        normal.x = nb.get(index);
        normal.y = nb.get(index + 1);
        normal.z = nb.get(index + 2);
        return normal;
    }

    protected float getHeight(int x, int z, float xm, float zm) {
        return this.geomap.getHeight(x, z, xm, zm);
    }

    public void lockMesh() {
        this.getMesh().setStatic();
    }

    public void unlockMesh() {
        this.getMesh().setDynamic();
    }

    public float getOffsetAmount() {
        return this.offsetAmount;
    }

    public Vector3f getStepScale() {
        return this.stepScale;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getSize() {
        return this.size;
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector2f offset) {
        this.offset = offset;
    }

    public void setSize(int size) {
        this.size = size;
        this.maxLod = -1;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setStepScale(Vector3f stepScale) {
        this.stepScale = stepScale;
    }

    public void setOffsetAmount(float offsetAmount) {
        this.offsetAmount = offsetAmount;
    }

    public short getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(short quadrant) {
        this.quadrant = quadrant;
    }

    public int getLod() {
        return this.lod;
    }

    public void setLod(int lod) {
        this.lod = lod;
    }

    public int getPreviousLod() {
        return this.previousLod;
    }

    public void setPreviousLod(int previousLod) {
        this.previousLod = previousLod;
    }

    protected int getLodLeft() {
        return this.lodLeft;
    }

    protected void setLodLeft(int lodLeft) {
        this.lodLeft = lodLeft;
    }

    protected int getLodTop() {
        return this.lodTop;
    }

    protected void setLodTop(int lodTop) {
        this.lodTop = lodTop;
    }

    protected int getLodRight() {
        return this.lodRight;
    }

    protected void setLodRight(int lodRight) {
        this.lodRight = lodRight;
    }

    protected int getLodBottom() {
        return this.lodBottom;
    }

    protected void setLodBottom(int lodBottom) {
        this.lodBottom = lodBottom;
    }

    public int collideWith(Collidable other, CollisionResults results) throws UnsupportedCollisionException {
        if (this.refreshFlags != 0) {
            throw new IllegalStateException("Scene graph must be updated before checking collision");
        }
        if (other instanceof BoundingVolume && !this.getWorldBound().intersects((BoundingVolume)other)) {
            return 0;
        }
        if (other instanceof Ray) {
            return this.collideWithRay((Ray)other, results);
        }
        if (other instanceof BoundingVolume) {
            return this.collideWithBoundingVolume((BoundingVolume)other, results);
        }
        throw new UnsupportedCollisionException("TerrainPatch cannot collide with " + other.getClass().getName());
    }

    private int collideWithRay(Ray ray, CollisionResults results) {
        return 0;
    }

    private int collideWithBoundingVolume(BoundingVolume boundingVolume, CollisionResults results) {
        if (boundingVolume instanceof BoundingBox) {
            return this.collideWithBoundingBox((BoundingBox)boundingVolume, results);
        }
        if (boundingVolume instanceof BoundingSphere) {
            BoundingSphere sphere = (BoundingSphere)boundingVolume;
            BoundingBox bbox = new BoundingBox(boundingVolume.getCenter().clone(), sphere.getRadius(), sphere.getRadius(), sphere.getRadius());
            return this.collideWithBoundingBox(bbox, results);
        }
        return 0;
    }

    protected Vector3f worldCoordinateToLocal(Vector3f loc) {
        Vector3f translated = new Vector3f();
        translated.x = loc.x / this.getWorldScale().x - this.getWorldTranslation().x;
        translated.y = loc.y / this.getWorldScale().y - this.getWorldTranslation().y;
        translated.z = loc.z / this.getWorldScale().z - this.getWorldTranslation().z;
        return translated;
    }

    private int collideWithBoundingBox(BoundingBox bbox, CollisionResults results) {
        Vector3f topLeft = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x - bbox.getXExtent(), 0.0f, bbox.getCenter().z - bbox.getZExtent()));
        Vector3f topRight = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x + bbox.getXExtent(), 0.0f, bbox.getCenter().z - bbox.getZExtent()));
        Vector3f bottomLeft = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x - bbox.getXExtent(), 0.0f, bbox.getCenter().z + bbox.getZExtent()));
        Vector3f bottomRight = this.worldCoordinateToLocal(new Vector3f(bbox.getCenter().x + bbox.getXExtent(), 0.0f, bbox.getCenter().z + bbox.getZExtent()));
        Triangle t = this.getTriangle(topLeft.x, topLeft.z);
        if (t != null && bbox.collideWith((Collidable)t, results) > 0) {
            return 1;
        }
        t = this.getTriangle(topRight.x, topRight.z);
        if (t != null && bbox.collideWith((Collidable)t, results) > 0) {
            return 1;
        }
        t = this.getTriangle(bottomLeft.x, bottomLeft.z);
        if (t != null && bbox.collideWith((Collidable)t, results) > 0) {
            return 1;
        }
        t = this.getTriangle(bottomRight.x, bottomRight.z);
        if (t != null && bbox.collideWith((Collidable)t, results) > 0) {
            return 1;
        }
        for (float z = topLeft.z; z < bottomLeft.z; z += 1.0f) {
            for (float x = topLeft.x; x < topRight.x; x += 1.0f) {
                if (x < 0.0f || z < 0.0f || x >= (float)this.size || z >= (float)this.size || (t = this.getTriangle(x, z)) == null || bbox.collideWith((Collidable)t, results) <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    public void write(JmeExporter ex) throws IOException {
        Mesh temp = this.getMesh();
        this.mesh = null;
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.size, "size", 16);
        oc.write(this.totalSize, "totalSize", 16);
        oc.write(this.quadrant, "quadrant", (short)0);
        oc.write((Savable)this.stepScale, "stepScale", (Savable)Vector3f.UNIT_XYZ);
        oc.write((Savable)this.offset, "offset", (Savable)Vector3f.UNIT_XYZ);
        oc.write(this.offsetAmount, "offsetAmount", 0.0f);
        oc.write(this.lodEntropy, "lodEntropy", null);
        oc.write((Savable)this.geomap, "geomap", null);
        this.setMesh(temp);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.size = ic.readInt("size", 16);
        this.totalSize = ic.readInt("totalSize", 16);
        this.quadrant = ic.readShort("quadrant", (short)0);
        this.stepScale = (Vector3f)ic.readSavable("stepScale", (Savable)Vector3f.UNIT_XYZ);
        this.offset = (Vector2f)ic.readSavable("offset", (Savable)Vector3f.UNIT_XYZ);
        this.offsetAmount = ic.readFloat("offsetAmount", 0.0f);
        this.lodEntropy = ic.readFloatArray("lodEntropy", null);
        this.geomap = (LODGeomap)ic.readSavable("geomap", null);
        Mesh regen = this.geomap.createMesh(this.stepScale, new Vector2f(1.0f, 1.0f), this.offset, this.offsetAmount, this.totalSize, false);
        this.setMesh(regen);
        this.ensurePositiveVolumeBBox();
    }

    public TerrainPatch clone() {
        TerrainPatch clone = new TerrainPatch();
        clone.name = this.name.toString();
        clone.size = this.size;
        clone.totalSize = this.totalSize;
        clone.quadrant = this.quadrant;
        clone.stepScale = this.stepScale.clone();
        clone.offset = this.offset.clone();
        clone.offsetAmount = this.offsetAmount;
        clone.geomap = new LODGeomap(this.size, this.geomap.getHeightArray());
        clone.setLocalTranslation(this.getLocalTranslation().clone());
        Mesh m = clone.geomap.createMesh(clone.stepScale, Vector2f.UNIT_XY, clone.offset, clone.offsetAmount, clone.totalSize, false);
        clone.setMesh(m);
        clone.setMaterial(this.material.clone());
        return clone;
    }

    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.stepScale = (Vector3f)cloner.clone((Object)this.stepScale);
        this.offset = (Vector2f)cloner.clone((Object)this.offset);
        this.leftNeighbour = null;
        this.topNeighbour = null;
        this.rightNeighbour = null;
        this.bottomNeighbour = null;
        this.geomap = new LODGeomap(this.size, this.geomap.getHeightArray());
        Mesh m = this.geomap.createMesh(this.stepScale, Vector2f.UNIT_XY, this.offset, this.offsetAmount, this.totalSize, false);
        this.setMesh(m);
        this.material = this.material.clone();
    }

    protected void ensurePositiveVolumeBBox() {
        if (this.getModelBound() instanceof BoundingBox && ((BoundingBox)this.getModelBound()).getYExtent() < 0.001f) {
            ((BoundingBox)this.getModelBound()).setYExtent(0.001f);
            this.updateWorldBound();
        }
    }

    protected void cacheTerrainTransforms() {
        this.worldScaleCached = this.getWorldScale().clone();
        this.worldTranslationCached = this.getWorldTranslation().clone();
    }

    public Vector3f getWorldScaleCached() {
        return this.worldScaleCached;
    }

    public Vector3f getWorldTranslationCached() {
        return this.worldTranslationCached;
    }

    protected void clearCaches() {
        if (this.leftNeighbour != null) {
            this.leftNeighbour.rightNeighbour = null;
            this.leftNeighbour = null;
        }
        if (this.rightNeighbour != null) {
            this.rightNeighbour.leftNeighbour = null;
            this.rightNeighbour = null;
        }
        if (this.topNeighbour != null) {
            this.topNeighbour.bottomNeighbour = null;
            this.topNeighbour = null;
        }
        if (this.bottomNeighbour != null) {
            this.bottomNeighbour.topNeighbour = null;
            this.bottomNeighbour = null;
        }
    }
}

