/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.render.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.Factory;
import de.lessvoid.nifty.tools.ObjectPool;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmeBatchRenderBackend
implements BatchRenderBackend {
    private static final Logger log = Logger.getLogger(JmeBatchRenderBackend.class.getName());
    private final ObjectPool<Batch> batchPool;
    private final List<Batch> batches = new ArrayList<Batch>();
    private final List<ModifyTexture> modifyTextureCalls = new ArrayList<ModifyTexture>();
    private RenderManager renderManager;
    private NiftyJmeDisplay display;
    private Map<Integer, Texture2D> textures = new HashMap<Integer, Texture2D>();
    private int textureAtlasId = 1;
    private Batch currentBatch;
    private Matrix4f tempMat = new Matrix4f();
    private ByteBuffer initialData = null;
    private boolean fillRemovedTexture = false;

    public JmeBatchRenderBackend(NiftyJmeDisplay display) {
        this.display = display;
        this.batchPool = new ObjectPool((Factory)new Factory<Batch>(){

            public Batch createNew() {
                return new Batch();
            }
        });
    }

    public void setRenderManager(RenderManager rm) {
        this.renderManager = rm;
    }

    public void setResourceLoader(NiftyResourceLoader resourceLoader) {
    }

    public int getWidth() {
        return this.display.getWidth();
    }

    public int getHeight() {
        return this.display.getHeight();
    }

    public void beginFrame() {
        log.fine("beginFrame()");
        for (int i = 0; i < this.batches.size(); ++i) {
            this.batchPool.free((Object)this.batches.get(i));
        }
        this.batches.clear();
        if (!this.modifyTextureCalls.isEmpty()) {
            Renderer renderer = this.display.getRenderer();
            for (int i = 0; i < this.modifyTextureCalls.size(); ++i) {
                this.modifyTextureCalls.get(i).execute(renderer);
            }
            this.modifyTextureCalls.clear();
        }
    }

    public void endFrame() {
        log.fine("endFrame");
    }

    public void clear() {
    }

    public MouseCursor createMouseCursor(String filename, int hotspotX, int hotspotY) throws IOException {
        return new MouseCursor(){

            public void dispose() {
            }

            public void enable() {
            }

            public void disable() {
            }
        };
    }

    public void enableMouseCursor(MouseCursor mouseCursor) {
    }

    public void disableMouseCursor() {
    }

    public int createTextureAtlas(int width, int height) {
        try {
            if (this.initialData == null) {
                this.initialData = BufferUtils.createByteBuffer((int)(width * height * 4));
                for (int i = 0; i < width * height; ++i) {
                    this.initialData.put((byte)0);
                    this.initialData.put((byte)0);
                    this.initialData.put((byte)0);
                    this.initialData.put((byte)-1);
                }
            }
            int atlasId = this.addTexture(this.createAtlasTextureInternal(width, height));
            return atlasId;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return 0;
        }
    }

    public void clearTextureAtlas(int atlasId) {
        this.initialData.rewind();
        this.getTextureAtlas(atlasId).getImage().setData(this.initialData);
    }

    public BatchRenderBackend.Image loadImage(String filename) {
        TextureKey key = new TextureKey(filename, false);
        key.setAnisotropy(0);
        key.setGenerateMips(false);
        Texture2D texture = (Texture2D)this.display.getAssetManager().loadTexture(key);
        Renderer renderer = this.display.getRenderer();
        if ((renderer == null || renderer.getCaps().contains(Caps.OpenGLES20)) && texture.getImage().getFormat() != Image.Format.RGBA8) {
            Image sourceImage = texture.getImage();
            int size = sourceImage.getWidth() * sourceImage.getHeight() * 4;
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)size);
            Image rgba8Image = new Image(Image.Format.RGBA8, sourceImage.getWidth(), sourceImage.getHeight(), buffer, sourceImage.getColorSpace());
            ImageRaster input = ImageRaster.create((Image)sourceImage, (int)0, (int)0, (boolean)false);
            ImageRaster output = ImageRaster.create((Image)rgba8Image, (int)0, (int)0, (boolean)false);
            ColorRGBA color = new ColorRGBA();
            for (int y = 0; y < sourceImage.getHeight(); ++y) {
                for (int x = 0; x < sourceImage.getWidth(); ++x) {
                    output.setPixel(x, y, input.getPixel(x, y, color));
                }
            }
            return new ImageImpl(rgba8Image);
        }
        return new ImageImpl(texture.getImage());
    }

    public BatchRenderBackend.Image loadImage(ByteBuffer imageData, int imageWidth, int imageHeight) {
        return new ImageImpl(new Image(Image.Format.RGBA8, imageWidth, imageHeight, imageData, ColorSpace.Linear));
    }

    public void addImageToAtlas(BatchRenderBackend.Image image, int x, int y, int atlasTextureId) {
        ImageImpl imageImpl = (ImageImpl)image;
        imageImpl.modifyTexture(this, this.getTextureAtlas(atlasTextureId), x, y);
    }

    public int createNonAtlasTexture(BatchRenderBackend.Image image) {
        ImageImpl imageImpl = (ImageImpl)image;
        Texture2D texture = new Texture2D(imageImpl.image);
        texture.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        texture.setMagFilter(Texture.MagFilter.Nearest);
        return this.addTexture(texture);
    }

    public void deleteNonAtlasTexture(int textureId) {
        this.textures.remove(textureId);
    }

    public boolean existsNonAtlasTexture(int textureId) {
        return this.textures.containsKey(textureId);
    }

    public void beginBatch(BlendMode blendMode, int textureId) {
        this.batches.add((Batch)this.batchPool.allocate());
        this.currentBatch = this.batches.get(this.batches.size() - 1);
        this.currentBatch.begin(blendMode, this.getTextureAtlas(textureId));
    }

    public void addQuad(float x, float y, float width, float height, Color color1, Color color2, Color color3, Color color4, float textureX, float textureY, float textureWidth, float textureHeight, int textureId) {
        if (!this.currentBatch.canAddQuad()) {
            this.beginBatch(this.currentBatch.getBlendMode(), textureId);
        }
        this.currentBatch.addQuadInternal(x, y, width, height, color1, color2, color3, color4, textureX, textureY, textureWidth, textureHeight);
    }

    public int render() {
        for (int i = 0; i < this.batches.size(); ++i) {
            Batch batch = this.batches.get(i);
            batch.render();
        }
        return this.batches.size();
    }

    public void removeImageFromAtlas(BatchRenderBackend.Image image, int x, int y, int w, int h, int atlasTextureId) {
        if (!this.fillRemovedTexture) {
            return;
        }
        ByteBuffer initialData = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int i = 0; i < image.getWidth() * image.getHeight(); ++i) {
            initialData.put((byte)-1);
            initialData.put((byte)0);
            initialData.put((byte)0);
            initialData.put((byte)-1);
        }
        initialData.rewind();
        this.modifyTexture(this.getTextureAtlas(atlasTextureId), new Image(Image.Format.RGBA8, image.getWidth(), image.getHeight(), initialData, ColorSpace.sRGB), x, y);
    }

    public void useHighQualityTextures(boolean shouldUseHighQualityTextures) {
    }

    public void fillRemovedImagesInAtlas(boolean shouldFill) {
        this.fillRemovedTexture = shouldFill;
    }

    private Texture2D createAtlasTextureInternal(int width, int height) throws Exception {
        this.initialData.rewind();
        Texture2D texture = new Texture2D(new Image(Image.Format.RGBA8, width, height, this.initialData, ColorSpace.sRGB));
        texture.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        texture.setMagFilter(Texture.MagFilter.Nearest);
        return texture;
    }

    private void modifyTexture(Texture2D textureAtlas, Image image, int x, int y) {
        Renderer renderer = this.display.getRenderer();
        if (renderer == null) {
            this.modifyTextureCalls.add(new ModifyTexture(textureAtlas, image, x, y));
            return;
        }
        renderer.modifyTexture((Texture)textureAtlas, image, x, y);
    }

    private Texture2D getTextureAtlas(int atlasId) {
        return this.textures.get(atlasId);
    }

    private int addTexture(Texture2D texture) {
        int atlasId = this.textureAtlasId++;
        this.textures.put(atlasId, texture);
        return atlasId;
    }

    private class Batch {
        private static final int BATCH_MAX_QUADS = 2000;
        private static final int BATCH_MAX_VERTICES = 8000;
        private final VertexBuffer vertexPos = new VertexBuffer(VertexBuffer.Type.Position);
        private final VertexBuffer vertexTexCoord = new VertexBuffer(VertexBuffer.Type.TexCoord);
        private final VertexBuffer vertexColor = new VertexBuffer(VertexBuffer.Type.Color);
        private final VertexBuffer indexBuffer = new VertexBuffer(VertexBuffer.Type.Index);
        private final Mesh mesh = new Mesh();
        private final Geometry meshGeometry = new Geometry("nifty-quad", this.mesh);
        private final RenderState renderState = new RenderState();
        private final FloatBuffer vertexPosBuffer;
        private final FloatBuffer vertexTexCoordBuffer;
        private final FloatBuffer vertexColorBuffer;
        private final ShortBuffer indexBufferBuffer;
        private int quadCount;
        private short globalVertexIndex;
        private BlendMode blendMode = BlendMode.BLEND;
        private Texture2D texture;
        private final Material material;

        public Batch() {
            this.vertexPos.setupData(VertexBuffer.Usage.Stream, 2, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((int)16000));
            this.vertexPosBuffer = (FloatBuffer)this.vertexPos.getData();
            this.mesh.setBuffer(this.vertexPos);
            this.vertexTexCoord.setupData(VertexBuffer.Usage.Stream, 2, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((int)16000));
            this.vertexTexCoordBuffer = (FloatBuffer)this.vertexTexCoord.getData();
            this.mesh.setBuffer(this.vertexTexCoord);
            this.vertexColor.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((int)32000));
            this.vertexColorBuffer = (FloatBuffer)this.vertexColor.getData();
            this.mesh.setBuffer(this.vertexColor);
            this.indexBuffer.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.UnsignedShort, (Buffer)BufferUtils.createShortBuffer((int)12000));
            this.indexBufferBuffer = (ShortBuffer)this.indexBuffer.getData();
            this.mesh.setBuffer(this.indexBuffer);
            this.material = new Material(JmeBatchRenderBackend.this.display.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
            this.material.setBoolean("VertexColor", true);
            this.renderState.setDepthTest(false);
            this.renderState.setDepthWrite(false);
        }

        public void begin(BlendMode blendMode, Texture2D texture) {
            this.blendMode = blendMode;
            this.texture = texture;
            this.quadCount = 0;
            this.globalVertexIndex = 0;
            this.vertexPosBuffer.clear();
            this.vertexTexCoordBuffer.clear();
            this.vertexColorBuffer.clear();
            this.indexBufferBuffer.clear();
        }

        public BlendMode getBlendMode() {
            return this.blendMode;
        }

        public void render() {
            this.renderState.setBlendMode(this.convertBlend(this.blendMode));
            this.vertexPosBuffer.flip();
            this.vertexPos.updateData((Buffer)this.vertexPosBuffer);
            this.vertexTexCoordBuffer.flip();
            this.vertexTexCoord.updateData((Buffer)this.vertexTexCoordBuffer);
            this.vertexColorBuffer.flip();
            this.vertexColor.updateData((Buffer)this.vertexColorBuffer);
            this.indexBufferBuffer.flip();
            this.indexBuffer.updateData((Buffer)this.indexBufferBuffer);
            JmeBatchRenderBackend.this.tempMat.loadIdentity();
            JmeBatchRenderBackend.this.renderManager.setWorldMatrix(JmeBatchRenderBackend.this.tempMat);
            JmeBatchRenderBackend.this.renderManager.setForcedRenderState(this.renderState);
            this.material.setTexture("ColorMap", (Texture)this.texture);
            this.mesh.updateCounts();
            this.material.render(this.meshGeometry, JmeBatchRenderBackend.this.renderManager);
            JmeBatchRenderBackend.this.renderManager.setForcedRenderState(null);
        }

        private RenderState.BlendMode convertBlend(BlendMode blendMode) {
            if (blendMode == null) {
                return RenderState.BlendMode.Off;
            }
            switch (blendMode) {
                case BLEND: {
                    return RenderState.BlendMode.Alpha;
                }
                case MULIPLY: {
                    return RenderState.BlendMode.Alpha;
                }
            }
            throw new UnsupportedOperationException();
        }

        public boolean canAddQuad() {
            return this.quadCount + 1 < 2000;
        }

        private void addQuadInternal(float x, float y, float width, float height, Color color1, Color color2, Color color3, Color color4, float textureX, float textureY, float textureWidth, float textureHeight) {
            this.indexBufferBuffer.put((short)(this.globalVertexIndex + 0));
            this.indexBufferBuffer.put((short)(this.globalVertexIndex + 3));
            this.indexBufferBuffer.put((short)(this.globalVertexIndex + 2));
            this.indexBufferBuffer.put((short)(this.globalVertexIndex + 0));
            this.indexBufferBuffer.put((short)(this.globalVertexIndex + 2));
            this.indexBufferBuffer.put((short)(this.globalVertexIndex + 1));
            this.addVertex(x, y, textureX, textureY, color1);
            this.addVertex(x + width, y, textureX + textureWidth, textureY, color2);
            this.addVertex(x + width, y + height, textureX + textureWidth, textureY + textureHeight, color4);
            this.addVertex(x, y + height, textureX, textureY + textureHeight, color3);
            ++this.quadCount;
            this.globalVertexIndex = (short)(this.globalVertexIndex + 4);
        }

        private void addVertex(float x, float y, float tx, float ty, Color c) {
            this.vertexPosBuffer.put(x);
            this.vertexPosBuffer.put((float)JmeBatchRenderBackend.this.getHeight() - y);
            this.vertexTexCoordBuffer.put(tx);
            this.vertexTexCoordBuffer.put(ty);
            this.vertexColorBuffer.put(c.getRed());
            this.vertexColorBuffer.put(c.getGreen());
            this.vertexColorBuffer.put(c.getBlue());
            this.vertexColorBuffer.put(c.getAlpha());
        }
    }

    private static class ModifyTexture {
        private final Texture2D atlas;
        private final Image image;
        private final int x;
        private final int y;

        private ModifyTexture(Texture2D atlas, Image image, int x, int y) {
            this.atlas = atlas;
            this.image = image;
            this.x = x;
            this.y = y;
        }

        public void execute(Renderer renderer) {
            renderer.modifyTexture((Texture)this.atlas, this.image, this.x, this.y);
        }
    }

    private static class ImageImpl
    implements BatchRenderBackend.Image {
        private final Image image;

        public ImageImpl(Image image) {
            this.image = image;
        }

        public void modifyTexture(JmeBatchRenderBackend backend, Texture2D textureAtlas, int x, int y) {
            backend.modifyTexture(textureAtlas, this.image, x, y);
        }

        public int getWidth() {
            return this.image.getWidth();
        }

        public int getHeight() {
            return this.image.getHeight();
        }
    }
}

