/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rmi;

import com.jme3.network.service.rmi.ClassInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassInfoRegistry {
    private final Map<Class, ClassInfo> cache = new HashMap<Class, ClassInfo>();
    private final AtomicInteger nextClassId = new AtomicInteger();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo getClassInfo(Class type) {
        this.lock.readLock().lock();
        try {
            ClassInfo result = this.cache.get(type);
            if (result != null) {
                ClassInfo classInfo = result;
                return classInfo;
            }
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                result = new ClassInfo((short)this.nextClassId.getAndIncrement(), type);
                this.cache.put(type, result);
                this.lock.readLock().lock();
                ClassInfo classInfo = result;
                this.lock.writeLock().unlock();
                return classInfo;
            }
            catch (Throwable throwable) {
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

