/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.awt.AwtKeyInput;
import com.jme3.input.awt.AwtMouseInput;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.JmeContext;
import com.jme3.system.lwjgl.LwjglWindow;
import com.jme3.system.lwjglx.LwjglxDefaultGLPlatform;
import com.jme3.system.lwjglx.LwjglxGLPlatform;
import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.awthacks.NonClearGraphics;
import org.lwjgl.awthacks.NonClearGraphics2D;
import org.lwjgl.opengl.awt.GLData;
import org.lwjgl.system.Platform;

public class LwjglCanvas
extends LwjglWindow
implements JmeCanvasContext,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(LwjglCanvas.class.getName());
    private static final Map<String, Consumer<GLData>> RENDER_CONFIGS = new HashMap<String, Consumer<GLData>>();
    private static final Platform OS = Platform.get();
    private final LwjglAWTGLCanvas canvas;
    private GLData glData;
    private final AtomicBoolean showGLDataEffective = new AtomicBoolean(false);
    private final AtomicBoolean hasNativePeer = new AtomicBoolean(false);
    private final AtomicBoolean showing = new AtomicBoolean(false);
    private AtomicBoolean needResize = new AtomicBoolean(false);
    private AtomicBoolean contextFlag = new AtomicBoolean(false);
    private final Semaphore signalTerminate = new Semaphore(0);
    private final Object lock = new Object();
    private int framebufferWidth = 1;
    private int framebufferHeight = 1;
    private AwtKeyInput keyInput;
    private AwtMouseInput mouseInput;

    public LwjglCanvas() {
        super(JmeContext.Type.Canvas);
        this.glData = new GLData();
        this.canvas = new LwjglAWTGLCanvas(this.glData);
        this.canvas.setIgnoreRepaint(true);
        this.canvas.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                Object object = LwjglCanvas.this.lock;
                synchronized (object) {
                    GraphicsConfiguration gc = LwjglCanvas.this.canvas.getGraphicsConfiguration();
                    if (gc == null) {
                        return;
                    }
                    AffineTransform at = gc.getDefaultTransform();
                    float sx = (float)at.getScaleX();
                    float sy = (float)at.getScaleY();
                    int fw = (int)((float)LwjglCanvas.this.canvas.getWidth() * sx);
                    int fh = (int)((float)LwjglCanvas.this.canvas.getHeight() * sy);
                    if (fw != LwjglCanvas.this.framebufferWidth || fh != LwjglCanvas.this.framebufferHeight) {
                        LwjglCanvas.this.framebufferWidth = Math.max(fw, 1);
                        LwjglCanvas.this.framebufferHeight = Math.max(fh, 1);
                        LwjglCanvas.this.needResize.set(true);
                    }
                }
            }
        });
    }

    @Override
    public void destroy(boolean waitFor) {
        super.destroy(waitFor);
        this.contextFlag.set(false);
    }

    @Override
    public void create(boolean waitFor) {
        if (this.contextFlag.get()) {
            return;
        }
        super.create(waitFor);
        this.contextFlag.set(true);
    }

    @Override
    protected void createContext(AppSettings settings) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, "LWJGL3-AWT: Interrupted!", ex);
        }
        super.createContext(settings);
        RENDER_CONFIGS.computeIfAbsent(settings.getRenderer(), t -> data -> {
            data.majorVersion = 2;
            data.minorVersion = 0;
        }).accept(this.glData);
        if (settings.getBitsPerPixel() == 24) {
            this.glData.redSize = 8;
            this.glData.greenSize = 8;
            this.glData.blueSize = 8;
        } else if (settings.getBitsPerPixel() == 16) {
            this.glData.redSize = 5;
            this.glData.greenSize = 6;
            this.glData.blueSize = 5;
        }
        this.glData.swapInterval = settings.isVSync() ? Integer.valueOf(1) : Integer.valueOf(0);
        this.showGLDataEffective.set(settings.getBoolean("GLDataEffectiveDebug"));
        this.glData.alphaSize = settings.getAlphaBits();
        this.glData.sRGB = settings.isGammaCorrection();
        this.glData.depthSize = settings.getDepthBits();
        this.glData.stencilSize = settings.getStencilBits();
        this.glData.samples = settings.getSamples();
        this.glData.stereo = settings.useStereo3D();
        this.glData.debug = settings.isGraphicsDebug();
        this.glData.api = GLData.API.GL;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    protected void showWindow() {
    }

    @Override
    protected void setWindowIcon(AppSettings settings) {
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public KeyInput getKeyInput() {
        if (this.keyInput == null) {
            this.keyInput = new AwtKeyInput();
            this.keyInput.setInputSource((Component)this.canvas);
        }
        return this.keyInput;
    }

    @Override
    public MouseInput getMouseInput() {
        if (this.mouseInput == null) {
            this.mouseInput = new AwtMouseInput();
            this.mouseInput.setInputSource((Component)this.canvas);
        }
        return this.mouseInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkVisibilityState() {
        if (!this.hasNativePeer.get()) {
            Object object = this.lock;
            synchronized (object) {
                this.canvas.doDisposeCanvas();
            }
            return false;
        }
        boolean currentShowing = this.canvas.isShowing();
        this.showing.set(currentShowing);
        return currentShowing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyContext() {
        Object object = this.lock;
        synchronized (object) {
            this.canvas.destroy();
        }
        this.signalTerminate.release();
        super.destroyContext();
    }

    @Override
    protected void runLoop() {
        if (this.needResize.get()) {
            this.needResize.set(false);
            this.settings.setResolution(this.framebufferWidth, this.framebufferHeight);
            this.listener.reshape(this.framebufferWidth, this.framebufferHeight);
        }
        if (!this.checkVisibilityState()) {
            return;
        }
        this.canvas.beforeRender();
        try {
            super.runLoop();
            if (this.allowSwapBuffers && this.autoFlush) {
                this.canvas.swapBuffers();
            }
        }
        finally {
            this.canvas.afterRender();
        }
        Toolkit.getDefaultToolkit().sync();
        if (this.showGLDataEffective.get()) {
            this.showGLDataEffective.set(false);
            System.out.println(MessageFormat.format("[ DEBUGGER ] :Effective data to initialize the LWJGL3-AWT context\n{0}", this.getPrintContextInitInfo(this.canvas.getGLDataEffective())));
        }
        try {
            if (this.signalTerminate.tryAcquire(10L, TimeUnit.MILLISECONDS)) {
                this.canvas.doDisposeCanvas();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void printContextInitInfo() {
        super.printContextInitInfo();
        LOGGER.log(Level.INFO, "Initializing LWJGL3-AWT with jMonkeyEngine\n{0}", this.getPrintContextInitInfo(this.glData));
    }

    protected String getPrintContextInitInfo(GLData glData) {
        StringBuilder sb = new StringBuilder();
        sb.append(" *  Double Buffer: ").append(glData.doubleBuffer);
        sb.append('\n').append(" *  Stereo: ").append(glData.stereo);
        sb.append('\n').append(" *  Red Size: ").append(glData.redSize);
        sb.append('\n').append(" *  Green Size: ").append(glData.greenSize);
        sb.append('\n').append(" *  Blue Size: ").append(glData.blueSize);
        sb.append('\n').append(" *  Alpha Size: ").append(glData.alphaSize);
        sb.append('\n').append(" *  Depth Size: ").append(glData.depthSize);
        sb.append('\n').append(" *  Stencil Size: ").append(glData.stencilSize);
        sb.append('\n').append(" *  Accum Red Size: ").append(glData.accumRedSize);
        sb.append('\n').append(" *  Accum Green Size: ").append(glData.accumGreenSize);
        sb.append('\n').append(" *  Accum Blue Size: ").append(glData.accumBlueSize);
        sb.append('\n').append(" *  Accum Alpha Size: ").append(glData.accumAlphaSize);
        sb.append('\n').append(" *  Sample Buffers: ").append(glData.sampleBuffers);
        sb.append('\n').append(" *  Share Context: ").append(glData.shareContext);
        sb.append('\n').append(" *  Major Version: ").append(glData.majorVersion);
        sb.append('\n').append(" *  Minor Version: ").append(glData.minorVersion);
        sb.append('\n').append(" *  Forward Compatible: ").append(glData.forwardCompatible);
        sb.append('\n').append(" *  Profile: ").append(glData.profile);
        sb.append('\n').append(" *  API: ").append(glData.api);
        sb.append('\n').append(" *  Debug: ").append(glData.debug);
        sb.append('\n').append(" *  Swap Interval: ").append(glData.swapInterval);
        sb.append('\n').append(" *  SRGB (Gamma Correction): ").append(glData.sRGB);
        sb.append('\n').append(" *  Pixel Format Float: ").append(glData.pixelFormatFloat);
        sb.append('\n').append(" *  Context Release Behavior: ").append(glData.contextReleaseBehavior);
        sb.append('\n').append(" *  Color Samples NV: ").append(glData.colorSamplesNV);
        sb.append('\n').append(" *  Swap Group NV: ").append(glData.swapGroupNV);
        sb.append('\n').append(" *  Swap Barrier NV: ").append(glData.swapBarrierNV);
        sb.append('\n').append(" *  Robustness: ").append(glData.robustness);
        sb.append('\n').append(" *  Lose Context On Reset: ").append(glData.loseContextOnReset);
        sb.append('\n').append(" *  Context Reset Isolation: ").append(glData.contextResetIsolation);
        return String.valueOf(sb);
    }

    @Override
    public int getFramebufferHeight() {
        return this.framebufferHeight;
    }

    @Override
    public int getFramebufferWidth() {
        return this.framebufferWidth;
    }

    static {
        RENDER_CONFIGS.put("LWJGL-OpenGL30", data -> {
            data.majorVersion = 3;
            data.minorVersion = 0;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL31", data -> {
            data.majorVersion = 3;
            data.minorVersion = 1;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL3", data -> {
            data.majorVersion = 3;
            data.minorVersion = 2;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL33", data -> {
            data.majorVersion = 3;
            data.minorVersion = 3;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL4", data -> {
            data.majorVersion = 4;
            data.minorVersion = 0;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL41", data -> {
            data.majorVersion = 4;
            data.minorVersion = 1;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL42", data -> {
            data.majorVersion = 4;
            data.minorVersion = 2;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL43", data -> {
            data.majorVersion = 4;
            data.minorVersion = 3;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL44", data -> {
            data.majorVersion = 4;
            data.minorVersion = 4;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL45", data -> {
            data.majorVersion = 4;
            data.minorVersion = 5;
            data.profile = GLData.Profile.COMPATIBILITY;
        });
    }

    private class LwjglAWTGLCanvas
    extends Canvas {
        private LwjglxGLPlatform platformCanvas;
        private long context = 0L;
        private GLData data;
        private GLData effective = new GLData();

        public LwjglAWTGLCanvas(GLData data) {
            this.data = data;
            try {
                this.platformCanvas = LwjglxDefaultGLPlatform.createLwjglxGLPlatform();
            }
            catch (UnsupportedOperationException e) {
                LwjglCanvas.this.listener.handleError(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        @Override
        public synchronized void addComponentListener(ComponentListener l) {
            super.addComponentListener(l);
        }

        public GLData getGLDataEffective() {
            return this.effective;
        }

        public void afterRender() {
            this.platformCanvas.makeCurrent(0L);
            try {
                this.platformCanvas.unlock();
            }
            catch (AWTException e) {
                LwjglCanvas.this.listener.handleError("Failed to unlock Canvas", (Throwable)e);
            }
        }

        public void beforeRender() {
            if (this.context == 0L) {
                try {
                    this.context = this.platformCanvas.create(this, this.data, this.effective);
                }
                catch (AWTException e) {
                    LwjglCanvas.this.listener.handleError("Exception while creating the OpenGL context", (Throwable)e);
                    return;
                }
            }
            try {
                this.platformCanvas.lock();
            }
            catch (AWTException e) {
                LwjglCanvas.this.listener.handleError("Failed to lock Canvas", (Throwable)e);
            }
            this.platformCanvas.makeCurrent(this.context);
        }

        public void doDisposeCanvas() {
            if (OS != Platform.LINUX) {
                this.platformCanvas.dispose();
            }
        }

        public void swapBuffers() {
            this.platformCanvas.swapBuffers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotify() {
            super.addNotify();
            Object object = LwjglCanvas.this.lock;
            synchronized (object) {
                LwjglCanvas.this.hasNativePeer.set(true);
            }
            this.requestFocusInWindow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotify() {
            Object object = LwjglCanvas.this.lock;
            synchronized (object) {
                if (OS != Platform.LINUX && this.context != 0L) {
                    this.platformCanvas.deleteContext(this.context);
                    this.context = 0L;
                }
                LwjglCanvas.this.hasNativePeer.set(false);
            }
            super.removeNotify();
            if (OS == Platform.WINDOWS) {
                LOGGER.log(Level.WARNING, "Windows does not support this functionality: remove(__canvas__)");
            }
        }

        public void destroy() {
            this.platformCanvas.destroy();
        }

        @Override
        public Graphics getGraphics() {
            Graphics graphics = super.getGraphics();
            if (graphics instanceof Graphics2D) {
                return new NonClearGraphics2D((Graphics2D)graphics);
            }
            return new NonClearGraphics(graphics);
        }
    }
}

