/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.Utils;
import org.lwjgl.opencl.CL10;

public class LwjglCommandQueue
extends CommandQueue {
    private final long queue;

    public LwjglCommandQueue(long queue, Device device) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(queue), device);
        this.queue = queue;
    }

    public long getQueue() {
        return this.queue;
    }

    public void flush() {
        int ret = CL10.clFlush((long)this.queue);
        Utils.checkError(ret, "clFlush");
    }

    public void finish() {
        int ret = CL10.clFinish((long)this.queue);
        Utils.checkError(ret, "clFinish");
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long queue;

        private ReleaserImpl(long queue) {
            this.queue = queue;
        }

        public void release() {
            if (this.queue != 0L) {
                int ret = CL10.clReleaseCommandQueue((long)this.queue);
                this.queue = 0L;
                Utils.reportError(ret, "clReleaseCommandQueue");
            }
        }
    }
}

