/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Event;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.util.logging.Logger;
import org.lwjgl.opencl.CL10;

public class LwjglEvent
extends Event {
    private static final Logger LOG = Logger.getLogger(LwjglEvent.class.getName());
    private long event;

    public LwjglEvent(long event) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(event));
        this.event = event;
    }

    public long getEvent() {
        return this.event;
    }

    public void waitForFinished() {
        CL10.clWaitForEvents((long)this.event);
        this.release();
    }

    public boolean isCompleted() {
        int status = Info.clGetEventInfoInt(this.event, 4563);
        if (status == 0) {
            this.release();
            return true;
        }
        if (status < 0) {
            Utils.checkError(status, "EventStatus");
            return false;
        }
        return false;
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long event;

        private ReleaserImpl(long event) {
            this.event = event;
        }

        public void release() {
            if (this.event != 0L) {
                int ret = CL10.clReleaseEvent((long)this.event);
                this.event = 0L;
                Utils.reportError(ret, "clReleaseEvent");
                LOG.finer("Event deleted");
            }
        }
    }
}

