/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.plugins;

import com.jme3.util.IntMap;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedOggStream
implements PhysicalOggStream {
    private boolean closed = false;
    private boolean eos = false;
    private InputStream sourceStream;
    private HashMap<Integer, LogicalOggStream> logicalStreams = new HashMap();
    private IntMap<OggPage> oggPages = new IntMap();
    private OggPage lastPage;
    private int pageNumber;
    private int serialNumber;

    public CachedOggStream(InputStream in) throws IOException {
        this.sourceStream = in;
        long time = System.nanoTime();
        while (!this.eos) {
            this.readOggNextPage();
        }
        long dt = System.nanoTime() - time;
        Logger.getLogger(CachedOggStream.class.getName()).log(Level.FINE, "Took {0} ms to load OGG", dt / 1000000L);
    }

    public OggPage getLastOggPage() {
        return this.lastPage;
    }

    public Collection<LogicalOggStream> getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    public OggPage getOggPage(int index) throws IOException {
        return (OggPage)this.oggPages.get(index);
    }

    public void setTime(long granulePosition) throws IOException {
        for (LogicalOggStream los : this.getLogicalStreams()) {
            los.setTime(granulePosition);
        }
    }

    public LogicalOggStream reloadLogicalOggStream() {
        this.logicalStreams.clear();
        LogicalOggStreamImpl los = new LogicalOggStreamImpl((PhysicalOggStream)this, this.serialNumber);
        this.logicalStreams.put(this.serialNumber, (LogicalOggStream)los);
        for (IntMap.Entry entry : this.oggPages) {
            los.addPageNumberMapping(entry.getKey());
            los.addGranulePosition(((OggPage)entry.getValue()).getAbsoluteGranulePosition());
        }
        return los;
    }

    private int readOggNextPage() throws IOException {
        LogicalOggStreamImpl los;
        if (this.eos) {
            return -1;
        }
        OggPage op = OggPage.create((InputStream)this.sourceStream);
        op.isBos();
        if (op.isEos()) {
            this.eos = true;
            this.lastPage = op;
        }
        if ((los = (LogicalOggStreamImpl)this.logicalStreams.get(op.getStreamSerialNumber())) == null) {
            this.serialNumber = op.getStreamSerialNumber();
            los = new LogicalOggStreamImpl((PhysicalOggStream)this, op.getStreamSerialNumber());
            this.logicalStreams.put(op.getStreamSerialNumber(), (LogicalOggStream)los);
            los.checkFormat(op);
        }
        los.addPageNumberMapping(this.pageNumber);
        los.addGranulePosition(op.getAbsoluteGranulePosition());
        this.oggPages.put(this.pageNumber, (Object)op);
        ++this.pageNumber;
        return this.pageNumber - 1;
    }

    public boolean isSeekable() {
        return true;
    }
}

