/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.app.Application;
import com.jme3.app.VRAppState;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.debug.BulletCharacterDebugControl;
import com.jme3.bullet.debug.BulletGhostObjectDebugControl;
import com.jme3.bullet.debug.BulletJointDebugControl;
import com.jme3.bullet.debug.BulletRigidBodyDebugControl;
import com.jme3.bullet.debug.BulletVehicleDebugControl;
import com.jme3.bullet.debug.DebugTools;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BulletDebugAppState
extends AbstractAppState {
    protected static final Logger logger = Logger.getLogger(BulletDebugAppState.class.getName());
    private Boolean isVr = null;
    protected DebugAppStateFilter filter;
    protected Application app;
    protected AssetManager assetManager;
    protected final PhysicsSpace space;
    protected final Node physicsDebugRootNode = new Node("Physics Debug Root Node");
    protected ViewPort viewPort;
    protected RenderManager rm;
    public Material DEBUG_BLUE;
    public Material DEBUG_RED;
    public Material DEBUG_GREEN;
    public Material DEBUG_YELLOW;
    public Material DEBUG_MAGENTA;
    public Material DEBUG_PINK;
    protected HashMap<PhysicsRigidBody, Spatial> bodies = new HashMap();
    protected HashMap<PhysicsJoint, Spatial> joints = new HashMap();
    protected HashMap<PhysicsGhostObject, Spatial> ghosts = new HashMap();
    protected HashMap<PhysicsCharacter, Spatial> characters = new HashMap();
    protected HashMap<PhysicsVehicle, Spatial> vehicles = new HashMap();

    public BulletDebugAppState(PhysicsSpace space) {
        this.space = space;
    }

    public DebugTools getNewDebugTools() {
        return new DebugTools(this.assetManager);
    }

    public void setFilter(DebugAppStateFilter filter) {
        this.filter = filter;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = app;
        this.rm = app.getRenderManager();
        this.assetManager = app.getAssetManager();
        this.setupMaterials(app);
        this.physicsDebugRootNode.setCullHint(Spatial.CullHint.Never);
        if (this.isVr()) {
            VRAppState vrAppState = (VRAppState)stateManager.getState("VRAppState", VRAppState.class);
            vrAppState.getLeftViewPort().attachScene((Spatial)this.physicsDebugRootNode);
            vrAppState.getRightViewPort().attachScene((Spatial)this.physicsDebugRootNode);
        } else {
            this.viewPort = this.rm.createMainView("Physics Debug Overlay", app.getCamera());
            this.viewPort.setClearFlags(false, true, false);
            this.viewPort.attachScene((Spatial)this.physicsDebugRootNode);
        }
    }

    public void cleanup() {
        if (this.isVr()) {
            VRAppState vrAppState = (VRAppState)this.app.getStateManager().getState("VRAppState", VRAppState.class);
            vrAppState.getLeftViewPort().detachScene((Spatial)this.physicsDebugRootNode);
            vrAppState.getRightViewPort().detachScene((Spatial)this.physicsDebugRootNode);
        } else {
            this.rm.removeMainView(this.viewPort);
        }
        super.cleanup();
    }

    public void update(float tpf) {
        super.update(tpf);
        this.updateRigidBodies();
        this.updateGhosts();
        this.updateCharacters();
        this.updateJoints();
        this.updateVehicles();
        this.physicsDebugRootNode.updateLogicalState(tpf);
        this.physicsDebugRootNode.updateGeometricState();
    }

    public void render(RenderManager rm) {
        super.render(rm);
        if (this.viewPort != null) {
            rm.renderScene((Spatial)this.physicsDebugRootNode, this.viewPort);
        }
    }

    private void setupMaterials(Application app) {
        AssetManager manager = app.getAssetManager();
        this.DEBUG_BLUE = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_BLUE.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_BLUE.setColor("Color", ColorRGBA.Blue);
        this.DEBUG_GREEN = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_GREEN.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_GREEN.setColor("Color", ColorRGBA.Green);
        this.DEBUG_RED = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_RED.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_RED.setColor("Color", ColorRGBA.Red);
        this.DEBUG_YELLOW = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_YELLOW.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_YELLOW.setColor("Color", ColorRGBA.Yellow);
        this.DEBUG_MAGENTA = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_MAGENTA.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_MAGENTA.setColor("Color", ColorRGBA.Magenta);
        this.DEBUG_PINK = new Material(manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_PINK.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_PINK.setColor("Color", ColorRGBA.Pink);
    }

    private void updateRigidBodies() {
        HashMap<PhysicsRigidBody, Spatial> oldObjects = this.bodies;
        this.bodies = new HashMap();
        Collection<PhysicsRigidBody> current = this.space.getRigidBodyList();
        for (PhysicsRigidBody physicsObject : current) {
            if (oldObjects.containsKey(physicsObject)) {
                Spatial spat = oldObjects.get(physicsObject);
                this.bodies.put(physicsObject, spat);
                oldObjects.remove(physicsObject);
                continue;
            }
            if (this.filter != null && !this.filter.displayObject(physicsObject)) continue;
            logger.log(Level.FINE, "Create new debug RigidBody");
            Node node = new Node(physicsObject.toString());
            node.addControl((Control)new BulletRigidBodyDebugControl(this, physicsObject));
            this.bodies.put(physicsObject, (Spatial)node);
            this.physicsDebugRootNode.attachChild((Spatial)node);
        }
        for (Map.Entry<PhysicsRigidBody, Spatial> entry : oldObjects.entrySet()) {
            PhysicsRigidBody object = entry.getKey();
            Spatial spatial = entry.getValue();
            spatial.removeFromParent();
        }
    }

    private void updateJoints() {
        HashMap<PhysicsJoint, Spatial> oldObjects = this.joints;
        this.joints = new HashMap();
        Collection<PhysicsJoint> current = this.space.getJointList();
        for (PhysicsJoint physicsObject : current) {
            if (oldObjects.containsKey(physicsObject)) {
                Spatial spat = oldObjects.get(physicsObject);
                this.joints.put(physicsObject, spat);
                oldObjects.remove(physicsObject);
                continue;
            }
            if (this.filter != null && !this.filter.displayObject(physicsObject)) continue;
            logger.log(Level.FINE, "Create new debug Joint");
            Node node = new Node(physicsObject.toString());
            node.addControl((Control)new BulletJointDebugControl(this, physicsObject));
            this.joints.put(physicsObject, (Spatial)node);
            this.physicsDebugRootNode.attachChild((Spatial)node);
        }
        for (Map.Entry<PhysicsJoint, Spatial> entry : oldObjects.entrySet()) {
            PhysicsJoint object = entry.getKey();
            Spatial spatial = entry.getValue();
            spatial.removeFromParent();
        }
    }

    private void updateGhosts() {
        HashMap<PhysicsGhostObject, Spatial> oldObjects = this.ghosts;
        this.ghosts = new HashMap();
        Collection<PhysicsGhostObject> current = this.space.getGhostObjectList();
        for (PhysicsGhostObject physicsObject : current) {
            if (oldObjects.containsKey(physicsObject)) {
                Spatial spat = oldObjects.get(physicsObject);
                this.ghosts.put(physicsObject, spat);
                oldObjects.remove(physicsObject);
                continue;
            }
            if (this.filter != null && !this.filter.displayObject(physicsObject)) continue;
            logger.log(Level.FINE, "Create new debug GhostObject");
            Node node = new Node(physicsObject.toString());
            node.addControl((Control)new BulletGhostObjectDebugControl(this, physicsObject));
            this.ghosts.put(physicsObject, (Spatial)node);
            this.physicsDebugRootNode.attachChild((Spatial)node);
        }
        for (Map.Entry<PhysicsGhostObject, Spatial> entry : oldObjects.entrySet()) {
            PhysicsGhostObject object = entry.getKey();
            Spatial spatial = entry.getValue();
            spatial.removeFromParent();
        }
    }

    private void updateCharacters() {
        HashMap<PhysicsCharacter, Spatial> oldObjects = this.characters;
        this.characters = new HashMap();
        Collection<PhysicsCharacter> current = this.space.getCharacterList();
        for (PhysicsCharacter physicsObject : current) {
            if (oldObjects.containsKey(physicsObject)) {
                Spatial spat = oldObjects.get(physicsObject);
                this.characters.put(physicsObject, spat);
                oldObjects.remove(physicsObject);
                continue;
            }
            if (this.filter != null && !this.filter.displayObject(physicsObject)) continue;
            logger.log(Level.FINE, "Create new debug Character");
            Node node = new Node(physicsObject.toString());
            node.addControl((Control)new BulletCharacterDebugControl(this, physicsObject));
            this.characters.put(physicsObject, (Spatial)node);
            this.physicsDebugRootNode.attachChild((Spatial)node);
        }
        for (Map.Entry<PhysicsCharacter, Spatial> entry : oldObjects.entrySet()) {
            PhysicsCharacter object = entry.getKey();
            Spatial spatial = entry.getValue();
            spatial.removeFromParent();
        }
    }

    private void updateVehicles() {
        HashMap<PhysicsVehicle, Spatial> oldObjects = this.vehicles;
        this.vehicles = new HashMap();
        Collection<PhysicsVehicle> current = this.space.getVehicleList();
        for (PhysicsVehicle physicsObject : current) {
            if (oldObjects.containsKey(physicsObject)) {
                Spatial spat = oldObjects.get(physicsObject);
                this.vehicles.put(physicsObject, spat);
                oldObjects.remove(physicsObject);
                continue;
            }
            if (this.filter != null && !this.filter.displayObject(physicsObject)) continue;
            logger.log(Level.FINE, "Create new debug Vehicle");
            Node node = new Node(physicsObject.toString());
            node.addControl((Control)new BulletVehicleDebugControl(this, physicsObject));
            this.vehicles.put(physicsObject, (Spatial)node);
            this.physicsDebugRootNode.attachChild((Spatial)node);
        }
        for (Map.Entry<PhysicsVehicle, Spatial> entry : oldObjects.entrySet()) {
            PhysicsVehicle object = entry.getKey();
            Spatial spatial = entry.getValue();
            spatial.removeFromParent();
        }
    }

    private boolean isVr() {
        if (this.isVr == null) {
            try {
                VRAppState vrAppState = (VRAppState)this.app.getStateManager().getState("VRAppState", VRAppState.class);
                this.isVr = vrAppState != null && !vrAppState.DISABLE_VR;
            }
            catch (NoClassDefFoundError e) {
                this.isVr = false;
            }
        }
        return this.isVr;
    }

    public static interface DebugAppStateFilter {
        public boolean displayObject(Object var1);
    }
}

