/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class RigidBodyControl
extends PhysicsRigidBody
implements PhysicsControl,
JmeCloneable {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected boolean kinematicSpatial = true;

    protected RigidBodyControl() {
    }

    public RigidBodyControl(float mass) {
        this.mass = mass;
    }

    public RigidBodyControl(CollisionShape shape) {
        super(shape);
    }

    public RigidBodyControl(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException();
    }

    public Object jmeClone() {
        RigidBodyControl control = new RigidBodyControl(this.collisionShape, this.mass);
        control.setAngularFactor(this.getAngularFactor());
        control.setAngularSleepingThreshold(this.getAngularSleepingThreshold());
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setContactResponse(this.isContactResponse());
        control.setDamping(this.getLinearDamping(), this.getAngularDamping());
        control.setFriction(this.getFriction());
        control.setGravity(this.getGravity());
        control.setKinematic(this.isKinematic());
        control.setKinematicSpatial(this.isKinematicSpatial());
        control.setLinearSleepingThreshold(this.getLinearSleepingThreshold());
        control.setPhysicsLocation(this.getPhysicsLocation(null));
        control.setPhysicsRotation(this.getPhysicsRotationMatrix(null));
        control.setRestitution(this.getRestitution());
        if (this.mass > 0.0f) {
            control.setAngularVelocity(this.getAngularVelocity());
            control.setLinearVelocity(this.getLinearVelocity());
        }
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        control.spatial = this.spatial;
        control.setEnabled(this.isEnabled());
        return control;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
        this.setUserObject(spatial);
        if (spatial == null) {
            return;
        }
        if (this.collisionShape == null) {
            this.createCollisionShape();
            this.rebuildRigidBody();
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    protected void createCollisionShape() {
        if (this.spatial == null) {
            return;
        }
        if (this.spatial instanceof Geometry) {
            Geometry geom = (Geometry)this.spatial;
            Mesh mesh = geom.getMesh();
            if (mesh instanceof Sphere) {
                this.collisionShape = new SphereCollisionShape(((Sphere)mesh).getRadius());
                return;
            }
            if (mesh instanceof Box) {
                this.collisionShape = new BoxCollisionShape(new Vector3f(((Box)mesh).getXExtent(), ((Box)mesh).getYExtent(), ((Box)mesh).getZExtent()));
                return;
            }
        }
        this.collisionShape = this.mass > 0.0f ? CollisionShapeFactory.createDynamicMeshShape(this.spatial) : CollisionShapeFactory.createMeshShape(this.spatial);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isKinematicSpatial() {
        return this.kinematicSpatial;
    }

    public void setKinematicSpatial(boolean kinematicSpatial) {
        this.kinematicSpatial = kinematicSpatial;
    }

    public boolean isApplyPhysicsLocal() {
        return this.motionState.isApplyPhysicsLocal();
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.motionState.setApplyPhysicsLocal(applyPhysicsLocal);
    }

    private Vector3f getSpatialTranslation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public void update(float tpf) {
        if (this.enabled && this.spatial != null) {
            if (this.isKinematic() && this.kinematicSpatial) {
                super.setPhysicsLocation(this.getSpatialTranslation());
                super.setPhysicsRotation(this.getSpatialRotation());
            } else {
                this.getMotionState().applyTransform(this.spatial);
            }
        }
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.space.removeCollisionObject(this);
            this.added = false;
        }
        if (newSpace != null && this.isEnabled()) {
            newSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = newSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.motionState.isApplyPhysicsLocal(), "applyLocalPhysics", false);
        oc.write(this.kinematicSpatial, "kinematicSpatial", true);
        oc.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.kinematicSpatial = ic.readBoolean("kinematicSpatial", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.motionState.setApplyPhysicsLocal(ic.readBoolean("applyLocalPhysics", false));
        this.setUserObject(this.spatial);
    }
}

