/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class VectorSet {
    private static final Logger logger = Logger.getLogger(VectorSet.class.getName());
    private final Set<Vector3f> set;

    public VectorSet(int numVectors) {
        this.set = new HashSet<Vector3f>(numVectors);
    }

    public void add(Vector3f vector) {
        this.set.add(vector.clone());
    }

    public boolean contains(Vector3f vector) {
        boolean result = this.set.contains(vector);
        return result;
    }

    public Vector3f mean(Vector3f storeResult) {
        int numVectors = this.numVectors();
        assert (numVectors > 0) : numVectors;
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (Vector3f tempVector : this.set) {
            result.addLocal(tempVector);
        }
        result.divideLocal((float)numVectors);
        return result;
    }

    public int numVectors() {
        int numVectors = this.set.size();
        assert (numVectors >= 0) : numVectors;
        return numVectors;
    }

    public FloatBuffer toBuffer() {
        int numFloats = 3 * this.set.size();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)numFloats);
        for (Vector3f tempVector : this.set) {
            buffer.put(tempVector.x);
            buffer.put(tempVector.y);
            buffer.put(tempVector.z);
        }
        buffer.flip();
        return buffer;
    }
}

