/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PhysicsLink
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(PhysicsLink.class.getName());
    private ArrayList<PhysicsLink> children = new ArrayList(8);
    private Joint bone;
    private DacLinks control;
    private float blendInterval = 1.0f;
    private float kinematicWeight = 1.0f;
    private PhysicsJoint joint = null;
    private PhysicsLink parent = null;
    private PhysicsRigidBody rigidBody;
    private Transform kpTransform = new Transform();
    private Vector3f kpVelocity = new Vector3f();
    private Vector3f localOffset;

    protected PhysicsLink() {
    }

    PhysicsLink(DacLinks control, Joint bone, CollisionShape collisionShape, float mass, Vector3f localOffset) {
        assert (control != null);
        assert (bone != null);
        assert (collisionShape != null);
        assert (localOffset != null);
        this.control = control;
        this.bone = bone;
        this.rigidBody = this.createRigidBody(mass, collisionShape);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating link for bone {0} with mass={1}", new Object[]{bone.getName(), Float.valueOf(this.rigidBody.getMass())});
        }
        this.localOffset = localOffset.clone();
        this.updateKPTransform();
    }

    public String boneName() {
        String boneName = this.bone.getName();
        assert (boneName != null);
        return boneName;
    }

    public int countChildren() {
        int numChildren = this.children.size();
        return numChildren;
    }

    public final Joint getBone() {
        assert (this.bone != null);
        return this.bone;
    }

    public DacLinks getControl() {
        assert (this.control != null);
        return this.control;
    }

    public PhysicsJoint getJoint() {
        return this.joint;
    }

    public PhysicsLink getParent() {
        return this.parent;
    }

    public PhysicsRigidBody getRigidBody() {
        assert (this.rigidBody != null);
        return this.rigidBody;
    }

    public boolean isKinematic() {
        return this.kinematicWeight > 0.0f;
    }

    public float kinematicWeight() {
        assert (this.kinematicWeight >= 0.0f) : this.kinematicWeight;
        assert (this.kinematicWeight <= 1.0f) : this.kinematicWeight;
        return this.kinematicWeight;
    }

    public PhysicsLink[] listChildren() {
        int numChildren = this.children.size();
        PhysicsLink[] result = new PhysicsLink[numChildren];
        this.children.toArray(result);
        return result;
    }

    public abstract String name();

    public Transform physicsTransform(Transform storeResult) {
        Transform result;
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (this.isKinematic()) {
            result.set(this.kpTransform);
        } else {
            this.rigidBody.getPhysicsLocation(result.getTranslation());
            this.rigidBody.getPhysicsRotation(result.getRotation());
            result.setScale(this.rigidBody.getCollisionShape().getScale());
        }
        return result;
    }

    void postRebuild(PhysicsLink oldLink) {
        assert (oldLink != null);
        assert (oldLink.bone == this.bone);
        if (oldLink.isKinematic()) {
            this.blendInterval = oldLink.blendInterval;
            this.kinematicWeight = oldLink.kinematicWeight;
        } else {
            this.blendInterval = 0.0f;
            this.kinematicWeight = 1.0f;
        }
    }

    void postTick() {
        if (!this.isKinematic()) {
            this.rigidBody.activate();
        }
    }

    void preTick(float timeStep) {
        if (this.isKinematic()) {
            this.rigidBody.setPhysicsLocation(this.kpTransform.getTranslation());
            this.rigidBody.setPhysicsRotation(this.kpTransform.getRotation());
            this.rigidBody.getCollisionShape().setScale(this.kpTransform.getScale());
        }
    }

    public void setDynamic(Vector3f uniformAcceleration) {
        this.control.verifyReadyForDynamicMode("put link into dynamic mode");
        this.setKinematicWeight(0.0f);
        this.rigidBody.setGravity(uniformAcceleration);
    }

    void update(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        if (this.kinematicWeight > 0.0f) {
            this.kinematicUpdate(tpf);
        } else {
            this.dynamicUpdate();
        }
    }

    Vector3f velocity(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (this.isKinematic()) {
            result.set(this.kpVelocity);
        } else {
            assert (!this.rigidBody.isKinematic());
            this.rigidBody.getLinearVelocity(result);
        }
        return result;
    }

    protected void blendToKinematicMode(float blendInterval) {
        assert (blendInterval >= 0.0f) : blendInterval;
        this.blendInterval = blendInterval;
        this.setKinematicWeight(Float.MIN_VALUE);
    }

    protected abstract void dynamicUpdate();

    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.rigidBody.isKinematic());
        if (this.blendInterval == 0.0f) {
            this.setKinematicWeight(1.0f);
        } else {
            this.setKinematicWeight(this.kinematicWeight + tpf / this.blendInterval);
        }
        Vector3f previousLocation = this.kpTransform.getTranslation(null);
        this.updateKPTransform();
        if (tpf > 0.0f) {
            this.kpTransform.getTranslation().subtract(previousLocation, this.kpVelocity);
            this.kpVelocity.divideLocal(tpf);
        }
    }

    protected Vector3f localOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.localOffset);
        return result;
    }

    protected final void setJoint(PhysicsJoint joint) {
        this.joint = joint;
    }

    protected final void setParent(PhysicsLink parent) {
        assert (parent != null);
        assert (this.parent == null);
        this.parent = parent;
        parent.children.add(this);
    }

    protected void setRigidBody(PhysicsRigidBody body) {
        assert (body != null);
        assert (this.rigidBody != null);
        this.rigidBody = body;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.bone = (Joint)cloner.clone((Object)this.bone);
        this.control = (DacLinks)cloner.clone((Object)this.control);
        this.children = (ArrayList)cloner.clone(this.children);
        this.joint = (PhysicsJoint)cloner.clone((Object)this.joint);
        this.parent = (PhysicsLink)cloner.clone((Object)this.parent);
        this.rigidBody = (PhysicsRigidBody)cloner.clone((Object)this.rigidBody);
        this.kpTransform = (Transform)cloner.clone((Object)this.kpTransform);
        this.kpVelocity = (Vector3f)cloner.clone((Object)this.kpVelocity);
        this.localOffset = (Vector3f)cloner.clone((Object)this.localOffset);
    }

    public PhysicsLink jmeClone() {
        try {
            PhysicsLink clone = (PhysicsLink)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        this.children = ic.readSavableArrayList("children", new ArrayList(1));
        this.bone = (Joint)ic.readSavable("bone", null);
        this.control = (DacLinks)ic.readSavable("control", null);
        this.blendInterval = ic.readFloat("blendInterval", 1.0f);
        this.kinematicWeight = ic.readFloat("kinematicWeight", 1.0f);
        this.joint = (PhysicsJoint)ic.readSavable("joint", null);
        this.parent = (PhysicsLink)ic.readSavable("parent", null);
        this.rigidBody = (PhysicsRigidBody)ic.readSavable("rigidBody", null);
        this.kpTransform = (Transform)ic.readSavable("kpTransform", (Savable)new Transform());
        this.kpVelocity = (Vector3f)ic.readSavable("kpVelocity", (Savable)new Vector3f());
        this.localOffset = (Vector3f)ic.readSavable("offset", (Savable)new Vector3f());
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.writeSavableArrayList(this.children, "children", null);
        oc.write((Savable)this.bone, "bone", null);
        oc.write((Savable)this.control, "control", null);
        oc.write(this.blendInterval, "blendInterval", 1.0f);
        oc.write(this.kinematicWeight, "kinematicWeight", 1.0f);
        oc.write((Savable)this.joint, "joint", null);
        oc.write((Savable)this.parent, "parent", null);
        oc.write((Savable)this.rigidBody, "rigidBody", null);
        oc.write((Savable)this.kpTransform, "kpTransform", null);
        oc.write((Savable)this.kpVelocity, "kpVelocity", null);
        oc.write((Savable)this.localOffset, "offset", null);
    }

    private PhysicsRigidBody createRigidBody(float mass, CollisionShape collisionShape) {
        assert (collisionShape != null);
        PhysicsRigidBody body = new PhysicsRigidBody(collisionShape, mass);
        float viscousDamping = this.control.damping();
        body.setDamping(viscousDamping, viscousDamping);
        body.setKinematic(true);
        body.setUserObject(this);
        return body;
    }

    private void setKinematicWeight(float weight) {
        boolean isKinematic;
        assert (weight >= 0.0f) : weight;
        boolean wasKinematic = this.kinematicWeight > 0.0f;
        this.kinematicWeight = weight > 1.0f ? 1.0f : weight;
        boolean bl = isKinematic = this.kinematicWeight > 0.0f;
        if (wasKinematic && !isKinematic) {
            this.rigidBody.setKinematic(false);
            this.rigidBody.setPhysicsLocation(this.kpTransform.getTranslation());
            this.rigidBody.setPhysicsRotation(this.kpTransform.getRotation());
            this.rigidBody.getCollisionShape().setScale(this.kpTransform.getScale());
            this.rigidBody.setLinearVelocity(this.kpVelocity);
        } else if (isKinematic && !wasKinematic) {
            this.rigidBody.getPhysicsLocation(this.kpTransform.getTranslation());
            this.rigidBody.getPhysicsRotation(this.kpTransform.getRotation());
            Vector3f scale = this.rigidBody.getCollisionShape().getScale();
            this.kpTransform.setScale(scale);
            this.rigidBody.getLinearVelocity(this.kpVelocity);
            this.rigidBody.setKinematic(true);
        }
    }

    private void updateKPTransform() {
        this.control.physicsTransform(this.bone, this.localOffset, this.kpTransform);
    }
}

