/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DacConfiguration
extends AbstractPhysicsControl {
    public static final Logger logger2 = Logger.getLogger(DacConfiguration.class.getName());
    public static final String torsoName = "";
    private float damping = 0.6f;
    private float eventDispatchImpulseThreshold = 0.0f;
    private float torsoMass = 1.0f;
    private Map<String, Float> blConfigMap = new HashMap<String, Float>(50);
    private Map<String, RangeOfMotion> jointMap = new HashMap<String, RangeOfMotion>(50);
    private Vector3f gravityVector = new Vector3f(0.0f, -9.8f, 0.0f);

    DacConfiguration() {
    }

    public int countLinkedBones() {
        int count = this.blConfigMap.size();
        assert (count == this.jointMap.size());
        assert (count >= 0) : count;
        return count;
    }

    public int countLinks() {
        int result = this.countLinkedBones() + 1;
        return result;
    }

    public float damping() {
        assert (this.damping >= 0.0f) : this.damping;
        return this.damping;
    }

    public float eventDispatchImpulseThreshold() {
        assert (this.eventDispatchImpulseThreshold >= 0.0f);
        return this.eventDispatchImpulseThreshold;
    }

    public RangeOfMotion getJointLimits(String boneName) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + boneName;
            throw new IllegalArgumentException(msg);
        }
        RangeOfMotion result = this.jointMap.get(boneName);
        assert (result != null);
        return result;
    }

    public Vector3f gravity(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.gravityVector);
        return result;
    }

    public boolean hasBoneLink(String boneName) {
        boolean result = boneName == null ? false : this.blConfigMap.containsKey(boneName);
        return result;
    }

    public void link(String boneName, float mass, RangeOfMotion rom) {
        this.verifyNotAddedToSpatial("link a bone");
        if (this.hasBoneLink(boneName)) {
            logger2.log(Level.WARNING, "Bone {0} is already linked.", boneName);
        }
        this.jointMap.put(boneName, rom);
        this.blConfigMap.put(boneName, Float.valueOf(mass));
    }

    public String[] listLinkedBoneNames() {
        int size = this.countLinkedBones();
        String[] result = new String[size];
        Set<String> names = this.blConfigMap.keySet();
        names.toArray(result);
        return result;
    }

    public float mass(String boneName) {
        float mass = torsoName.equals(boneName) ? this.torsoMass : this.blConfigMap.get(boneName).floatValue();
        return mass;
    }

    public void setDamping(float dampingRatio) {
        this.damping = dampingRatio;
    }

    public void setEventDispatchImpulseThreshold(float threshold) {
        this.eventDispatchImpulseThreshold = threshold;
    }

    public void setGravity(Vector3f gravity) {
        this.gravityVector.set(gravity);
    }

    public void setJointLimits(String boneName, RangeOfMotion rom) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + boneName;
            throw new IllegalArgumentException(msg);
        }
        this.jointMap.put(boneName, rom);
    }

    public void setMass(String boneName, float mass) {
        if (torsoName.equals(boneName)) {
            this.torsoMass = mass;
        } else if (this.hasBoneLink(boneName)) {
            this.blConfigMap.put(boneName, Float.valueOf(mass));
        } else {
            String msg = "No bone/torso named " + boneName;
            throw new IllegalArgumentException(msg);
        }
    }

    public float totalMass() {
        float totalMass = this.torsoMass;
        for (float mass : this.blConfigMap.values()) {
            totalMass += mass;
        }
        return totalMass;
    }

    public void unlinkBone(String boneName) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + boneName;
            throw new IllegalArgumentException(msg);
        }
        this.verifyNotAddedToSpatial("unlink a bone");
        this.jointMap.remove(boneName);
        this.blConfigMap.remove(boneName);
    }

    protected void addUnlinkedDescendants(Joint startBone, Collection<Joint> addResult) {
        for (Joint childBone : startBone.getChildren()) {
            String childName = childBone.getName();
            if (this.hasBoneLink(childName)) continue;
            addResult.add(childBone);
            this.addUnlinkedDescendants(childBone, addResult);
        }
    }

    protected String findManager(Joint startBone) {
        String managerName;
        block2: {
            Joint bone = startBone;
            do {
                String boneName;
                if (!this.hasBoneLink(boneName = bone.getName())) continue;
                managerName = boneName;
                break block2;
            } while ((bone = bone.getParent()) != null);
            managerName = torsoName;
        }
        assert (managerName != null);
        return managerName;
    }

    protected String[] managerMap(Armature skeleton) {
        int numBones = skeleton.getJointCount();
        String[] managerMap = new String[numBones];
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Joint bone = skeleton.getJoint(boneIndex);
            managerMap[boneIndex] = this.findManager(bone);
        }
        return managerMap;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.blConfigMap = (Map)cloner.clone(this.blConfigMap);
        this.jointMap = (Map)cloner.clone(this.jointMap);
        this.gravityVector = (Vector3f)cloner.clone((Object)this.gravityVector);
    }

    public DacConfiguration jmeClone() {
        try {
            DacConfiguration clone = (DacConfiguration)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.damping = ic.readFloat("damping", 0.6f);
        this.eventDispatchImpulseThreshold = ic.readFloat("eventDispatchImpulseThreshold", 0.0f);
        this.jointMap.clear();
        this.blConfigMap.clear();
        String[] linkedBoneNames = ic.readStringArray("linkedBoneNames", null);
        Savable[] linkedBoneJoints = ic.readSavableArray("linkedBoneJoints", null);
        float[] blConfigs = ic.readFloatArray("blConfigs", null);
        for (int i = 0; i < linkedBoneNames.length; ++i) {
            String boneName = linkedBoneNames[i];
            RangeOfMotion rom = (RangeOfMotion)linkedBoneJoints[i];
            this.jointMap.put(boneName, rom);
            this.blConfigMap.put(boneName, Float.valueOf(blConfigs[i]));
        }
        this.torsoMass = ic.readFloat("torsoMass", 1.0f);
        this.gravityVector = (Vector3f)ic.readSavable("gravity", null);
    }

    @Override
    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        if (applyPhysicsLocal) {
            throw new UnsupportedOperationException("DynamicAnimControl does not support local physics.");
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.damping, "damping", 0.6f);
        oc.write(this.eventDispatchImpulseThreshold, "eventDispatchImpulseThreshold", 0.0f);
        int count = this.countLinkedBones();
        String[] linkedBoneNames = new String[count];
        Savable[] roms = new RangeOfMotion[count];
        float[] blConfigs = new float[count];
        int i = 0;
        for (Map.Entry<String, Float> entry : this.blConfigMap.entrySet()) {
            linkedBoneNames[i] = entry.getKey();
            roms[i] = this.jointMap.get(entry.getKey());
            blConfigs[i] = entry.getValue().floatValue();
            ++i;
        }
        oc.write(linkedBoneNames, "linkedBoneNames", null);
        oc.write(roms, "linkedBoneJoints", null);
        oc.write(blConfigs, "blConfigs", null);
        oc.write(this.torsoMass, "torsoMass", 1.0f);
        oc.write((Savable)this.gravityVector, "gravity", null);
    }

    private void verifyNotAddedToSpatial(String desiredAction) {
        assert (desiredAction != null);
        Spatial controlledSpatial = this.getSpatial();
        if (controlledSpatial != null) {
            String message = "Cannot " + desiredAction + " while the Control is added to a Spatial.";
            throw new IllegalStateException(message);
        }
    }
}

