/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.ShapeHull;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.util.IntArrayList;
import com.bulletphysics.util.ObjectArrayList;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.bullet.util.BufferedTriangleCallback;
import com.jme3.math.Matrix3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.nio.FloatBuffer;
import java.util.List;
import javax.vecmath.Vector3f;

public class DebugShapeFactory {
    private static final Vector3f aabbMax = new Vector3f(1.0E30f, 1.0E30f, 1.0E30f);
    private static final Vector3f aabbMin = new Vector3f(-1.0E30f, -1.0E30f, -1.0E30f);

    private DebugShapeFactory() {
    }

    public static Spatial getDebugShape(CollisionShape collisionShape) {
        Geometry debugShape;
        if (collisionShape == null) {
            return null;
        }
        if (collisionShape instanceof CompoundCollisionShape) {
            CompoundCollisionShape shape = (CompoundCollisionShape)collisionShape;
            List<ChildCollisionShape> children = shape.getChildren();
            Node node = new Node("DebugShapeNode");
            for (ChildCollisionShape childCollisionShape : children) {
                CollisionShape ccollisionShape = childCollisionShape.shape;
                Geometry geometry = DebugShapeFactory.createDebugShape(ccollisionShape);
                geometry.setLocalTranslation(childCollisionShape.location);
                TempVars vars = TempVars.get();
                Matrix3f tempRot = vars.tempMat3;
                tempRot.set(geometry.getLocalRotation());
                childCollisionShape.rotation.mult(tempRot, tempRot);
                geometry.setLocalRotation(tempRot);
                vars.release();
                node.attachChild((Spatial)geometry);
            }
            debugShape = node;
        } else {
            debugShape = DebugShapeFactory.createDebugShape(collisionShape);
        }
        if (debugShape == null) {
            return null;
        }
        debugShape.updateGeometricState();
        return debugShape;
    }

    private static Geometry createDebugShape(CollisionShape shape) {
        Geometry geom = new Geometry();
        geom.setMesh(DebugShapeFactory.getDebugMesh(shape));
        geom.updateModelBound();
        return geom;
    }

    public static Mesh getDebugMesh(CollisionShape shape) {
        Mesh mesh = null;
        if (shape.getCShape() instanceof ConvexShape) {
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, DebugShapeFactory.getVertices((ConvexShape)shape.getCShape()));
            mesh.getFloatBuffer(VertexBuffer.Type.Position).clear();
        } else if (shape.getCShape() instanceof ConcaveShape) {
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, DebugShapeFactory.getVertices((ConcaveShape)shape.getCShape()));
            mesh.getFloatBuffer(VertexBuffer.Type.Position).clear();
        }
        return mesh;
    }

    private static FloatBuffer getVertices(ConcaveShape concaveShape) {
        BufferedTriangleCallback triangleProcessor = new BufferedTriangleCallback();
        concaveShape.processAllTriangles((TriangleCallback)triangleProcessor, aabbMin, aabbMax);
        return triangleProcessor.getVertices();
    }

    private static FloatBuffer getVertices(ConvexShape convexShape) {
        ShapeHull hull;
        if (convexShape.getUserPointer() == null) {
            hull = new ShapeHull(convexShape);
            float margin = convexShape.getMargin();
            hull.buildHull(margin);
            convexShape.setUserPointer((Object)hull);
        }
        assert (convexShape.getUserPointer() != null) : "Should have a shape for the userPointer, instead got null";
        hull = (ShapeHull)convexShape.getUserPointer();
        assert (hull.numTriangles() > 0) : "Expecting the Hull shape to have triangles";
        int numberOfTriangles = hull.numTriangles();
        int numberOfFloats = 9 * numberOfTriangles;
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)numberOfFloats);
        vertices.limit(numberOfFloats);
        IntArrayList hullIndices = hull.getIndexPointer();
        ObjectArrayList hullVertices = hull.getVertexPointer();
        int index = 0;
        for (int i = 0; i < numberOfTriangles; ++i) {
            Vector3f vertexA = (Vector3f)hullVertices.get(hullIndices.get(index++));
            Vector3f vertexB = (Vector3f)hullVertices.get(hullIndices.get(index++));
            Vector3f vertexC = (Vector3f)hullVertices.get(hullIndices.get(index++));
            vertices.put(vertexA.x).put(vertexA.y).put(vertexA.z);
            vertices.put(vertexB.x).put(vertexB.y).put(vertexB.z);
            vertices.put(vertexC.x).put(vertexC.y).put(vertexC.z);
        }
        vertices.clear();
        return vertices;
    }
}

