/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control.ragdoll;

import com.jme3.bullet.joints.SixDofJoint;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RagdollPreset {
    protected static final Logger logger = Logger.getLogger(RagdollPreset.class.getName());
    protected Map<String, JointPreset> boneMap = new HashMap<String, JointPreset>();
    protected Map<String, LexiconEntry> lexicon = new HashMap<String, LexiconEntry>();

    protected abstract void initBoneMap();

    protected abstract void initLexicon();

    public void setupJointForBone(String boneName, SixDofJoint joint) {
        if (this.boneMap.isEmpty()) {
            this.initBoneMap();
        }
        if (this.lexicon.isEmpty()) {
            this.initLexicon();
        }
        String resultName = "";
        int resultScore = 0;
        for (String key : this.lexicon.keySet()) {
            int score = this.lexicon.get(key).getScore(boneName);
            if (score <= resultScore) continue;
            resultScore = score;
            resultName = key;
        }
        JointPreset preset = this.boneMap.get(resultName);
        if (preset != null && resultScore >= 50) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found matching joint for bone {0} : {1} with score {2}", new Object[]{boneName, resultName, resultScore});
            }
            preset.setupJoint(joint);
        } else {
            logger.log(Level.FINE, "No joint match found for bone {0}", boneName);
            if (resultScore > 0 && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Best match found is {0} with score {1}", new Object[]{resultName, resultScore});
            }
            new JointPreset().setupJoint(joint);
        }
    }

    protected class LexiconEntry
    extends HashMap<String, Integer> {
        protected LexiconEntry() {
        }

        public void addSynonym(String word, int score) {
            this.put(word.toLowerCase(), score);
        }

        public int getScore(String word) {
            int score = 0;
            String searchWord = word.toLowerCase();
            for (String key : this.keySet()) {
                if (searchWord.indexOf(key) < 0) continue;
                score += ((Integer)this.get(key)).intValue();
            }
            return score;
        }
    }

    protected class JointPreset {
        private float maxX;
        private float minX;
        private float maxY;
        private float minY;
        private float maxZ;
        private float minZ;

        public JointPreset() {
        }

        public JointPreset(float maxX, float minX, float maxY, float minY, float maxZ, float minZ) {
            this.maxX = maxX;
            this.minX = minX;
            this.maxY = maxY;
            this.minY = minY;
            this.maxZ = maxZ;
            this.minZ = minZ;
        }

        public void setupJoint(SixDofJoint joint) {
            joint.getRotationalLimitMotor(0).setHiLimit(this.maxX);
            joint.getRotationalLimitMotor(0).setLoLimit(this.minX);
            joint.getRotationalLimitMotor(1).setHiLimit(this.maxY);
            joint.getRotationalLimitMotor(1).setLoLimit(this.minY);
            joint.getRotationalLimitMotor(2).setHiLimit(this.maxZ);
            joint.getRotationalLimitMotor(2).setLoLimit(this.minZ);
        }
    }
}

