/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.ios;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.dummy.DummyKeyInput;
import com.jme3.input.dummy.DummyMouseInput;
import com.jme3.input.ios.IosInputHandler;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ios.IosGL;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GLDebug;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.renderer.opengl.GLRenderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.NanoTimer;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IGLESContext
implements JmeContext {
    private static final Logger logger = Logger.getLogger(IGLESContext.class.getName());
    protected final AtomicBoolean created = new AtomicBoolean(false);
    protected final AtomicBoolean renderable = new AtomicBoolean(false);
    protected final AtomicBoolean needClose = new AtomicBoolean(false);
    protected AppSettings settings = new AppSettings(true);
    protected boolean autoFlush = true;
    protected GLRenderer renderer;
    protected Timer timer;
    protected SystemListener listener;
    protected IosInputHandler input;
    protected int minFrameDuration = 0;

    public IGLESContext() {
        logger.log(Level.FINE, "IGLESContext constructor");
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.Display;
    }

    public void setSettings(AppSettings settings) {
        logger.log(Level.FINE, "IGLESContext setSettings");
        this.settings.copyFrom(settings);
        if (this.input != null) {
            this.input.loadSettings(settings);
        }
    }

    public SystemListener getSystemListener() {
        logger.log(Level.FINE, "IGLESContext getSystemListener");
        return this.listener;
    }

    public void setSystemListener(SystemListener listener) {
        logger.log(Level.FINE, "IGLESContext setSystemListener");
        this.listener = listener;
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        logger.log(Level.FINE, "IGLESContext getRenderer");
        return this.renderer;
    }

    public MouseInput getMouseInput() {
        return new DummyMouseInput();
    }

    public KeyInput getKeyInput() {
        return new DummyKeyInput();
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return this.input;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTitle(String title) {
    }

    public boolean isCreated() {
        logger.log(Level.FINE, "IGLESContext isCreated");
        return this.created.get();
    }

    public void setAutoFlushFrames(boolean enabled) {
        this.autoFlush = enabled;
    }

    public boolean isRenderable() {
        logger.log(Level.FINE, "IGLESContext isRenderable");
        return true;
    }

    public void create(boolean waitFor) {
        logger.log(Level.FINE, "IGLESContext create");
        IosGL gl = new IosGL();
        if (this.settings.getBoolean("GraphicsDebug")) {
            gl = (IosGL)GLDebug.createProxy((GL)gl, (Object)gl, (Class[])new Class[]{GL.class, GLExt.class, GLFbo.class});
        }
        this.renderer = new GLRenderer((GL)gl, (GLExt)gl, (GLFbo)gl);
        this.renderer.initialize();
        this.input = new IosInputHandler();
        this.timer = new NanoTimer();
        this.created.set(true);
        this.listener.initialize();
        if (waitFor) {
            // empty if block
        }
        logger.log(Level.FINE, "IGLESContext created");
    }

    public void create() {
        this.create(false);
    }

    public void restart() {
    }

    public void destroy(boolean waitFor) {
        logger.log(Level.FINE, "IGLESContext destroy");
        this.listener.destroy();
        this.needClose.set(true);
        if (waitFor) {
            // empty if block
        }
    }

    public void destroy() {
        this.destroy(true);
    }

    protected void waitFor(boolean createdVal) {
        while (this.renderable.get() != createdVal) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Context getOpenCLContext() {
        logger.warning("OpenCL not yet supported on this platform");
        return null;
    }

    public int getFramebufferHeight() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public int getFramebufferWidth() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public int getWindowXPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public int getWindowYPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

