/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.ios;

import com.jme3.input.event.InputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.input.ios.IosInputHandler;
import com.jme3.math.Vector2f;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IosTouchHandler {
    private static final Logger logger = Logger.getLogger(IosTouchHandler.class.getName());
    private final HashMap<Integer, Vector2f> lastPositions = new HashMap();
    protected int numPointers = 1;
    protected IosInputHandler iosInput;

    public IosTouchHandler(IosInputHandler iosInput) {
        this.iosInput = iosInput;
    }

    public void initialize() {
    }

    public void destroy() {
    }

    public void actionDown(int pointerId, long time, float x, float y) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Inject input pointer: {0}, time: {1}, x: {2}, y: {3}", new Object[]{pointerId, time, Float.valueOf(x), Float.valueOf(y)});
        }
        float jmeX = this.iosInput.getJmeX(x);
        float jmeY = this.iosInput.invertY(this.iosInput.getJmeY(y));
        TouchEvent touch = this.iosInput.getFreeTouchEvent();
        touch.set(TouchEvent.Type.DOWN, jmeX, jmeY, 0.0f, 0.0f);
        touch.setPointerId(pointerId);
        touch.setTime(time);
        touch.setPressure(1.0f);
        this.lastPositions.put(pointerId, new Vector2f(jmeX, jmeY));
        this.processEvent(touch);
    }

    public void actionUp(int pointerId, long time, float x, float y) {
        float jmeX = this.iosInput.getJmeX(x);
        float jmeY = this.iosInput.invertY(this.iosInput.getJmeY(y));
        TouchEvent touch = this.iosInput.getFreeTouchEvent();
        touch.set(TouchEvent.Type.UP, jmeX, jmeY, 0.0f, 0.0f);
        touch.setPointerId(pointerId);
        touch.setTime(time);
        touch.setPressure(1.0f);
        this.lastPositions.remove(pointerId);
        this.processEvent(touch);
    }

    public void actionMove(int pointerId, long time, float x, float y) {
        float jmeX = this.iosInput.getJmeX(x);
        float jmeY = this.iosInput.invertY(this.iosInput.getJmeY(y));
        Vector2f lastPos = this.lastPositions.get(pointerId);
        if (lastPos == null) {
            lastPos = new Vector2f(jmeX, jmeY);
            this.lastPositions.put(pointerId, lastPos);
        }
        float dX = jmeX - lastPos.x;
        float dY = jmeY - lastPos.y;
        if (dX != 0.0f || dY != 0.0f) {
            TouchEvent touch = this.iosInput.getFreeTouchEvent();
            touch.set(TouchEvent.Type.MOVE, jmeX, jmeY, dX, dY);
            touch.setPointerId(pointerId);
            touch.setTime(time);
            touch.setPressure(1.0f);
            lastPos.set(jmeX, jmeY);
            this.processEvent(touch);
        }
    }

    protected void processEvent(TouchEvent event) {
        InputEvent mouseEvent;
        this.iosInput.addEvent((InputEvent)event);
        if (this.iosInput.isSimulateMouse() && this.numPointers == 1 && (mouseEvent = this.generateMouseEvent(event)) != null) {
            this.iosInput.addEvent(mouseEvent);
        }
    }

    protected InputEvent generateMouseEvent(TouchEvent event) {
        int newDY;
        int newY;
        int newDX;
        int newX;
        MouseButtonEvent inputEvent = null;
        if (this.iosInput.isMouseEventsInvertX()) {
            newX = (int)this.iosInput.invertX(event.getX());
            newDX = (int)event.getDeltaX() * -1;
        } else {
            newX = (int)event.getX();
            newDX = (int)event.getDeltaX();
        }
        if (this.iosInput.isMouseEventsInvertY()) {
            newY = (int)this.iosInput.invertY(event.getY());
            newDY = (int)event.getDeltaY() * -1;
        } else {
            newY = (int)event.getY();
            newDY = (int)event.getDeltaY();
        }
        switch (event.getType()) {
            case DOWN: {
                inputEvent = new MouseButtonEvent(0, true, newX, newY);
                inputEvent.setTime(event.getTime());
                break;
            }
            case UP: {
                inputEvent = new MouseButtonEvent(0, false, newX, newY);
                inputEvent.setTime(event.getTime());
                break;
            }
            case HOVER_MOVE: 
            case MOVE: {
                inputEvent = new MouseMotionEvent(newX, newY, newDX, newDY, (int)event.getScaleSpan(), (int)event.getDeltaScaleSpan());
                inputEvent.setTime(event.getTime());
            }
        }
        return inputEvent;
    }
}

