/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.ios;

import com.jme3.input.RawInputListener;
import com.jme3.input.TouchInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.input.ios.IosTouchHandler;
import com.jme3.input.ios.TouchEventPool;
import com.jme3.system.AppSettings;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IosInputHandler
implements TouchInput {
    private static final Logger logger = Logger.getLogger(IosInputHandler.class.getName());
    private static final int MAX_TOUCH_EVENTS = 1024;
    private boolean mouseEventsEnabled = true;
    private boolean mouseEventsInvertX = false;
    private boolean mouseEventsInvertY = false;
    private boolean keyboardEventsEnabled = false;
    private boolean initialized = false;
    private RawInputListener listener = null;
    private ConcurrentLinkedQueue<InputEvent> inputEventQueue = new ConcurrentLinkedQueue();
    private final TouchEventPool touchEventPool = new TouchEventPool(1024);
    private IosTouchHandler touchHandler = new IosTouchHandler(this);
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int width = 0;
    private int height = 0;

    public void initialize() {
        this.touchEventPool.initialize();
        if (this.touchHandler != null) {
            this.touchHandler.initialize();
        }
        this.initialized = true;
    }

    public void update() {
        logger.log(Level.FINE, "InputEvent update : {0}", this.listener);
        if (this.listener != null) {
            InputEvent inputEvent;
            while ((inputEvent = this.inputEventQueue.poll()) != null) {
                if (inputEvent instanceof TouchEvent) {
                    this.listener.onTouchEvent((TouchEvent)inputEvent);
                    continue;
                }
                if (inputEvent instanceof MouseButtonEvent) {
                    this.listener.onMouseButtonEvent((MouseButtonEvent)inputEvent);
                    continue;
                }
                if (inputEvent instanceof MouseMotionEvent) {
                    this.listener.onMouseMotionEvent((MouseMotionEvent)inputEvent);
                    continue;
                }
                if (!(inputEvent instanceof KeyInputEvent)) continue;
                this.listener.onKeyEvent((KeyInputEvent)inputEvent);
            }
        }
    }

    public void destroy() {
        this.initialized = false;
        this.touchEventPool.destroy();
        if (this.touchHandler != null) {
            this.touchHandler.destroy();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return System.nanoTime();
    }

    public void setSimulateMouse(boolean simulate) {
        this.mouseEventsEnabled = simulate;
    }

    public boolean isSimulateMouse() {
        return this.mouseEventsEnabled;
    }

    public void setSimulateKeyboard(boolean simulate) {
        this.keyboardEventsEnabled = simulate;
    }

    public boolean isSimulateKeyboard() {
        return this.keyboardEventsEnabled;
    }

    public void setOmitHistoricEvents(boolean dontSendHistory) {
    }

    public void loadSettings(AppSettings settings) {
        this.mouseEventsEnabled = true;
        this.mouseEventsInvertX = settings.isEmulateMouseFlipX();
        this.mouseEventsInvertY = settings.isEmulateMouseFlipY();
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.width = settings.getWidth();
        this.height = settings.getHeight();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting input scaling, scaleX: {0}, scaleY: {1}, width: {2}, height: {3}", new Object[]{Float.valueOf(this.scaleX), Float.valueOf(this.scaleY), this.width, this.height});
        }
    }

    public boolean isMouseEventsInvertX() {
        return this.mouseEventsInvertX;
    }

    public boolean isMouseEventsInvertY() {
        return this.mouseEventsInvertY;
    }

    public float invertX(float origX) {
        return this.getJmeX(this.width) - origX;
    }

    public float invertY(float origY) {
        return this.getJmeY(this.height) - origY;
    }

    public float getJmeX(float origX) {
        return origX * this.scaleX;
    }

    public float getJmeY(float origY) {
        return origY * this.scaleY;
    }

    public TouchEvent getFreeTouchEvent() {
        return this.touchEventPool.getNextFreeEvent();
    }

    public void addEvent(InputEvent event) {
        this.inputEventQueue.add(event);
        if (event instanceof TouchEvent) {
            this.touchEventPool.storeEvent((TouchEvent)event);
        }
    }

    public void injectTouchDown(int pointerId, long time, float x, float y) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Using input scaling, scaleX: {0}, scaleY: {1}, width: {2}, height: {3}", new Object[]{Float.valueOf(this.scaleX), Float.valueOf(this.scaleY), this.width, this.height});
        }
        if (this.touchHandler != null) {
            this.touchHandler.actionDown(pointerId, time, x, y);
        }
    }

    public void injectTouchUp(int pointerId, long time, float x, float y) {
        if (this.touchHandler != null) {
            this.touchHandler.actionUp(pointerId, time, x, y);
        }
    }

    public void injectTouchMove(int pointerId, long time, float x, float y) {
        if (this.touchHandler != null) {
            this.touchHandler.actionMove(pointerId, time, x, y);
        }
    }
}

