/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.awt;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.awt.AwtKeyInput;
import com.jme3.input.awt.AwtMouseInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.Displays;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.awt.AwtPanel;
import com.jme3.system.awt.PaintMode;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AwtPanelsContext
implements JmeContext {
    private static final Logger logger = Logger.getLogger(AwtPanelsContext.class.getName());
    protected JmeContext actualContext;
    protected AppSettings settings = new AppSettings(true);
    protected SystemListener listener;
    protected ArrayList<AwtPanel> panels = new ArrayList();
    protected AwtPanel inputSource;
    protected AwtMouseInput mouseInput = new AwtMouseInput();
    protected AwtKeyInput keyInput = new AwtKeyInput();
    protected boolean lastThrottleState = false;

    public void setInputSource(AwtPanel panel) {
        if (!this.panels.contains(panel)) {
            throw new IllegalArgumentException();
        }
        this.inputSource = panel;
        this.mouseInput.setInputSource(panel);
        this.keyInput.setInputSource(panel);
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    public SystemListener getSystemListener() {
        return this.listener;
    }

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.actualContext.getRenderer();
    }

    public MouseInput getMouseInput() {
        return this.mouseInput;
    }

    public KeyInput getKeyInput() {
        return this.keyInput;
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public Timer getTimer() {
        return this.actualContext.getTimer();
    }

    public boolean isCreated() {
        return this.actualContext != null && this.actualContext.isCreated();
    }

    public boolean isRenderable() {
        return this.actualContext != null && this.actualContext.isRenderable();
    }

    public Context getOpenCLContext() {
        return this.actualContext.getOpenCLContext();
    }

    public AwtPanel createPanel(PaintMode paintMode) {
        AwtPanel panel = new AwtPanel(paintMode);
        this.panels.add(panel);
        return panel;
    }

    public AwtPanel createPanel(PaintMode paintMode, boolean srgb) {
        AwtPanel panel = new AwtPanel(paintMode, srgb);
        this.panels.add(panel);
        return panel;
    }

    private void initInThread() {
        this.listener.initialize();
    }

    private void updateInThread() {
        boolean needThrottle = true;
        for (AwtPanel panel : this.panels) {
            if (!panel.isActiveDrawing()) continue;
            needThrottle = false;
            break;
        }
        if (this.lastThrottleState != needThrottle) {
            this.lastThrottleState = needThrottle;
            if (this.lastThrottleState) {
                System.out.println("OGL: Throttling update loop.");
            } else {
                System.out.println("OGL: Ceased throttling update loop.");
            }
        }
        if (needThrottle) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.listener.update();
        for (AwtPanel panel : this.panels) {
            panel.onFrameEnd();
        }
    }

    private void destroyInThread() {
        this.listener.destroy();
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.settings.setRenderer("LWJGL-OpenGL2");
        if (this.actualContext != null) {
            this.actualContext.setSettings(settings);
        }
    }

    public void create(boolean waitFor) {
        if (this.actualContext != null) {
            throw new IllegalStateException("Already created");
        }
        this.actualContext = JmeSystem.newContext((AppSettings)this.settings, (JmeContext.Type)JmeContext.Type.OffscreenSurface);
        this.actualContext.setSystemListener((SystemListener)new AwtPanelsListener());
        this.actualContext.create(waitFor);
    }

    public void destroy(boolean waitFor) {
        if (this.actualContext == null) {
            throw new IllegalStateException("Not created");
        }
        this.actualContext.destroy(waitFor);
    }

    public void setTitle(String title) {
    }

    public void setAutoFlushFrames(boolean enabled) {
    }

    public void restart() {
    }

    public int getFramebufferHeight() {
        return this.inputSource.getHeight();
    }

    public int getFramebufferWidth() {
        return this.inputSource.getWidth();
    }

    public int getWindowXPosition() {
        return this.inputSource.getX();
    }

    public int getWindowYPosition() {
        return this.inputSource.getY();
    }

    public Displays getDisplays() {
        return null;
    }

    public int getPrimaryDisplay() {
        return 0;
    }

    private class AwtPanelsListener
    implements SystemListener {
        private AwtPanelsListener() {
        }

        public void initialize() {
            AwtPanelsContext.this.initInThread();
        }

        public void reshape(int width, int height) {
            logger.severe("reshape is not supported.");
        }

        public void rescale(float x, float y) {
            logger.severe("rescale is not supported.");
        }

        public void update() {
            AwtPanelsContext.this.updateInThread();
        }

        public void requestClose(boolean esc) {
            throw new IllegalStateException();
        }

        public void gainFocus() {
            throw new IllegalStateException();
        }

        public void loseFocus() {
            throw new IllegalStateException();
        }

        public void handleError(String errorMsg, Throwable t) {
            AwtPanelsContext.this.listener.handleError(errorMsg, t);
        }

        public void destroy() {
            AwtPanelsContext.this.destroyInThread();
        }
    }
}

