/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.NativeLibrary;
import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.Platform;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public enum NativeLibraries {
    Lwjgl(new LibraryInfo("lwjgl", libPath -> System.setProperty("org.lwjgl.librarypath", Paths.get(libPath, new String[0]).getParent().toAbsolutePath().toString())).addNativeVariant(Platform.Windows32, "lwjgl.dll").addNativeVariant(Platform.Windows64, "lwjgl64.dll").addNativeVariant(Platform.Linux32, "liblwjgl.so").addNativeVariant(Platform.Linux64, "liblwjgl64.so").addNativeVariant(Platform.MacOSX32, "liblwjgl.dylib").addNativeVariant(Platform.MacOSX64, "liblwjgl.dylib")),
    OpenAL(new LibraryInfo("openal").addNativeVariant(Platform.Windows32, "OpenAL32.dll").addNativeVariant(Platform.Windows64, "OpenAL64.dll").addNativeVariant(Platform.Linux32, "libopenal.so").addNativeVariant(Platform.Linux64, "libopenal64.so").addNativeVariant(Platform.MacOSX32, "openal.dylib", "libopenal.dylib").addNativeVariant(Platform.MacOSX64, "openal.dylib", "libopenal.dylib")),
    BulletJme(new LibraryInfo("bulletjme").addNativeVariant(Platform.Windows32, "native/windows/x86/bulletjme.dll", "bulletjme-x86.dll").addNativeVariant(Platform.Windows64, "native/windows/x86_64/bulletjme.dll", "bulletjme-x86_64.dll").addNativeVariant(Platform.Windows_ARM64, "native/windows/arm64/bulletjme.dll", "bulletjme-arm64.dll").addNativeVariant(Platform.Linux32, "native/linux/x86/libbulletjme.so", "libbulletjme-x86.so").addNativeVariant(Platform.Linux64, "native/linux/x86_64/libbulletjme.so", "libbulletjme-x86_64.so").addNativeVariant(Platform.Linux_ARM32, "native/linux/arm32/libbulletjme.so", "libbulletjme-arm32.so").addNativeVariant(Platform.Linux_ARM64, "native/linux/arm64/libbulletjme.so", "libbulletjme-arm64.so").addNativeVariant(Platform.MacOSX32, "native/osx/x86/libbulletjme.dylib", "libbulletjme-x86.dylib").addNativeVariant(Platform.MacOSX64, "native/osx/x86_64/libbulletjme.dylib", "libbulletjme-x86_64.dylib").addNativeVariant(Platform.MacOSX_ARM64, "native/osx/arm64/libbulletjme.dylib", "libbulletjme-arm64.dylib")),
    JInput(new LibraryInfo("jinput", libPath -> System.setProperty("net.java.games.input.librarypath", Paths.get(libPath, new String[0]).getParent().toAbsolutePath().toString())).addNativeVariant(Platform.Windows32, "jinput-raw.dll").addNativeVariant(Platform.Windows64, "jinput-raw_64.dll").addNativeVariant(Platform.Linux32, "libjinput-linux.so").addNativeVariant(Platform.Linux64, "libjinput-linux64.so").addNativeVariant(Platform.MacOSX32, "libjinput-osx.jnilib", "libjinput-osx.dylib").addNativeVariant(Platform.MacOSX64, "libjinput-osx.jnilib", "libjinput-osx.dylib")),
    JInputDX8(new LibraryInfo("jinput-dx8").addNativeVariant(Platform.Windows32, "jinput-dx8.dll", null).addNativeVariant(Platform.Windows64, "jinput-dx8_64.dll", null).addNativeVariant(Platform.Linux32, null).addNativeVariant(Platform.Linux64, null).addNativeVariant(Platform.MacOSX32, null).addNativeVariant(Platform.MacOSX64, null));

    private final LibraryInfo library;

    private NativeLibraries(LibraryInfo library) {
        this.library = library;
    }

    public static void registerDefaultLibraries() {
        Lwjgl.registerLibrary();
        OpenAL.registerLibrary();
        BulletJme.registerLibrary();
        JInput.registerLibrary();
        JInputDX8.registerLibrary();
    }

    public LibraryInfo getLibrary() {
        return this.library;
    }

    public String getName() {
        return this.library.getName();
    }

    private void registerLibrary() {
        this.library.getNativeVariants().forEach(NativeLibraryLoader::registerNativeLibrary);
    }

    public static class LibraryInfo {
        private final String name;
        private final List<NativeLibrary> nativeVariants = new ArrayList<NativeLibrary>();
        private final Consumer<String> loadFunction;

        public LibraryInfo(String name) {
            this(name, System::load);
        }

        public LibraryInfo(String name, Consumer<String> loadFunction) {
            this.name = name;
            this.loadFunction = loadFunction;
        }

        public String getName() {
            return this.name;
        }

        public List<NativeLibrary> getNativeVariants() {
            return this.nativeVariants;
        }

        public LibraryInfo addNativeVariant(Platform platform, String pathInNativesJar) {
            return this.addNativeVariant(platform, pathInNativesJar, null);
        }

        public LibraryInfo addNativeVariant(Platform platform, String pathInNativesJar, String extractedAsFileName) {
            this.nativeVariants.add(new NativeLibrary(this.name, platform, pathInNativesJar, extractedAsFileName, this.loadFunction));
            return this;
        }
    }
}

