/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

class MeshBuffers {
    private static final int MAXIMUM_WEIGHTS_PER_VERTEX = 4;
    private final int materialIndex;
    private List<Vector3f> verts = new ArrayList<Vector3f>();
    private List<Vector3f> normals = new ArrayList<Vector3f>();
    private Map<String, List<Vector2f>> uvCoords = new HashMap<String, List<Vector2f>>();
    private List<byte[]> vertColors = new ArrayList<byte[]>();
    private List<Integer> indexes = new ArrayList<Integer>();
    private int maximumWeightsPerVertex;
    private List<TreeMap<Float, Integer>> boneWeightAndIndexes = new ArrayList<TreeMap<Float, Integer>>();

    public MeshBuffers(int materialIndex) {
        this.materialIndex = materialIndex;
    }

    public int getMaterialIndex() {
        return this.materialIndex;
    }

    public Buffer getIndexBuffer() {
        if (this.indexes.size() <= Short.MAX_VALUE) {
            short[] indices = new short[this.indexes.size()];
            for (int i = 0; i < this.indexes.size(); ++i) {
                indices[i] = this.indexes.get(i).shortValue();
            }
            return BufferUtils.createShortBuffer((short[])indices);
        }
        int[] indices = new int[this.indexes.size()];
        for (int i = 0; i < this.indexes.size(); ++i) {
            indices[i] = this.indexes.get(i);
        }
        return BufferUtils.createIntBuffer((int[])indices);
    }

    public VertexBuffer getPositionsBuffer() {
        VertexBuffer positionBuffer = new VertexBuffer(VertexBuffer.Type.Position);
        Vector3f[] data = this.verts.toArray(new Vector3f[this.verts.size()]);
        positionBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector3f[])data));
        return positionBuffer;
    }

    public VertexBuffer getNormalsBuffer() {
        VertexBuffer positionBuffer = new VertexBuffer(VertexBuffer.Type.Normal);
        Vector3f[] data = this.normals.toArray(new Vector3f[this.normals.size()]);
        positionBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector3f[])data));
        return positionBuffer;
    }

    public BoneBuffersData getBoneBuffers() {
        BoneBuffersData result = null;
        if (this.maximumWeightsPerVertex > 0) {
            this.normalizeBoneBuffers(4);
            this.maximumWeightsPerVertex = 4;
            FloatBuffer weightsFloatData = BufferUtils.createFloatBuffer((int)(this.boneWeightAndIndexes.size() * 4));
            ByteBuffer indicesData = BufferUtils.createByteBuffer((int)(this.boneWeightAndIndexes.size() * 4));
            int index = 0;
            for (Map map : this.boneWeightAndIndexes) {
                if (map.size() > 0) {
                    int count = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        weightsFloatData.put(index * 4 + count, ((Float)entry.getKey()).floatValue());
                        indicesData.put(index * 4 + count, ((Integer)entry.getValue()).byteValue());
                        ++count;
                    }
                } else {
                    weightsFloatData.put(index * 4, 1.0f);
                    indicesData.put(index * 4, (byte)0);
                }
                ++index;
            }
            VertexBuffer verticesWeights = new VertexBuffer(VertexBuffer.Type.BoneWeight);
            verticesWeights.setupData(VertexBuffer.Usage.CpuOnly, this.maximumWeightsPerVertex, VertexBuffer.Format.Float, (Buffer)weightsFloatData);
            VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Type.BoneIndex);
            vertexBuffer.setupData(VertexBuffer.Usage.CpuOnly, this.maximumWeightsPerVertex, VertexBuffer.Format.UnsignedByte, (Buffer)indicesData);
            result = new BoneBuffersData(this.maximumWeightsPerVertex, verticesWeights, vertexBuffer);
        }
        return result;
    }

    public Map<String, List<Vector2f>> getUvCoords() {
        return this.uvCoords;
    }

    public boolean areVertexColorsUsed() {
        return this.vertColors.size() > 0;
    }

    public ByteBuffer getVertexColorsBuffer() {
        ByteBuffer result = null;
        if (this.vertColors.size() > 0) {
            result = BufferUtils.createByteBuffer((int)(4 * this.vertColors.size()));
            for (byte[] v : this.vertColors) {
                if (v != null) {
                    result.put(v[0]).put(v[1]).put(v[2]).put(v[3]);
                    continue;
                }
                result.put((byte)0).put((byte)0).put((byte)0).put((byte)0);
            }
            result.flip();
        }
        return result;
    }

    public boolean isShortIndexBuffer() {
        return this.indexes.size() <= Short.MAX_VALUE;
    }

    public void append(Vector3f vert, Vector3f normal) {
        int index = this.indexOf(vert, normal, null);
        if (index >= 0) {
            this.indexes.add(index);
        } else {
            this.indexes.add(this.verts.size());
            this.verts.add(vert);
            this.normals.add(normal);
        }
    }

    public void append(boolean smooth, Vector3f[] verts, Vector3f[] normals, Map<String, List<Vector2f>> uvCoords, byte[][] vertColors, List<Map<Float, Integer>> vertexGroups) {
        if (verts.length != normals.length) {
            throw new IllegalArgumentException("The amount of verts and normals MUST be equal!");
        }
        if (vertColors != null && vertColors.length != verts.length) {
            throw new IllegalArgumentException("The amount of vertex colors and vertices MUST be equal!");
        }
        if (vertexGroups.size() != 0 && vertexGroups.size() != verts.length) {
            throw new IllegalArgumentException("The amount of (if given) vertex groups and vertices MUST be equal!");
        }
        if (!smooth) {
            normals[1] = normals[2] = FastMath.computeNormal((Vector3f)verts[0], (Vector3f)verts[1], (Vector3f)verts[2]);
            normals[0] = normals[2];
        }
        for (int i = 0; i < verts.length; ++i) {
            int index = -1;
            Map<String, Vector2f> uvCoordsForVertex = this.getUVsForVertex(i, uvCoords);
            if (smooth && (index = this.indexOf(verts[i], normals[i], uvCoordsForVertex)) >= 0) {
                this.indexes.add(index);
                continue;
            }
            this.indexes.add(this.verts.size());
            this.verts.add(verts[i]);
            this.normals.add(normals[i]);
            this.vertColors.add(vertColors[i]);
            if (uvCoords != null && uvCoords.size() > 0) {
                for (Map.Entry<String, List<Vector2f>> entry : uvCoords.entrySet()) {
                    if (this.uvCoords.containsKey(entry.getKey())) {
                        this.uvCoords.get(entry.getKey()).add(entry.getValue().get(i));
                        continue;
                    }
                    ArrayList<Vector2f> uvs = new ArrayList<Vector2f>();
                    uvs.add(entry.getValue().get(i));
                    this.uvCoords.put(entry.getKey(), uvs);
                }
            }
            if (vertexGroups.size() <= 0) continue;
            Map<Float, Integer> group = vertexGroups.get(i);
            this.maximumWeightsPerVertex = Math.max(this.maximumWeightsPerVertex, group.size());
            this.boneWeightAndIndexes.add(new TreeMap<Float, Integer>(group));
        }
    }

    private Map<String, Vector2f> getUVsForVertex(int vertexIndex, Map<String, List<Vector2f>> uvs) {
        if (uvs == null || uvs.size() == 0) {
            return null;
        }
        HashMap<String, Vector2f> result = new HashMap<String, Vector2f>(uvs.size());
        for (Map.Entry<String, List<Vector2f>> entry : uvs.entrySet()) {
            result.put(entry.getKey(), entry.getValue().get(vertexIndex));
        }
        return result;
    }

    private int indexOf(Vector3f vert, Vector3f normal, Map<String, Vector2f> uvCoords) {
        for (int i = 0; i < this.verts.size(); ++i) {
            if (!this.verts.get(i).equals((Object)vert) || !this.normals.get(i).equals((Object)normal)) continue;
            if (uvCoords != null && uvCoords.size() > 0) {
                for (Map.Entry<String, Vector2f> entry : uvCoords.entrySet()) {
                    List<Vector2f> uvs = this.uvCoords.get(entry.getKey());
                    if (uvs == null) {
                        return -1;
                    }
                    if (uvs.get(i).equals((Object)entry.getValue())) continue;
                    return -1;
                }
            }
            return i;
        }
        return -1;
    }

    private void normalizeBoneBuffers(int maximumSize) {
        for (TreeMap<Float, Integer> group : this.boneWeightAndIndexes) {
            if (group.size() > maximumSize) {
                NavigableMap<Float, Integer> descendingWeights = group.descendingMap();
                while (descendingWeights.size() > maximumSize) {
                    descendingWeights.pollLastEntry();
                }
            }
            TreeMap<Float, Integer> normalizedGroup = new TreeMap<Float, Integer>();
            float sum = 0.0f;
            for (Map.Entry<Float, Integer> entry : group.entrySet()) {
                sum += entry.getKey().floatValue();
            }
            if (sum == 0.0f || sum == 1.0f) continue;
            for (Map.Entry<Float, Integer> entry : group.entrySet()) {
                normalizedGroup.put(Float.valueOf(entry.getKey().floatValue() / sum), entry.getValue());
            }
            group.clear();
            group.putAll(normalizedGroup);
        }
    }

    public static class BoneBuffersData {
        public final int maximumWeightsPerVertex;
        public final VertexBuffer verticesWeights;
        public final VertexBuffer verticesWeightsIndices;

        public BoneBuffersData(int maximumWeightsPerVertex, VertexBuffer verticesWeights, VertexBuffer verticesWeightsIndices) {
            this.maximumWeightsPerVertex = maximumWeightsPerVertex;
            this.verticesWeights = verticesWeights;
            this.verticesWeightsIndices = verticesWeightsIndices;
        }
    }
}

