/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.BlenderKey;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.Properties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(AbstractBlenderHelper.class.getName());
    protected BlenderContext blenderContext;
    protected final int blenderVersion;
    protected boolean fixUpAxis;
    protected Quaternion upAxisRotationQuaternion;

    public AbstractBlenderHelper(String blenderVersion, BlenderContext blenderContext) {
        this.blenderVersion = Integer.parseInt(blenderVersion);
        this.blenderContext = blenderContext;
        this.fixUpAxis = blenderContext.getBlenderKey().isFixUpAxis();
        if (this.fixUpAxis) {
            this.upAxisRotationQuaternion = new Quaternion().fromAngles(-1.5707964f, 0.0f, 0.0f);
        }
    }

    protected Properties loadProperties(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pProperties;
        Properties properties = null;
        Structure id = (Structure)structure.getFieldValue("ID");
        if (id != null && (pProperties = (Pointer)id.getFieldValue("properties")).isNotNull()) {
            Structure propertiesStructure = pProperties.fetchData().get(0);
            properties = new Properties();
            properties.load(propertiesStructure, blenderContext);
        }
        return properties;
    }

    public void applyProperties(Spatial spatial, Properties properties) {
        List<String> propertyNames = properties.getSubPropertiesNames();
        if (propertyNames != null && propertyNames.size() > 0) {
            for (String propertyName : propertyNames) {
                Object value = properties.findValue(propertyName);
                if (value instanceof Savable || value instanceof Boolean || value instanceof String || value instanceof Float || value instanceof Integer || value instanceof Long) {
                    spatial.setUserData(propertyName, value);
                    continue;
                }
                if (value instanceof Double) {
                    spatial.setUserData(propertyName, (Object)Float.valueOf(((Double)value).floatValue()));
                    continue;
                }
                if (value instanceof int[]) {
                    spatial.setUserData(propertyName, (Object)Arrays.toString((int[])value));
                    continue;
                }
                if (value instanceof float[]) {
                    spatial.setUserData(propertyName, (Object)Arrays.toString((float[])value));
                    continue;
                }
                if (!(value instanceof double[])) continue;
                spatial.setUserData(propertyName, (Object)Arrays.toString((double[])value));
            }
        }
    }

    protected Object loadLibrary(Structure id) throws BlenderFileException {
        Pointer pLib = (Pointer)id.getFieldValue("lib");
        if (pLib.isNotNull()) {
            Object result;
            String fullName = id.getFieldValue("name").toString();
            String nameOfFeatureToLoad = id.getName();
            Structure library = pLib.fetchData().get(0);
            String path = library.getFieldValue("filepath").toString();
            if (!this.blenderContext.getLinkedFeatures().keySet().contains(path)) {
                Spatial loadedAsset = null;
                BlenderKey blenderKey = new BlenderKey(path);
                blenderKey.setLoadUnlinkedAssets(true);
                try {
                    loadedAsset = (Spatial)this.blenderContext.getAssetManager().loadAsset((AssetKey)blenderKey);
                }
                catch (AssetNotFoundException e) {
                    LOGGER.log(Level.FINEST, "Cannot locate linked resource at path: {0}.", path);
                }
                if (loadedAsset != null) {
                    Map linkedData = (Map)loadedAsset.getUserData("linkedData");
                    for (Map.Entry entry : linkedData.entrySet()) {
                        String linkedDataFilePath = "this".equals(entry.getKey()) ? path : (String)entry.getKey();
                        this.blenderContext.getLinkedFeatures().put(linkedDataFilePath, (Map<String, Object>)entry.getValue());
                    }
                } else {
                    LOGGER.log(Level.WARNING, "No features loaded from path: {0}.", path);
                }
            }
            if ((result = this.blenderContext.getLinkedFeature(path, fullName)) == null) {
                LOGGER.log(Level.WARNING, "Could NOT find asset named {0} in the library of path: {1}.", new Object[]{nameOfFeatureToLoad, path});
            } else {
                this.blenderContext.addLoadedFeatures(id.getOldMemoryAddress(), BlenderContext.LoadedDataType.STRUCTURE, id);
                this.blenderContext.addLoadedFeatures(id.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE, result);
            }
            return result;
        }
        LOGGER.warning("Library link points to nothing!");
        return null;
    }
}

