/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring.hibernate;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

public class RecordInstantiator
implements EmbeddableInstantiator {
    private final Class<?> type;
    private final List<Integer> indexes;
    private final Constructor<?> constructor;

    public RecordInstantiator(Class<?> type) {
        Assert.notNull(type, (String)"Record type must not be null!");
        Assert.isTrue((boolean)type.isRecord(), (String)"Type must be a record!");
        RecordComponent[] components = type.getRecordComponents();
        Class[] parameterTypes = (Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new);
        this.type = type;
        this.constructor = RecordInstantiator.detectRecordConstructor(type, parameterTypes);
        this.indexes = IntStream.range(0, components.length).mapToObj(it -> Map.entry(components[it].getName(), it)).sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        return this.type.isInstance(object);
    }

    public boolean isSameClass(Object object, SessionFactoryImplementor sessionFactory) {
        return this.type.equals(object.getClass());
    }

    public Object instantiate(ValueAccess access, SessionFactoryImplementor factory) {
        Object[] sources = access.getValues();
        return BeanUtils.instantiateClass(this.constructor, (Object[])this.indexes.stream().map(it -> sources[it]).toArray());
    }

    private static Constructor<?> detectRecordConstructor(Class<?> type, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = String.format("Could not find record constructor on %s!", type.getClass());
            throw new IllegalArgumentException(message, e);
        }
    }
}

