/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import org.jmolecules.bytebuddy.ClassWorld;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.Jpa;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PersistableOptions;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.types.AggregateRoot;

public class JMoleculesSpringDataJpaPlugin
implements LoggingPlugin,
Plugin.WithPreprocessor {
    private PersistableOptions options;

    public JMoleculesSpringDataJpaPlugin(Jpa jpa) {
        this.options = JMoleculesSpringDataJpaPlugin.getOptions(jpa);
    }

    public void onPreprocess(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        Jpa jpa = Jpa.getJavaPersistence(ClassWorld.of(classFileLocator)).get();
        this.options = JMoleculesSpringDataJpaPlugin.getOptions(jpa);
    }

    public boolean matches(TypeDescription target) {
        return !PluginUtils.isCglibProxyType((TypeDefinition)target) && target.isAssignableTo(AggregateRoot.class);
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        PluginLogger.Log log = PluginLogger.INSTANCE.getLog(typeDescription, "Spring Data JPA");
        return JMoleculesType.of(log, builder).implementPersistable(this.options).conclude();
    }

    private static PersistableOptions getOptions(Jpa jpa) {
        return PersistableOptions.of(jpa.getAnnotation("Transient")).withCallbackAnnotations(jpa.getAnnotation("PrePersist"), jpa.getAnnotation("PostLoad"));
    }

    public JMoleculesSpringDataJpaPlugin() {
    }
}

