/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmolecules.bytebuddy.ClassWorld;
import org.jmolecules.bytebuddy.JMoleculesElementMatchers;
import org.jmolecules.bytebuddy.JMoleculesType;
import org.jmolecules.bytebuddy.Jpa;
import org.jmolecules.bytebuddy.LifecycleMethods;
import org.jmolecules.bytebuddy.LoggingPlugin;
import org.jmolecules.bytebuddy.PluginLogger;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.bytebuddy.ReferenceTypePackageNamingStrategy;
import org.jmolecules.jpa.JMoleculesJpa;

public class JMoleculesJpaPlugin
implements LoggingPlugin,
Plugin.WithPreprocessor {
    static final String NULLABILITY_METHOD_NAME = "__verifyNullability";
    private Jpa jpa;
    private Class<? extends Annotation> embeddableInstantiatorAnnotationType;

    public JMoleculesJpaPlugin(Jpa jpa, ClassWorld world) {
        this.init(jpa, world);
    }

    private void init(Jpa jpa, ClassWorld world) {
        if (this.jpa != null) {
            return;
        }
        this.jpa = jpa;
        if (world.isAvailable("org.hibernate.annotations.EmbeddableInstantiator")) {
            this.embeddableInstantiatorAnnotationType = jpa.getType("org.hibernate.annotations.EmbeddableInstantiator");
        }
    }

    public void onPreprocess(TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        ClassWorld world = ClassWorld.of(classFileLocator);
        this.init(Jpa.getJavaPersistence(world).get(), world);
    }

    public boolean matches(TypeDescription target) {
        if (target.isAnnotation() || PluginUtils.isCglibProxyType((TypeDefinition)target)) {
            return false;
        }
        boolean implementsJMoleculesInterface = !((TypeList.Generic)target.getInterfaces().filter((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.jmolecules"))).isEmpty();
        boolean hasJMoleculesAnnotation = Stream.concat(target.getDeclaredAnnotations().stream(), target.getInheritedAnnotations().stream()).anyMatch(it -> it.getAnnotationType().getName().startsWith("org.jmolecules"));
        if (implementsJMoleculesInterface || hasJMoleculesAnnotation) {
            return true;
        }
        TypeDescription.Generic superType = target.getSuperClass();
        return superType == null || superType.represents(Object.class) ? false : this.matches(superType.asErasure()) || target.isRecord();
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription type, ClassFileLocator classFileLocator) {
        PluginLogger.Log log = PluginLogger.INSTANCE.getLog(type, "JPA");
        return JMoleculesType.of(log, builder).map(JMoleculesType::isEntity, this::handleEntity).map(JMoleculesType::isAssociation, this::handleAssociation).map(JMoleculesType::isIdentifier, this::handleIdentifier).map(JMoleculesType::isValueObject, this::handleValueObject).map(JMoleculesType::isRecord, it -> it.annotateTypeIfMissing(this.jpa.getAnnotation("Embeddable"), new Class[0])).map(this::applyRecordInstantiator).conclude();
    }

    private <T extends AnnotationSource> ElementMatcher.Junction<T> hasJpaRelationShipAnnotation() {
        return ElementMatchers.isAnnotatedWith(this.jpa.getAnnotation("OneToOne")).or((ElementMatcher)ElementMatchers.isAnnotatedWith(this.jpa.getAnnotation("OneToMany"))).or((ElementMatcher)ElementMatchers.isAnnotatedWith(this.jpa.getAnnotation("ManyToOne"))).or((ElementMatcher)ElementMatchers.isAnnotatedWith(this.jpa.getAnnotation("ManyToMany")));
    }

    private JMoleculesType handleIdentifier(JMoleculesType type) {
        return this.handleValueObject(type.implement(Serializable.class));
    }

    private JMoleculesType handleAssociation(JMoleculesType type) {
        return type.addDefaultConstructorIfMissing().annotateTypeIfMissing(this.jpa.getAnnotation("Embeddable"), new Class[0]);
    }

    private JMoleculesType handleEntity(JMoleculesType type) {
        Function<TypeDescription, Class<? extends Annotation>> selector = it -> !type.isAggregateRoot() && type.isAbstract() ? this.jpa.getAnnotation("MappedSuperclass") : this.jpa.getAnnotation("Entity");
        Class embeddedId = this.jpa.getAnnotation("EmbeddedId");
        Class id = this.jpa.getAnnotation("Id");
        JMoleculesType result = type.addDefaultConstructorIfMissing().annotateTypedIdentifierWith(embeddedId, id).annotateAnnotatedIdentifierWith(id, embeddedId).annotateTypeIfMissing(selector, this.jpa.getAnnotation("Entity"), this.jpa.getAnnotation("MappedSuperclass")).map(this::declareNullVerificationMethod);
        return this.defaultToEntityAssociations(result);
    }

    private JMoleculesType defaultToEntityAssociations(JMoleculesType type) {
        ElementMatcher.Junction doesNotHaveAtJoinColumn = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith(this.jpa.getAnnotation("JoinColumn")));
        ElementMatcher.Junction doesNotHaveRelationShipAnnotation = ElementMatchers.not(this.hasJpaRelationShipAnnotation());
        ElementMatcher.Junction isCollectionOfEntities = ElementMatchers.genericFieldType(JMoleculesElementMatchers.isCollectionOfEntity());
        ElementMatcher.Junction isEntity = ElementMatchers.fieldType(JMoleculesElementMatchers.isEntity());
        ElementMatcher.Junction isUndefaultedEntity = isEntity.and((ElementMatcher)doesNotHaveRelationShipAnnotation);
        ElementMatcher.Junction isUndefaultCollectionOfEntities = isCollectionOfEntities.and((ElementMatcher)doesNotHaveRelationShipAnnotation);
        boolean mapEager = !type.hasMoreThanOneField((ElementMatcher<? super FieldDescription.InDefinedShape>)isCollectionOfEntities);
        AnnotationDescription oneToOneDescription = this.createRelationshipAnnotation(this.jpa.getAnnotation("OneToOne"), true);
        AnnotationDescription oneToManyDescription = this.createRelationshipAnnotation(this.jpa.getAnnotation("OneToMany"), mapEager);
        AnnotationDescription joinColumnAnnotation = this.getJoinColumnAnnotation();
        JMoleculesType result = type.annotateFieldWith(oneToOneDescription, (ElementMatcher.Junction<FieldDescription>)isUndefaultedEntity, new Class[0]).annotateFieldWith(joinColumnAnnotation, (ElementMatcher.Junction<FieldDescription>)isUndefaultedEntity.and((ElementMatcher)doesNotHaveAtJoinColumn), new Class[0]).annotateFieldWith(oneToManyDescription, (ElementMatcher.Junction<FieldDescription>)isUndefaultCollectionOfEntities, new Class[0]).annotateFieldWith(joinColumnAnnotation, (ElementMatcher.Junction<FieldDescription>)isUndefaultCollectionOfEntities.and((ElementMatcher)doesNotHaveAtJoinColumn), new Class[0]);
        if (!mapEager && this.jpa.isHibernate()) {
            Class fetchType = this.jpa.getType("org.hibernate.annotations.Fetch");
            Class fetchModeType = this.jpa.getType("org.hibernate.annotations.FetchMode");
            AnnotationDescription fetchAnnotation = AnnotationDescription.Builder.ofType(fetchType).define("value", Enum.valueOf(fetchModeType, "SUBSELECT")).build();
            result = result.annotateFieldWith(fetchAnnotation, (ElementMatcher.Junction<FieldDescription>)isCollectionOfEntities, new Class[0]);
        }
        return result;
    }

    private <T extends Enum<T>> AnnotationDescription createRelationshipAnnotation(Class<? extends Annotation> type, boolean eager) {
        Class cascadeType = this.jpa.getType("CascadeType");
        Enum value = (Enum)this.jpa.getCascadeTypeAll();
        Enum fetchType = eager ? (Enum)this.jpa.getFetchTypeEager() : (Enum)this.jpa.getFetchTypeLazy();
        return AnnotationDescription.Builder.ofType(type).define("fetch", fetchType).define("orphanRemoval", true).defineEnumerationArray("cascade", cascadeType, new Enum[]{value}).build();
    }

    private AnnotationDescription getJoinColumnAnnotation() {
        return AnnotationDescription.Builder.ofType(this.jpa.getType("JoinColumn")).build();
    }

    private DynamicType.Builder<?> declareNullVerificationMethod(DynamicType.Builder<?> builder, PluginLogger.Log logger) {
        TypeDescription type = builder.toTypeDescription();
        if (type.isAbstract()) {
            logger.info("Not adding nullability verification to abstract type.", new Object[0]);
            return builder;
        }
        if (((MethodList)type.getDeclaredMethods().filter(it -> it.getName().equals(NULLABILITY_METHOD_NAME))).size() > 0) {
            logger.info("Nullability verification already added.", new Object[0]);
            return builder;
        }
        builder = builder.defineMethod(NULLABILITY_METHOD_NAME, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept((Implementation)StubMethod.INSTANCE);
        Function<String, Advice> advice = it -> {
            logger.info("Adding nullability verification to existing callback method {}().", it);
            return Advice.to(JMoleculesJpa.class);
        };
        Supplier<Implementation> implementation = () -> {
            logger.info("Adding nullability verification using new callback methods.", new Object[0]);
            return MethodDelegation.to(JMoleculesJpa.class);
        };
        return new LifecycleMethods((DynamicType.Builder<?>)builder, this.jpa.getAnnotation("PrePersist"), this.jpa.getAnnotation("PostLoad")).apply(advice, implementation);
    }

    private JMoleculesType handleValueObject(JMoleculesType type) {
        return type.addDefaultConstructorIfMissing().annotateTypeIfMissing(this.jpa.getAnnotation("Embeddable"), new Class[0]);
    }

    private DynamicType.Builder<?> applyRecordInstantiator(DynamicType.Builder<?> builder, PluginLogger.Log logger) {
        TypeDescription description = builder.toTypeDescription();
        if (!description.isRecord() || this.embeddableInstantiatorAnnotationType == null) {
            return builder;
        }
        if (description.getDeclaredAnnotations().isAnnotationPresent(this.embeddableInstantiatorAnnotationType)) {
            logger.info("Found explicit @EmbeddableInstantiator.", new Object[0]);
            return builder;
        }
        logger.info("Adding @EmbeddableInstantiator for record.", new Object[0]);
        Class instantiatorBaseType = this.jpa.getType("org.jmolecules.hibernate.RecordInstantiator");
        TypeDescription.ForLoadedType supeType = new TypeDescription.ForLoadedType(instantiatorBaseType);
        Constructor<?> constructor = JMoleculesJpaPlugin.getConstructor(instantiatorBaseType, Class.class);
        DynamicType.Unloaded instantiatorType = new ByteBuddy(ClassFileVersion.JAVA_V8).with((NamingStrategy)new ReferenceTypePackageNamingStrategy(description)).subclass((TypeDefinition)supeType).defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PACKAGE_PRIVATE}).intercept((Implementation)MethodCall.invoke(constructor).onSuper().with(new TypeDescription[]{description})).make();
        builder = builder.require(new DynamicType[]{instantiatorType});
        return builder.annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(this.embeddableInstantiatorAnnotationType).define("value", instantiatorType.getTypeDescription()).build()});
    }

    private static Constructor<?> getConstructor(Class<?> type, Class<?> ... parameters) {
        try {
            return type.getDeclaredConstructor(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JMoleculesJpaPlugin() {
    }
}

