/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.validator.impl;

import java.util.Set;
import javax.lang.model.element.Element;
import org.jmolecules.annotation.processor.aptk.tools.Utilities;
import org.jmolecules.annotation.processor.aptk.tools.matcher.CriteriaMatcher;

public class CriteriaElementValidatorImpl {
    public static CriteriaElementValidatorImpl INSTANCE = new CriteriaElementValidatorImpl();

    private CriteriaElementValidatorImpl() {
    }

    @SafeVarargs
    public final <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> boolean validateByValidatorKind(ValidatorKind validatorKind, MATCHER matcher, ELEMENT element, CRITERIA ... criteriaToCheck) {
        if (validatorKind == null) {
            return false;
        }
        switch (validatorKind) {
            case HAS_ONE_OF: {
                return this.hasOneOf(matcher, element, criteriaToCheck);
            }
            case HAS_NONE_OF: {
                return this.hasNoneOf(matcher, element, criteriaToCheck);
            }
            case HAS_AT_LEAST_ONE_OF: {
                return this.hasAtLeastOneOf(matcher, element, criteriaToCheck);
            }
            case HAS_ALL_OF: {
                return this.hasAllOf(matcher, element, criteriaToCheck);
            }
        }
        return false;
    }

    @SafeVarargs
    public final <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> boolean hasOneOf(MATCHER matcher, ELEMENT element, CRITERIA ... criteriaToCheck) {
        if (element == null || matcher == null) {
            return false;
        }
        if (criteriaToCheck == null) {
            return true;
        }
        Set<CRITERIA> criteriaToCheckSet = Utilities.convertArrayToSet(criteriaToCheck);
        if (criteriaToCheckSet.size() == 0) {
            return true;
        }
        int count = 0;
        for (CRITERIA criteria : Utilities.convertArrayToSet(criteriaToCheck)) {
            if (!matcher.checkForMatchingCharacteristic(element, criteria)) continue;
            ++count;
        }
        return count == 1;
    }

    @SafeVarargs
    public final <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> boolean hasNoneOf(MATCHER matcher, ELEMENT element, CRITERIA ... criteriaToCheck) {
        if (element == null || matcher == null) {
            return false;
        }
        if (criteriaToCheck == null) {
            return true;
        }
        Set<CRITERIA> criteriaToCheckSet = Utilities.convertArrayToSet(criteriaToCheck);
        if (criteriaToCheckSet.size() == 0) {
            return true;
        }
        for (CRITERIA criteria : Utilities.convertArrayToSet(criteriaToCheck)) {
            if (!matcher.checkForMatchingCharacteristic(element, criteria)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public final <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> boolean hasAllOf(MATCHER matcher, ELEMENT element, CRITERIA ... criteriaToCheck) {
        if (element == null || matcher == null) {
            return false;
        }
        if (criteriaToCheck == null) {
            return true;
        }
        Set<CRITERIA> criteriaToCheckSet = Utilities.convertArrayToSet(criteriaToCheck);
        if (criteriaToCheckSet.size() == 0) {
            return true;
        }
        for (CRITERIA criteria : Utilities.convertArrayToSet(criteriaToCheck)) {
            if (matcher.checkForMatchingCharacteristic(element, criteria)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public final <ELEMENT extends Element, CRITERIA, MATCHER extends CriteriaMatcher<ELEMENT, CRITERIA>> boolean hasAtLeastOneOf(MATCHER matcher, ELEMENT element, CRITERIA ... criteriaToCheck) {
        if (element == null || matcher == null) {
            return false;
        }
        if (criteriaToCheck == null) {
            return true;
        }
        Set<CRITERIA> criteriaToCheckSet = Utilities.convertArrayToSet(criteriaToCheck);
        if (criteriaToCheckSet.size() == 0) {
            return true;
        }
        for (CRITERIA criteria : criteriaToCheck) {
            if (!matcher.checkForMatchingCharacteristic(element, criteria)) continue;
            return true;
        }
        return false;
    }

    public static enum ValidatorKind {
        HAS_ONE_OF,
        HAS_NONE_OF,
        HAS_AT_LEAST_ONE_OF,
        HAS_ALL_OF;

    }
}

