/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.jmolecules.annotation.processor.aptk.tools.ElementUtils;
import org.jmolecules.annotation.processor.aptk.tools.TypeUtils;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.TypeElementWrapper;

public class TypeMirrorWrapper {
    private final TypeMirror typeMirror;

    TypeMirrorWrapper(TypeMirror typeMirror) {
        if (typeMirror == null) {
            throw new IllegalArgumentException("Passed typeMirror must not be null");
        }
        this.typeMirror = typeMirror;
    }

    public TypeMirrorWrapper erasure() {
        return TypeMirrorWrapper.wrap(TypeUtils.getTypes().erasure(this.typeMirror));
    }

    public TypeKind getKind() {
        return this.typeMirror.getKind();
    }

    public boolean isPrimitive() {
        return TypeMirrorWrapper.isPrimitive(this.typeMirror);
    }

    public static boolean isPrimitive(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isPrimitive(typeMirror);
    }

    public PrimitiveType getPrimitiveType() {
        return TypeMirrorWrapper.getPrimitiveType(this.typeMirror);
    }

    public static PrimitiveType getPrimitiveType(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isPrimitive(typeMirror) ? (PrimitiveType)typeMirror : null;
    }

    public boolean isTypeVar() {
        return TypeMirrorWrapper.isTypeVar(this.typeMirror);
    }

    public static boolean isTypeVar(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isTypeVar(typeMirror);
    }

    public TypeVariable getTypeVar() {
        return TypeMirrorWrapper.getTypeVar(this.typeMirror);
    }

    public static TypeVariable getTypeVar(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isTypeVar(typeMirror) ? (TypeVariable)typeMirror : null;
    }

    public boolean isInterface() {
        return TypeMirrorWrapper.isInterface(this.typeMirror);
    }

    public static boolean isInterface(TypeMirror typeMirror) {
        Optional<TypeElementWrapper> typeMirrorWrapper = TypeMirrorWrapper.getTypeElement(typeMirror);
        return typeMirrorWrapper.isPresent() && typeMirrorWrapper.get().isInterface();
    }

    public boolean isEnum() {
        return TypeMirrorWrapper.isEnum(this.typeMirror);
    }

    public static boolean isEnum(TypeMirror typeMirror) {
        Optional<TypeElementWrapper> typeMirrorWrapper = TypeMirrorWrapper.getTypeElement(typeMirror);
        return typeMirrorWrapper.isPresent() && typeMirrorWrapper.get().isEnum();
    }

    public boolean isClass() {
        return TypeMirrorWrapper.isClass(this.typeMirror);
    }

    public static boolean isClass(TypeMirror typeMirror) {
        Optional<TypeElementWrapper> typeMirrorWrapper = TypeMirrorWrapper.getTypeElement(typeMirror);
        return typeMirrorWrapper.isPresent() && typeMirrorWrapper.get().isClass();
    }

    public boolean isAnnotation() {
        return TypeMirrorWrapper.isAnnotation(this.typeMirror);
    }

    public static boolean isAnnotation(TypeMirror typeMirror) {
        Optional<TypeElementWrapper> typeMirrorWrapper = TypeMirrorWrapper.getTypeElement(typeMirror);
        return typeMirrorWrapper.isPresent() && typeMirrorWrapper.get().isAnnotation();
    }

    public boolean isCollection() {
        return TypeMirrorWrapper.isCollection(this.typeMirror);
    }

    public static boolean isCollection(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isDeclared(typeMirror) && TypeUtils.TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(typeMirror), TypeUtils.TypeRetrieval.getTypeMirror(Collection.class));
    }

    public boolean isIterable() {
        return TypeMirrorWrapper.isIterable(this.typeMirror);
    }

    public static boolean isIterable(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isDeclared(typeMirror) && TypeUtils.TypeComparison.isAssignableTo(TypeUtils.getTypes().erasure(typeMirror), TypeUtils.TypeRetrieval.getTypeMirror(Iterable.class));
    }

    public boolean isArray() {
        return TypeMirrorWrapper.isArray(this.typeMirror);
    }

    public static boolean isArray(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isArray(typeMirror);
    }

    public ArrayType getArrayType() {
        return TypeMirrorWrapper.getArrayType(this.typeMirror);
    }

    public static ArrayType getArrayType(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isArray(typeMirror) ? (ArrayType)typeMirror : null;
    }

    public boolean isDeclared() {
        return TypeMirrorWrapper.isDeclared(this.typeMirror);
    }

    public static boolean isDeclared(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isDeclared(typeMirror);
    }

    public DeclaredType getDeclaredType() {
        return TypeMirrorWrapper.getDeclaredType(this.typeMirror);
    }

    public static DeclaredType getDeclaredType(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isDeclared(typeMirror) ? (DeclaredType)typeMirror : null;
    }

    public boolean isVoidType() {
        return TypeMirrorWrapper.isVoidType(this.typeMirror);
    }

    public static boolean isVoidType(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isVoid(typeMirror);
    }

    public boolean isWildcardType() {
        return TypeMirrorWrapper.isWildcardType(this.typeMirror);
    }

    public static boolean isWildcardType(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isWildcard(typeMirror);
    }

    public WildcardType getWildcardType() {
        return TypeMirrorWrapper.getWildcardType(this.typeMirror);
    }

    public static WildcardType getWildcardType(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isWildcardType(typeMirror) ? (WildcardType)typeMirror : null;
    }

    public boolean isErrorType() {
        return TypeMirrorWrapper.isErrorType(this.typeMirror);
    }

    public static boolean isErrorType(TypeMirror typeMirror) {
        return TypeUtils.CheckTypeKind.isError(typeMirror);
    }

    public boolean hasComponentType() {
        return TypeMirrorWrapper.hasComponentType(this.typeMirror);
    }

    public static boolean hasComponentType(TypeMirror typeMirror) {
        return TypeMirrorWrapper.getComponentType(typeMirror) != null;
    }

    public TypeMirror getComponentType() {
        return TypeMirrorWrapper.getComponentType(this.typeMirror);
    }

    public static TypeMirror getComponentType(TypeMirror typeMirror) {
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return ((ArrayType)typeMirror).getComponentType();
        }
        if (TypeMirrorWrapper.isCollection(typeMirror) || TypeMirrorWrapper.isIterable(typeMirror)) {
            if (TypeMirrorWrapper.hasTypeArguments(typeMirror)) {
                List<? extends TypeMirror> typeArgumentTypeMirrors = TypeMirrorWrapper.getTypeArguments(typeMirror);
                return typeArgumentTypeMirrors.get(0);
            }
            return TypeUtils.TypeRetrieval.getTypeMirror(Object.class);
        }
        return null;
    }

    public TypeMirrorWrapper getWrappedComponentType() {
        return TypeMirrorWrapper.getWrappedComponentType(this.typeMirror);
    }

    public static TypeMirrorWrapper getWrappedComponentType(TypeMirror typeMirror) {
        TypeMirror componentTypeMirror = TypeMirrorWrapper.getComponentType(typeMirror);
        return componentTypeMirror != null ? TypeMirrorWrapper.wrap(componentTypeMirror) : null;
    }

    public boolean hasTypeArguments() {
        return TypeMirrorWrapper.hasTypeArguments(this.typeMirror);
    }

    public static boolean hasTypeArguments(TypeMirror typeMirror) {
        return TypeMirrorWrapper.isDeclared(typeMirror) && TypeMirrorWrapper.getDeclaredType(typeMirror).getTypeArguments().size() > 0;
    }

    public List<? extends TypeMirror> getTypeArguments() {
        return TypeMirrorWrapper.getTypeArguments(this.typeMirror);
    }

    public static List<? extends TypeMirror> getTypeArguments(TypeMirror typeMirror) {
        if (TypeMirrorWrapper.isDeclared(typeMirror) && TypeMirrorWrapper.hasTypeArguments(typeMirror)) {
            return TypeMirrorWrapper.getDeclaredType(typeMirror).getTypeArguments();
        }
        return null;
    }

    public List<TypeMirrorWrapper> getWrappedTypeArguments() {
        return TypeMirrorWrapper.getWrappedTypeArguments(this.typeMirror);
    }

    public static List<TypeMirrorWrapper> getWrappedTypeArguments(TypeMirror typeMirror) {
        List<? extends TypeMirror> typeArguments = TypeMirrorWrapper.getTypeArguments(typeMirror);
        if (typeArguments != null) {
            ArrayList<TypeMirrorWrapper> wrappedTypeArguments = new ArrayList<TypeMirrorWrapper>();
            for (TypeMirror typeMirror2 : typeArguments) {
                wrappedTypeArguments.add(TypeMirrorWrapper.wrap(typeMirror2));
            }
            return wrappedTypeArguments;
        }
        return null;
    }

    public String getPackage() {
        return TypeMirrorWrapper.getPackage(this.typeMirror);
    }

    public static String getPackage(TypeMirror typeMirror) {
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return TypeMirrorWrapper.getPackage(new TypeMirrorWrapper(typeMirror).getComponentType());
        }
        if (TypeMirrorWrapper.isDeclared(typeMirror)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return ((PackageElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(declaredType.asElement(), ElementKind.PACKAGE)).getQualifiedName().toString();
        }
        return null;
    }

    public String getQualifiedName() {
        return TypeMirrorWrapper.getQualifiedName(this.typeMirror);
    }

    public static String getQualifiedName(TypeMirror typeMirror) {
        if (TypeMirrorWrapper.isDeclared(typeMirror)) {
            return ((TypeElement)TypeMirrorWrapper.getDeclaredType(typeMirror).asElement()).getQualifiedName().toString();
        }
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return TypeMirrorWrapper.getQualifiedName(TypeMirrorWrapper.getArrayType(typeMirror).getComponentType());
        }
        if (TypeMirrorWrapper.isPrimitive(typeMirror)) {
            return typeMirror.toString();
        }
        return null;
    }

    public String getBinaryName() {
        return TypeMirrorWrapper.getBinaryName(this.typeMirror);
    }

    public static String getBinaryName(TypeMirror typeMirror) {
        if (TypeMirrorWrapper.isDeclared(typeMirror)) {
            return TypeElementWrapper.wrap((TypeElement)TypeMirrorWrapper.getDeclaredType(typeMirror).asElement()).getBinaryName();
        }
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return TypeMirrorWrapper.getBinaryName(TypeMirrorWrapper.getArrayType(typeMirror).getComponentType());
        }
        if (TypeMirrorWrapper.isPrimitive(typeMirror)) {
            return typeMirror.toString();
        }
        return null;
    }

    public String getSimpleName() {
        return TypeMirrorWrapper.getSimpleName(this.typeMirror);
    }

    public static String getSimpleName(TypeMirror typeMirror) {
        if (TypeMirrorWrapper.isDeclared(typeMirror)) {
            return ((TypeElement)TypeMirrorWrapper.getDeclaredType(typeMirror).asElement()).getSimpleName().toString();
        }
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return TypeMirrorWrapper.getSimpleName(TypeMirrorWrapper.getArrayType(typeMirror).getComponentType());
        }
        if (TypeMirrorWrapper.isPrimitive(typeMirror)) {
            return typeMirror.toString();
        }
        return null;
    }

    public String getTypeDeclaration() {
        return TypeMirrorWrapper.getTypeDeclaration(this.typeMirror);
    }

    public static String getTypeDeclaration(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.VOID) {
            return "void";
        }
        if (TypeMirrorWrapper.isPrimitive(typeMirror)) {
            return typeMirror.toString();
        }
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return TypeMirrorWrapper.getTypeDeclaration(TypeMirrorWrapper.getComponentType(typeMirror)) + "[]";
        }
        if (TypeMirrorWrapper.isTypeVar(typeMirror)) {
            return typeMirror.toString();
        }
        if (TypeMirrorWrapper.isDeclared(typeMirror)) {
            TypeMirrorWrapper tmw = TypeMirrorWrapper.wrap(typeMirror);
            return tmw.getSimpleName() + (tmw.hasTypeArguments() ? "<" + tmw.getWrappedTypeArguments().stream().map(e -> TypeMirrorWrapper.getTypeDeclaration(e.unwrap())).collect(Collectors.joining(", ")) + ">" : "");
        }
        if (TypeMirrorWrapper.isWildcardType(typeMirror)) {
            WildcardType wildcardType = TypeMirrorWrapper.getWildcardType(typeMirror);
            if (wildcardType.getSuperBound() != null) {
                return "? super " + TypeMirrorWrapper.getTypeDeclaration(wildcardType.getSuperBound());
            }
            if (wildcardType.getExtendsBound() != null) {
                return "? extends " + TypeMirrorWrapper.getTypeDeclaration(wildcardType.getExtendsBound());
            }
            return "?";
        }
        return typeMirror.toString();
    }

    public String getTypeInitializationWithDiamondOperator() {
        return TypeMirrorWrapper.getTypeInitializationWithDiamondOperator(this.typeMirror);
    }

    public static String getTypeInitializationWithDiamondOperator(TypeMirror typeMirror) {
        return TypeMirrorWrapper.getSimpleName(typeMirror) + (TypeMirrorWrapper.hasTypeArguments(typeMirror) ? "<>" : "");
    }

    public Set<String> getImports() {
        return TypeMirrorWrapper.getImports(this.typeMirror);
    }

    public static Set<String> getImports(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return Collections.emptySet();
        }
        if (TypeMirrorWrapper.isArray(typeMirror)) {
            return TypeMirrorWrapper.getImports(((ArrayType)typeMirror).getComponentType());
        }
        if (TypeMirrorWrapper.isPrimitive(typeMirror)) {
            return Collections.emptySet();
        }
        if (TypeUtils.CheckTypeKind.isOfTypeKind(typeMirror, TypeKind.WILDCARD)) {
            WildcardType wildcardType = (WildcardType)typeMirror;
            HashSet<String> result = new HashSet<String>();
            result.addAll(TypeMirrorWrapper.getImports(wildcardType.getExtendsBound()));
            result.addAll(TypeMirrorWrapper.getImports(wildcardType.getSuperBound()));
            return result;
        }
        if (TypeUtils.CheckTypeKind.isDeclared(typeMirror)) {
            HashSet<String> result = new HashSet<String>();
            String packageName = TypeMirrorWrapper.getPackage(typeMirror);
            if (packageName != null && !"java.lang".equals(packageName)) {
                result.add(TypeMirrorWrapper.getQualifiedName(typeMirror));
            }
            if (TypeMirrorWrapper.hasTypeArguments(typeMirror)) {
                for (TypeMirror typeMirror2 : TypeMirrorWrapper.getDeclaredType(typeMirror).getTypeArguments()) {
                    result.addAll(TypeMirrorWrapper.getImports(typeMirror2));
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    public Optional<TypeElementWrapper> getTypeElement() {
        return TypeMirrorWrapper.getTypeElement(this.typeMirror);
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(TypeMirrorWrapper.wrap(clazz));
    }

    public boolean isAssignableTo(TypeMirror otherTypeMirror) {
        return this.isAssignableTo(TypeMirrorWrapper.wrap(otherTypeMirror));
    }

    public boolean isAssignableTo(TypeMirrorWrapper otherTypeMirrorWrapper) {
        return TypeUtils.TypeComparison.isAssignableTo(this.typeMirror, otherTypeMirrorWrapper.unwrap());
    }

    public boolean isAssignableTo(TypeElementWrapper typeElementWrapper) {
        return this.isAssignableTo(typeElementWrapper.asType());
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom(TypeMirrorWrapper.wrap(clazz));
    }

    public boolean isAssignableFrom(TypeMirror otherTypeMirror) {
        return this.isAssignableFrom(TypeMirrorWrapper.wrap(otherTypeMirror));
    }

    public boolean isAssignableFrom(TypeMirrorWrapper otherTypeMirrorWrapper) {
        return TypeUtils.TypeComparison.isAssignableTo(otherTypeMirrorWrapper.unwrap(), this.typeMirror);
    }

    public boolean isAssignableFrom(TypeElementWrapper typeElementWrapper) {
        return this.isAssignableFrom(typeElementWrapper.asType());
    }

    public int hashCode() {
        return this.typeMirror.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeMirrorWrapper) {
            return this.typeMirror.equals(((TypeMirrorWrapper)obj).unwrap());
        }
        if (obj instanceof TypeMirror) {
            return this.typeMirror.equals(obj);
        }
        return false;
    }

    public String toString() {
        return this.typeMirror.toString();
    }

    public TypeMirror unwrap() {
        return this.typeMirror;
    }

    public static Optional<TypeElementWrapper> getTypeElement(TypeMirror typeMirror) {
        if (typeMirror != null && TypeMirrorWrapper.isDeclared(typeMirror)) {
            return Optional.of(TypeElementWrapper.wrap((TypeElement)TypeMirrorWrapper.getDeclaredType(typeMirror).asElement()));
        }
        return Optional.empty();
    }

    public static TypeMirrorWrapper wrap(TypeElement typeElement) {
        return TypeMirrorWrapper.wrap(TypeElementWrapper.wrap(typeElement));
    }

    public static TypeMirrorWrapper wrap(TypeElementWrapper typeElement) {
        return typeElement.asType();
    }

    public static TypeMirrorWrapper wrap(TypeMirror typeMirror) {
        return new TypeMirrorWrapper(typeMirror);
    }

    public static TypeMirrorWrapper wrap(String fqn) {
        return TypeMirrorWrapper.wrap(TypeUtils.TypeRetrieval.getTypeMirror(fqn));
    }

    public static TypeMirrorWrapper wrap(Class<?> clazz) {
        return TypeMirrorWrapper.wrap(TypeUtils.TypeRetrieval.getTypeMirror(clazz));
    }
}

