/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jmolecules.annotation.processor.aptk.tools.TypeMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.TypeUtils;
import org.jmolecules.annotation.processor.aptk.tools.Utilities;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.AptkCoreMatchers;
import org.jmolecules.annotation.processor.aptk.tools.fluentfilter.FluentElementFilter;

public final class ElementUtils {
    private ElementUtils() {
    }

    static List<String> getImportsNeededByMethodsSignature() {
        return null;
    }

    public static class ForExecutableElements {
        private ForExecutableElements() {
        }

        static String getMethodSignature(ExecutableElement executableElement) {
            StringBuilder builder = new StringBuilder();
            if (!executableElement.getTypeParameters().isEmpty()) {
                builder.append("<");
                builder.append(executableElement.getTypeParameters().stream().map(tp -> tp.toString() + " extends " + TypeMirrorWrapper.wrap(tp.getBounds().get(0)).getTypeDeclaration()).collect(Collectors.joining(", ")));
                builder.append("> ");
            }
            TypeMirrorWrapper wrappedReturnType = TypeMirrorWrapper.wrap(executableElement.getReturnType());
            builder.append(wrappedReturnType.getTypeDeclaration()).append(" ").append(executableElement.getSimpleName());
            builder.append("(");
            builder.append(executableElement.getParameters().stream().map(element -> TypeMirrorWrapper.wrap(element.asType()).getTypeDeclaration() + " " + element.getSimpleName().toString()).collect(Collectors.joining(", ")));
            builder.append(")");
            if (!executableElement.getThrownTypes().isEmpty()) {
                builder.append(" throws ");
                builder.append(executableElement.getThrownTypes().stream().map(tm -> TypeMirrorWrapper.wrap(tm).getSimpleName()).collect(Collectors.joining(", ")));
            }
            return builder.toString();
        }
    }

    public static final class AccessTypeHierarchy {
        private AccessTypeHierarchy() {
        }

        public static TypeElement[] getDirectSuperTypeElements(TypeElement typeElement) {
            if (typeElement == null) {
                return new TypeElement[0];
            }
            List<? extends TypeMirror> superTypeMirrors = TypeUtils.getTypes().directSupertypes(typeElement.asType());
            ArrayList<TypeElement> superTypeElements = new ArrayList<TypeElement>();
            for (TypeMirror typeMirror : superTypeMirrors) {
                superTypeElements.add(TypeUtils.TypeRetrieval.getTypeElement(typeMirror));
            }
            return superTypeElements.toArray(new TypeElement[0]);
        }

        public static TypeElement[] getSuperTypeElements(TypeElement typeElement) {
            TypeElement[] superTypes = AccessTypeHierarchy.getDirectSuperTypeElements(typeElement);
            ArrayList<TypeElement> superTypeElements = new ArrayList<TypeElement>();
            for (TypeElement superType : superTypes) {
                TypeElement[] elementsToBeAdded;
                superTypeElements.add(superType);
                for (TypeElement elementToBeAdded : elementsToBeAdded = AccessTypeHierarchy.getSuperTypeElements(superType)) {
                    if (superTypeElements.contains(elementToBeAdded)) continue;
                    superTypeElements.add(elementToBeAdded);
                }
            }
            return superTypeElements.toArray(new TypeElement[0]);
        }

        public static TypeElement getDirectSuperTypeElementOfKindType(TypeElement typeElement) {
            FluentElementFilter<TypeElement> fluentElementFilter = FluentElementFilter.createFluentElementFilter(Arrays.asList(AccessTypeHierarchy.getDirectSuperTypeElements(typeElement))).applyFilter(AptkCoreMatchers.IS_CLASS);
            return fluentElementFilter.hasSingleElement() ? fluentElementFilter.getResult().get(0) : null;
        }

        public static TypeElement[] getDirectSuperTypeElementsOfKindInterface(TypeElement typeElement) {
            List<TypeElement> resultList = FluentElementFilter.createFluentElementFilter(Arrays.asList(AccessTypeHierarchy.getDirectSuperTypeElements(typeElement))).applyFilter(AptkCoreMatchers.IS_INTERFACE).getResult();
            return resultList.toArray(new TypeElement[0]);
        }

        public static TypeElement[] getSuperTypeElementsOfKindType(TypeElement typeElement) {
            List<TypeElement> resultList = FluentElementFilter.createFluentElementFilter(Arrays.asList(AccessTypeHierarchy.getSuperTypeElements(typeElement))).applyFilter(AptkCoreMatchers.IS_CLASS).getResult();
            return resultList.toArray(new TypeElement[0]);
        }

        public static TypeElement[] getSuperTypeElementsOfKindInterface(TypeElement typeElement) {
            List<TypeElement> resultList = FluentElementFilter.createFluentElementFilter(Arrays.asList(AccessTypeHierarchy.getSuperTypeElements(typeElement))).applyFilter(AptkCoreMatchers.IS_INTERFACE).getResult();
            return resultList.toArray(new TypeElement[0]);
        }
    }

    public static final class AccessEnclosedElements {
        private AccessEnclosedElements() {
        }

        public static List<VariableElement> getEnclosedFields(TypeElement e) {
            List enclosedElementsOfKind = AccessEnclosedElements.getEnclosedElementsOfKind(e, ElementKind.FIELD);
            return CastElement.castElementList(enclosedElementsOfKind);
        }

        public static List<ExecutableElement> getEnclosedMethods(TypeElement e) {
            List enclosedElementsOfKind = AccessEnclosedElements.getEnclosedElementsOfKind(e, ElementKind.METHOD);
            return CastElement.castElementList(enclosedElementsOfKind);
        }

        public static List<ExecutableElement> getEnclosedConstructors(TypeElement e) {
            List enclosedElementsOfKind = AccessEnclosedElements.getEnclosedElementsOfKind(e, ElementKind.CONSTRUCTOR);
            return CastElement.castElementList(enclosedElementsOfKind);
        }

        public static List<TypeElement> getEnclosedTypes(TypeElement e) {
            List enclosedElementsOfKind = AccessEnclosedElements.getEnclosedElementsOfKind(e, ElementKind.CLASS);
            return CastElement.castElementList(enclosedElementsOfKind);
        }

        public static List<Element> getEnclosedElementsByName(Element element, String ... name) {
            if (element == null) {
                return new ArrayList<Element>();
            }
            return CastElement.castElementList(AptkCoreMatchers.BY_NAME.getFilter().filterByOneOf(element.getEnclosedElements(), (String[])name), Element.class);
        }

        public static List<Element> getEnclosedElementsByNameRegex(Element element, String ... nameRegexes) {
            ArrayList<Element> result = new ArrayList<Element>();
            if (element != null && nameRegexes != null) {
                block0: for (Element element2 : element.getEnclosedElements()) {
                    for (String nameRegex : nameRegexes) {
                        Pattern pattern = Pattern.compile(nameRegex);
                        if (!pattern.matcher(element2.getSimpleName().toString()).matches()) continue;
                        result.add(element2);
                        continue block0;
                    }
                }
            }
            return result;
        }

        public static <T extends Element> List<T> getEnclosedElementsOfKind(Element element, ElementKind ... kind) {
            if (element == null) {
                return new ArrayList();
            }
            return AptkCoreMatchers.BY_ELEMENT_KIND.getFilter().filterByOneOf(element.getEnclosedElements(), (ElementKind[])kind);
        }

        public static List<Element> getEnclosedElementsWithAllAnnotationsOf(Element element, Class<? extends Annotation> ... annotations) {
            if (element == null) {
                return new ArrayList<Element>();
            }
            return AptkCoreMatchers.BY_ANNOTATION.getFilter().filterByAllOf(element.getEnclosedElements(), annotations);
        }

        public static List<Element> getEnclosedElementsWithAtLeastOneAnnotationOf(Element element, Class<? extends Annotation> ... annotations) {
            if (element == null) {
                return new ArrayList<Element>();
            }
            return AptkCoreMatchers.BY_ANNOTATION.getFilter().filterByAtLeastOneOf(element.getEnclosedElements(), annotations);
        }

        public static List<Element> flattenEnclosedElementTree(Element element, boolean addRootElement) {
            return AccessEnclosedElements.flattenEnclosedElementTree(element, addRootElement, Integer.MAX_VALUE);
        }

        public static List<Element> flattenEnclosedElementTree(Element element, boolean addRootElement, int maxDepth) {
            ArrayList<Element> result = new ArrayList<Element>();
            if (element == null) {
                return result;
            }
            if (addRootElement) {
                result.add(element);
            }
            AccessEnclosedElements.flattenEnclosedElementTree(element, maxDepth, result, -1);
            return result;
        }

        private static void flattenEnclosedElementTree(Element element, int maxDepth, List<Element> result, int currentDepth) {
            if (currentDepth < maxDepth) {
                if (currentDepth >= 0) {
                    result.add(element);
                }
                ++currentDepth;
                for (Element element2 : element.getEnclosedElements()) {
                    AccessEnclosedElements.flattenEnclosedElementTree(element2, maxDepth, result, currentDepth);
                }
            }
        }
    }

    public static final class AccessEnclosingElements {
        private AccessEnclosingElements() {
        }

        public static List<Element> getFlattenedEnclosingElementsTree(Element element, boolean addRootElement) {
            return AccessEnclosingElements.getFlattenedEnclosingElementsTree(element, addRootElement, Integer.MAX_VALUE);
        }

        public static List<Element> getFlattenedEnclosingElementsTree(Element element, boolean addRootElement, int maxDepth) {
            ArrayList<Element> result = new ArrayList<Element>();
            if (element == null) {
                return result;
            }
            if (addRootElement) {
                result.add(element);
            }
            int currentDepth = 0;
            for (Element currentParentElement = element.getEnclosingElement(); currentParentElement != null && currentDepth < maxDepth; ++currentDepth, currentParentElement = currentParentElement.getEnclosingElement()) {
                result.add(currentParentElement);
            }
            return result;
        }

        public static <T extends Element> T getFirstEnclosingElementOfKind(Element element, ElementKind ... elementKinds) {
            if (element == null || elementKinds == null) {
                return null;
            }
            for (Element currentParentElement = element.getEnclosingElement(); currentParentElement != null; currentParentElement = currentParentElement.getEnclosingElement()) {
                for (ElementKind elementKind : elementKinds) {
                    if (currentParentElement.getKind() != elementKind) continue;
                    return (T)currentParentElement;
                }
            }
            return null;
        }
    }

    public static final class CheckModifierOfElement {
        private CheckModifierOfElement() {
        }

        public static boolean hasPublicModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.PUBLIC);
        }

        public static boolean hasProtectedModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.PROTECTED);
        }

        public static boolean hasPrivateModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.PRIVATE);
        }

        public static boolean hasAbstractModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.ABSTRACT);
        }

        public static boolean hasStaticModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.STATIC);
        }

        public static boolean hasFinalModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.FINAL);
        }

        public static boolean hasTransientModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.TRANSIENT);
        }

        public static boolean hasVolatileModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.VOLATILE);
        }

        public static boolean hasSynchronizedModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.SYNCHRONIZED);
        }

        public static boolean hasNativeModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.NATIVE);
        }

        public static boolean hasStrictfpModifier(Element e) {
            return CheckModifierOfElement.hasModifier(e, Modifier.STRICTFP);
        }

        private static boolean hasModifier(Element e, Modifier modifier) {
            return AptkCoreMatchers.BY_MODIFIER.getValidator().hasAllOf(e, (Modifier[])new Modifier[]{modifier});
        }

        public static Modifier getVisibilityModifier(Element element) {
            Modifier[] modifiers;
            for (Modifier modifier : modifiers = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE}) {
                if (!CheckModifierOfElement.hasModifier(element, modifier)) continue;
                return modifier;
            }
            return null;
        }
    }

    public static final class CastElement {
        private static final Set<String> TYPE_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet(ElementKind.CLASS.name(), ElementKind.INTERFACE.name(), ElementKind.ENUM.name(), ElementKind.ANNOTATION_TYPE.name(), "RECORD");
        private static final Set<String> RECORD_COMPONENT_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet("RECORD_COMPONENT");
        private static final Set<ElementKind> TYPE_PARAMETER_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet(ElementKind.TYPE_PARAMETER);
        private static final Set<ElementKind> VARIABLE_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet(ElementKind.PARAMETER, ElementKind.FIELD);
        private static final Set<ElementKind> EXECUTABLE_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet(ElementKind.CONSTRUCTOR, ElementKind.METHOD);
        private static final Set<ElementKind> PACKAGE_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet(ElementKind.PACKAGE);
        private static final Set<String> MODULE_ELEMENT_KIND_LUT = Utilities.convertVarargsToSet("MODULE");

        private CastElement() {
        }

        public static boolean isTypeElement(Element e) {
            return e != null && TYPE_ELEMENT_KIND_LUT.contains(e.getKind().name());
        }

        public static boolean isRecordComponentElement(Element e) {
            return e != null && RECORD_COMPONENT_ELEMENT_KIND_LUT.contains(e.getKind().name());
        }

        public static boolean isTypeParameterElement(Element e) {
            return e != null && TYPE_PARAMETER_ELEMENT_KIND_LUT.contains((Object)e.getKind());
        }

        public static boolean isVariableElement(Element e) {
            return e != null && VARIABLE_ELEMENT_KIND_LUT.contains((Object)e.getKind());
        }

        public static boolean isExecutableElement(Element e) {
            return e != null && EXECUTABLE_ELEMENT_KIND_LUT.contains((Object)e.getKind());
        }

        public static boolean isPackageElement(Element e) {
            return e != null && PACKAGE_ELEMENT_KIND_LUT.contains((Object)e.getKind());
        }

        public static boolean isModuleElement(Element e) {
            return e != null && MODULE_ELEMENT_KIND_LUT.contains(e.getKind().toString());
        }

        public static TypeElement castClass(Element e) {
            return CastElement.castToTypeElement(e);
        }

        public static TypeElement castInterface(Element e) {
            return CastElement.castToTypeElement(e);
        }

        public static TypeElement castEnum(Element e) {
            return CastElement.castToTypeElement(e);
        }

        public static TypeElement castAnnotationType(Element e) {
            return CastElement.castToTypeElement(e);
        }

        public static VariableElement castParameter(Element e) {
            return CastElement.castToVariableElement(e);
        }

        public static VariableElement castField(Element e) {
            return CastElement.castToVariableElement(e);
        }

        public static PackageElement castToPackageElement(Element e) {
            return (PackageElement)e;
        }

        public static TypeElement castToTypeElement(Element e) {
            return (TypeElement)e;
        }

        public static TypeParameterElement castToTypeParameterElement(Element e) {
            return (TypeParameterElement)e;
        }

        public static VariableElement castToVariableElement(Element e) {
            return (VariableElement)e;
        }

        public static ExecutableElement castConstructor(Element e) {
            return CastElement.castToExecutableElement(e);
        }

        public static ExecutableElement castMethod(Element e) {
            return CastElement.castToExecutableElement(e);
        }

        public static ExecutableElement castAnnotationAttribute(Element e) {
            return CastElement.castToExecutableElement(e);
        }

        public static ExecutableElement castToExecutableElement(Element e) {
            return (ExecutableElement)e;
        }

        public static <T extends Element> List<T> castElementList(List<? extends Element> elementList, Class<T> typeToCastTo) {
            return CastElement.castElementList(elementList);
        }

        public static <T extends Element> List<T> castElementList(List<? extends Element> elementList) {
            ArrayList<Element> result = new ArrayList<Element>(elementList.size());
            for (Element element : elementList) {
                result.add(element);
            }
            return result;
        }
    }

    public static final class CheckKindOfElement {
        private static final String KIND_MODULE = "MODULE";
        private static final String KIND_RECORD = "RECORD";
        private static final String KIND_RECORD_COMPONENT = "RECORD_COMPONENT";

        private CheckKindOfElement() {
        }

        public static boolean isEnum(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.ENUM);
        }

        public static boolean isRecord(Element e) {
            return e != null && e.getKind().name().equals(KIND_RECORD);
        }

        public static boolean isRecordComponent(Element e) {
            return e != null && e.getKind().name().equals(KIND_RECORD_COMPONENT);
        }

        public static boolean isClass(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.CLASS);
        }

        public static boolean isInterface(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.INTERFACE);
        }

        public static boolean isMethod(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.METHOD);
        }

        public static boolean isParameter(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.PARAMETER);
        }

        public static boolean isConstructor(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.CONSTRUCTOR);
        }

        public static boolean isField(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.FIELD);
        }

        public static boolean isPackage(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.PACKAGE);
        }

        public static boolean isAnnotation(Element e) {
            return CheckKindOfElement.isOfKind(e, ElementKind.ANNOTATION_TYPE);
        }

        public static boolean isModule(Element e) {
            return e != null && e.getKind().name().equals(KIND_MODULE);
        }

        public static boolean isAnnotationAttribute(Element e) {
            return e != null && CheckKindOfElement.isMethod(e) && CheckKindOfElement.isAnnotation(e.getEnclosingElement());
        }

        public static boolean isMethodParameter(Element e) {
            return e != null && CheckKindOfElement.isParameter(e) && CheckKindOfElement.isMethod(e.getEnclosingElement());
        }

        public static boolean isConstructorParameter(Element e) {
            return e != null && CheckKindOfElement.isParameter(e) && CheckKindOfElement.isConstructor(e.getEnclosingElement());
        }

        public static boolean isOfKind(Element e, ElementKind kind) {
            return kind != null && e != null ? kind.equals((Object)e.getKind()) : false;
        }
    }
}

