/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jmolecules.annotation.processor.aptk.tools.AnnotationUtils;
import org.jmolecules.annotation.processor.aptk.tools.ElementUtils;
import org.jmolecules.annotation.processor.aptk.tools.InterfaceUtils;
import org.jmolecules.annotation.processor.aptk.tools.TypeMirrorWrapper;
import org.jmolecules.annotation.processor.aptk.tools.command.impl.GetAttributesCommand;
import org.jmolecules.annotation.processor.aptk.tools.corematcher.AptkCoreMatchers;
import org.jmolecules.annotation.processor.aptk.tools.fluentfilter.FluentElementFilter;
import org.jmolecules.annotation.processor.aptk.tools.fluentvalidator.FluentElementValidator;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.TypeElementWrapper;
import org.jmolecules.annotation.processor.aptk.tools.wrapper.VariableElementWrapper;

public final class BeanUtils {
    static final String[] GETTER_PREFIXES = new String[]{"get", "is", "has"};
    static final String[] SETTER_PREFIXES = new String[]{"set"};

    private BeanUtils() {
    }

    public static boolean hasDefaultNoargsConstructor(TypeElement typeElement) {
        List<ExecutableElement> constructors = FluentElementFilter.createFluentElementFilter(typeElement.getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_CONSTRUCTOR).getResult();
        if (constructors.size() != 1) {
            return false;
        }
        return BeanUtils.isDefaultNoargConstructor(constructors.get(0));
    }

    public static boolean isDefaultNoargConstructor(ExecutableElement element) {
        if (!FluentElementValidator.createFluentElementValidator(element).applyValidator(AptkCoreMatchers.BY_ELEMENT_KIND).hasOneOf((ElementKind[])new ElementKind[]{ElementKind.CONSTRUCTOR}).applyValidator(AptkCoreMatchers.BY_MODIFIER).hasAllOf((Modifier[])new Modifier[]{Modifier.PUBLIC}).applyValidator(AptkCoreMatchers.HAS_NO_PARAMETERS).applyValidator(AptkCoreMatchers.HAS_NO_THROWN_TYPES).justValidate()) {
            return false;
        }
        TypeElement typeElementFilter = (TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(element, ElementKind.CLASS);
        if (!FluentElementFilter.createFluentElementFilter(typeElementFilter.getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_CONSTRUCTOR).hasSingleElement()) {
            return false;
        }
        return ElementUtils.CheckModifierOfElement.getVisibilityModifier(typeElementFilter) == ElementUtils.CheckModifierOfElement.getVisibilityModifier(element);
    }

    public static boolean isAttribute(VariableElement field) {
        return BeanUtils.checkHasSetter(field) && BeanUtils.checkHasGetter(field);
    }

    public static AttributeResult[] getAttributesWithInheritance(TypeElement typeElement, TypeMirrorWrapper ... typeArguments) {
        ArrayList<AttributeResult> resultList = new ArrayList<AttributeResult>(Arrays.asList(GetAttributesCommand.createCommand().execute(typeElement)));
        for (TypeElement superTypeElement : ElementUtils.AccessTypeHierarchy.getSuperTypeElementsOfKindType(typeElement)) {
            TypeElementWrapper wrappedSuperTypeElement = TypeElementWrapper.wrap(superTypeElement);
            Map<String, TypeMirrorWrapper> resolvedTypeArgumentMap = new HashMap<String, TypeMirrorWrapper>();
            if (wrappedSuperTypeElement.hasTypeParameters()) {
                List<TypeMirrorWrapper> resolvedTypeArgumentTypes = InterfaceUtils.getResolvedTypeArgumentOfSuperTypeOrInterface(TypeElementWrapper.wrap(typeElement), TypeMirrorWrapper.wrap(superTypeElement), typeArguments);
                resolvedTypeArgumentMap = InterfaceUtils.mapTypeVars(wrappedSuperTypeElement, resolvedTypeArgumentTypes.toArray(new TypeMirrorWrapper[0]));
            }
            resultList.addAll(Arrays.asList(GetAttributesCommand.createCommand(resolvedTypeArgumentMap).execute(superTypeElement)));
        }
        return resultList.toArray(new AttributeResult[0]);
    }

    public static AttributeResult[] getAttributes(TypeElement typeElement) {
        if (typeElement == null) {
            return new AttributeResult[0];
        }
        List fields = FluentElementFilter.createFluentElementFilter(typeElement.getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_FIELD).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByNoneOf((Modifier[])new Modifier[]{Modifier.STATIC}).getResult();
        ArrayList<AttributeResult> result = new ArrayList<AttributeResult>();
        for (VariableElement field : fields) {
            Optional<String> getterMethodName = BeanUtils.getGetterMethodName(field);
            Optional<String> setterMethodName = BeanUtils.getSetterMethodName(field);
            if (!getterMethodName.isPresent() || !setterMethodName.isPresent()) continue;
            AttributeResult attributeResult = new AttributeResult();
            attributeResult.setField(VariableElementWrapper.wrap(field));
            attributeResult.setGetterMethodName(getterMethodName.get());
            attributeResult.setSetterMethodName(setterMethodName.get());
            result.add(attributeResult);
        }
        return result.toArray(new AttributeResult[0]);
    }

    public static boolean checkHasGetter(VariableElement field) {
        if (field == null || field.getKind() != ElementKind.FIELD || AptkCoreMatchers.BY_MODIFIER.getMatcher().checkForMatchingCharacteristic(field, Modifier.STATIC)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(field, ElementKind.CLASS);
        return BeanUtils.checkHasGetterMethod(field, typeElement);
    }

    public static boolean checkHasSetter(VariableElement field) {
        if (field == null || field.getKind() != ElementKind.FIELD) {
            return false;
        }
        TypeElement typeElement = (TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(field, ElementKind.CLASS);
        return BeanUtils.checkLombokSetterAnnotationOnType(typeElement) || BeanUtils.checkLombokSetterAnnotationOnField(field) || BeanUtils.checkHasSetterMethod(field, typeElement);
    }

    public static Optional<String> getGetterMethodName(VariableElement field) {
        if (field == null || field.getKind() != ElementKind.FIELD) {
            return Optional.empty();
        }
        TypeElement typeElement = (TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(field, ElementKind.CLASS);
        ExecutableElement getterMethod = BeanUtils.getGetterMethod(field, typeElement);
        if (getterMethod != null) {
            return Optional.of(getterMethod.getSimpleName().toString());
        }
        return Optional.empty();
    }

    public static Optional<String> getSetterMethodName(VariableElement field) {
        if (field == null || field.getKind() != ElementKind.FIELD) {
            return Optional.empty();
        }
        return BeanUtils.checkHasSetter(field) ? Optional.of(BeanUtils.getPrefixedName("set", field.getSimpleName().toString())) : Optional.empty();
    }

    static boolean checkHasGetterMethod(VariableElement field, TypeElement typeElement) {
        return BeanUtils.getGetterMethod(field, (TypeElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(field, ElementKind.CLASS)) != null;
    }

    static ExecutableElement getGetterMethod(VariableElement field, TypeElement typeElement) {
        List result = FluentElementFilter.createFluentElementFilter(typeElement.getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_METHOD).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByAllOf((Modifier[])new Modifier[]{Modifier.PUBLIC}).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByNoneOf((Modifier[])new Modifier[]{Modifier.ABSTRACT, Modifier.STATIC}).applyFilter(AptkCoreMatchers.BY_NAME).filterByOneOf((String[])BeanUtils.getPossibleGetterOrSetterNames(field, GETTER_PREFIXES)).applyFilter(AptkCoreMatchers.HAS_NO_PARAMETERS).applyFilter(AptkCoreMatchers.BY_RETURN_TYPE_MIRROR).filterByOneOf((TypeMirror[])new TypeMirror[]{field.asType()}).getResult();
        return result.size() >= 1 ? (ExecutableElement)result.get(0) : null;
    }

    static boolean checkHasSetterMethod(VariableElement field, TypeElement typeElement) {
        return BeanUtils.getSetterMethod(field, typeElement) != null;
    }

    static ExecutableElement getSetterMethod(VariableElement field, TypeElement typeElement) {
        TypeMirror[] parameters = new TypeMirror[]{field.asType()};
        List result = FluentElementFilter.createFluentElementFilter(typeElement.getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_METHOD).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByAllOf((Modifier[])new Modifier[]{Modifier.PUBLIC}).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByNoneOf((Modifier[])new Modifier[]{Modifier.ABSTRACT, Modifier.STATIC}).applyFilter(AptkCoreMatchers.BY_NAME).filterByOneOf((String[])BeanUtils.getPossibleGetterOrSetterNames(field, SETTER_PREFIXES)).applyFilter(AptkCoreMatchers.HAS_VOID_RETURN_TYPE).applyFilter(AptkCoreMatchers.BY_PARAMETER_TYPE_MIRROR).filterByOneOf((CRITERIA[])new TypeMirror[][]{parameters}).getResult();
        return result.size() >= 1 ? (ExecutableElement)result.get(0) : null;
    }

    static String[] getPossibleGetterOrSetterNames(VariableElement field, String[] prefixes) {
        String[] result = new String[prefixes.length];
        for (int i = 0; i < prefixes.length; ++i) {
            result[i] = BeanUtils.getPrefixedName(prefixes[i], field.getSimpleName().toString());
        }
        return result;
    }

    public static String getPrefixedName(String prefix, String name) {
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static boolean checkLombokSetterAnnotationOnType(TypeElement typeElement) {
        return AnnotationUtils.getAnnotationMirror((Element)typeElement, "lombok.Setter") != null;
    }

    public static boolean checkLombokSetterAnnotationOnField(VariableElement variableElement) {
        return AnnotationUtils.getAnnotationMirror((Element)variableElement, "lombok.Setter") != null;
    }

    public static class AttributeResult {
        private VariableElementWrapper field;
        private String setterMethodName;
        private String getterMethodName;

        public VariableElementWrapper getField() {
            return this.field;
        }

        public void setField(VariableElementWrapper field) {
            this.field = field;
        }

        public boolean hasGetter() {
            return this.getterMethodName != null;
        }

        public boolean hasSetter() {
            return this.setterMethodName != null;
        }

        public String getSetterMethodName() {
            return this.setterMethodName;
        }

        public void setSetterMethodName(String setterMethodName) {
            this.setterMethodName = setterMethodName;
        }

        public String getGetterMethodName() {
            return this.getterMethodName;
        }

        public void setGetterMethodName(String getterMethodName) {
            this.getterMethodName = getterMethodName;
        }

        public String getFieldName() {
            return this.field.getSimpleName();
        }

        public TypeMirrorWrapper getFieldTypeMirror() {
            return this.field.asType();
        }

        public boolean isValidAttribute() {
            return this.hasGetter() && this.hasSetter();
        }
    }
}

