/*
 * Decompiled with CFR 0.152.
 */
package org.jmockring.utils.dbunit;

import org.dbunit.database.IDatabaseConnection;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;

public enum DbUnitTuner {
    ORACLE{

        @Override
        public void tune(IDatabaseConnection connection) {
            try {
                connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Oracle10DataTypeFactory());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't configure Oracle DB connection", e);
            }
        }
    }
    ,
    H2{

        @Override
        public void tune(IDatabaseConnection connection) {
            try {
                connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new H2DataTypeFactory());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't configure H2 DB connection", e);
            }
        }
    }
    ,
    POSTGRES{

        @Override
        public void tune(IDatabaseConnection connection) {
            try {
                connection.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't configure PostgreSQL DB connection", e);
            }
        }
    };


    public abstract void tune(IDatabaseConnection var1);
}

