/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jline.builtins.Builtins;
import org.jline.builtins.Completers;
import org.jline.builtins.Options;
import org.jline.builtins.Widgets;
import org.jline.terminal.Terminal;

public interface CommandRegistry {
    public static Completers.SystemCompleter aggregateCompleters(CommandRegistry ... commandRegistries) {
        Completers.SystemCompleter out = new Completers.SystemCompleter();
        for (CommandRegistry r : commandRegistries) {
            out.add(r.compileCompleters());
        }
        return out;
    }

    public static Completers.SystemCompleter compileCompleters(CommandRegistry ... commandRegistries) {
        Completers.SystemCompleter out = CommandRegistry.aggregateCompleters(commandRegistries);
        out.compile();
        return out;
    }

    default public String name() {
        return this.getClass().getSimpleName();
    }

    public Set<String> commandNames();

    public Map<String, String> commandAliases();

    default public List<String> commandInfo(String command) {
        try {
            this.invoke(new CommandSession(), command, "--help");
        }
        catch (Options.HelpException e) {
            return Builtins.compileCommandInfo(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<String>();
    }

    public boolean hasCommand(String var1);

    public Completers.SystemCompleter compileCompleters();

    default public Widgets.CmdDesc commandDescription(String command) {
        try {
            this.invoke(new CommandSession(), command, "--help");
        }
        catch (Options.HelpException e) {
            return Builtins.compileCommandDescription(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    default public Object execute(CommandSession session, String command, String[] args) throws Exception {
        throw new IllegalArgumentException("CommandRegistry method execute(String command, String[] args) is not implemented!");
    }

    default public Object invoke(CommandSession session, String command, Object ... args) throws Exception {
        String[] _args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) {
                throw new IllegalArgumentException();
            }
            _args[i] = args[i].toString();
        }
        return this.execute(session, command, _args);
    }

    public static class CommandSession {
        private final Terminal terminal;
        private final InputStream in;
        private final PrintStream out;
        private final PrintStream err;

        public CommandSession() {
            this.in = System.in;
            this.out = System.out;
            this.err = System.err;
            this.terminal = null;
        }

        public CommandSession(Terminal terminal) {
            this(terminal, terminal.input(), new PrintStream(terminal.output()), new PrintStream(terminal.output()));
        }

        public CommandSession(Terminal terminal, InputStream in, PrintStream out, PrintStream err) {
            this.terminal = terminal;
            this.in = in;
            this.out = out;
            this.err = err;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }
    }
}

