/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jaws.entity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.jlab.jaws.entity.AlarmCategory;
import org.jlab.jaws.entity.AlarmLocation;
import org.jlab.jaws.entity.AlarmPriority;

@AvroGenerated
public class RegisteredClass
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -3281079886759129510L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"RegisteredClass\",\"namespace\":\"org.jlab.jaws.entity\",\"doc\":\"An alarm class\",\"fields\":[{\"name\":\"location\",\"type\":{\"type\":\"enum\",\"name\":\"AlarmLocation\",\"doc\":\"Enumeration of possible locations\",\"symbols\":[\"S1D\",\"S2D\",\"S3D\",\"S4D\",\"S5D\",\"L1\",\"L2\",\"L3\",\"L4\",\"L5\",\"L6\",\"L7\",\"L8\",\"L9\",\"LA\",\"LB\",\"A1\",\"A2\",\"A3\",\"A4\",\"A5\",\"A6\",\"A7\",\"A8\",\"A9\",\"AA\",\"BSY2\",\"BSY4\",\"BSY6\",\"BSY8\",\"BSYA\",\"BSYD\",\"INJ\",\"NL\",\"SL\",\"EA\",\"WA\",\"BSY\",\"HA\",\"HB\",\"HC\",\"HD\",\"ACC\",\"CHL\",\"MCC\",\"LERF\",\"UITF\"]},\"doc\":\"The alarm location\"},{\"name\":\"category\",\"type\":{\"type\":\"enum\",\"name\":\"AlarmCategory\",\"doc\":\"Enumeration of possible categories; useful for consumers to filter out alarms of interest\",\"symbols\":[\"Aperture\",\"BCM\",\"Box\",\"BPM\",\"CAMAC\",\"Crate\",\"Dump\",\"Gun\",\"Harp\",\"Helicity\",\"IC\",\"IOC\",\"Laser\",\"LCW\",\"Misc\",\"ODH\",\"RADCON\",\"RF\",\"Vacuum\"]},\"doc\":\"The alarm category\"},{\"name\":\"priority\",\"type\":{\"type\":\"enum\",\"name\":\"AlarmPriority\",\"doc\":\"Enumeration of possible priorities; useful for operators to know which alarms to handle first\",\"symbols\":[\"P1_CRITICAL\",\"P2_MAJOR\",\"P3_MINOR\",\"P4_INCIDENTAL\"]},\"doc\":\"The alarm priority\"},{\"name\":\"latching\",\"type\":\"boolean\",\"doc\":\"Indicates whether this alarm latches when activated and can only be cleared after an explicit acknowledgement\",\"default\":false},{\"name\":\"filterable\",\"type\":\"boolean\",\"doc\":\"Indicates whether this alarm can be filtered out of view (typically done when a portion of the machine is turned off).  Some alarms must always be monitored, regardless of program.\",\"default\":true},{\"name\":\"ondelayseconds\",\"type\":[\"null\",\"long\"],\"doc\":\"The number of seconds of on-delay\"},{\"name\":\"offdelayseconds\",\"type\":[\"null\",\"long\"],\"doc\":\"The number of seconds of off-delay\"},{\"name\":\"maskedby\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of the parent alarm, which if active, masks this alarm (flood suppression via logical hierarchy)\"},{\"name\":\"screenpath\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The path the alarm screen display\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<RegisteredClass> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<RegisteredClass> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private AlarmLocation location;
    private AlarmCategory category;
    private AlarmPriority priority;
    private boolean latching;
    private boolean filterable;
    private Long ondelayseconds;
    private Long offdelayseconds;
    private String maskedby;
    private String screenpath;
    private static final DatumWriter<RegisteredClass> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<RegisteredClass> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<RegisteredClass> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<RegisteredClass> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<RegisteredClass> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static RegisteredClass fromByteBuffer(ByteBuffer b) throws IOException {
        return (RegisteredClass)((Object)DECODER.decode(b));
    }

    public RegisteredClass() {
    }

    public RegisteredClass(AlarmLocation location, AlarmCategory category, AlarmPriority priority, Boolean latching, Boolean filterable, Long ondelayseconds, Long offdelayseconds, String maskedby, String screenpath) {
        this.location = location;
        this.category = category;
        this.priority = priority;
        this.latching = latching;
        this.filterable = filterable;
        this.ondelayseconds = ondelayseconds;
        this.offdelayseconds = offdelayseconds;
        this.maskedby = maskedby;
        this.screenpath = screenpath;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.location;
            }
            case 1: {
                return this.category;
            }
            case 2: {
                return this.priority;
            }
            case 3: {
                return this.latching;
            }
            case 4: {
                return this.filterable;
            }
            case 5: {
                return this.ondelayseconds;
            }
            case 6: {
                return this.offdelayseconds;
            }
            case 7: {
                return this.maskedby;
            }
            case 8: {
                return this.screenpath;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.location = (AlarmLocation)((Object)value$);
                break;
            }
            case 1: {
                this.category = (AlarmCategory)((Object)value$);
                break;
            }
            case 2: {
                this.priority = (AlarmPriority)((Object)value$);
                break;
            }
            case 3: {
                this.latching = (Boolean)value$;
                break;
            }
            case 4: {
                this.filterable = (Boolean)value$;
                break;
            }
            case 5: {
                this.ondelayseconds = (Long)value$;
                break;
            }
            case 6: {
                this.offdelayseconds = (Long)value$;
                break;
            }
            case 7: {
                this.maskedby = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.screenpath = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public AlarmLocation getLocation() {
        return this.location;
    }

    public void setLocation(AlarmLocation value) {
        this.location = value;
    }

    public AlarmCategory getCategory() {
        return this.category;
    }

    public void setCategory(AlarmCategory value) {
        this.category = value;
    }

    public AlarmPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AlarmPriority value) {
        this.priority = value;
    }

    public boolean getLatching() {
        return this.latching;
    }

    public void setLatching(boolean value) {
        this.latching = value;
    }

    public boolean getFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean value) {
        this.filterable = value;
    }

    public Long getOndelayseconds() {
        return this.ondelayseconds;
    }

    public void setOndelayseconds(Long value) {
        this.ondelayseconds = value;
    }

    public Long getOffdelayseconds() {
        return this.offdelayseconds;
    }

    public void setOffdelayseconds(Long value) {
        this.offdelayseconds = value;
    }

    public String getMaskedby() {
        return this.maskedby;
    }

    public void setMaskedby(String value) {
        this.maskedby = value;
    }

    public String getScreenpath() {
        return this.screenpath;
    }

    public void setScreenpath(String value) {
        this.screenpath = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(RegisteredClass other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeEnum(this.location.ordinal());
        out.writeEnum(this.category.ordinal());
        out.writeEnum(this.priority.ordinal());
        out.writeBoolean(this.latching);
        out.writeBoolean(this.filterable);
        if (this.ondelayseconds == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.ondelayseconds.longValue());
        }
        if (this.offdelayseconds == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.offdelayseconds.longValue());
        }
        if (this.maskedby == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.maskedby);
        }
        out.writeString(this.screenpath);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.location = AlarmLocation.values()[in.readEnum()];
            this.category = AlarmCategory.values()[in.readEnum()];
            this.priority = AlarmPriority.values()[in.readEnum()];
            this.latching = in.readBoolean();
            this.filterable = in.readBoolean();
            if (in.readIndex() != 1) {
                in.readNull();
                this.ondelayseconds = null;
            } else {
                this.ondelayseconds = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.offdelayseconds = null;
            } else {
                this.offdelayseconds = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maskedby = null;
            } else {
                this.maskedby = in.readString();
            }
            this.screenpath = in.readString();
        } else {
            block11: for (int i = 0; i < 9; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.location = AlarmLocation.values()[in.readEnum()];
                        continue block11;
                    }
                    case 1: {
                        this.category = AlarmCategory.values()[in.readEnum()];
                        continue block11;
                    }
                    case 2: {
                        this.priority = AlarmPriority.values()[in.readEnum()];
                        continue block11;
                    }
                    case 3: {
                        this.latching = in.readBoolean();
                        continue block11;
                    }
                    case 4: {
                        this.filterable = in.readBoolean();
                        continue block11;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.ondelayseconds = null;
                            continue block11;
                        }
                        this.ondelayseconds = in.readLong();
                        continue block11;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.offdelayseconds = null;
                            continue block11;
                        }
                        this.offdelayseconds = in.readLong();
                        continue block11;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maskedby = null;
                            continue block11;
                        }
                        this.maskedby = in.readString();
                        continue block11;
                    }
                    case 8: {
                        this.screenpath = in.readString();
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<RegisteredClass>
    implements RecordBuilder<RegisteredClass> {
        private AlarmLocation location;
        private AlarmCategory category;
        private AlarmPriority priority;
        private boolean latching;
        private boolean filterable;
        private Long ondelayseconds;
        private Long offdelayseconds;
        private String maskedby;
        private String screenpath;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.location))) {
                this.location = (AlarmLocation)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.location));
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.category))) {
                this.category = (AlarmCategory)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.category));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.priority))) {
                this.priority = (AlarmPriority)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.priority));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.latching)) {
                this.latching = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.latching);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.filterable)) {
                this.filterable = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.filterable);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.ondelayseconds)) {
                this.ondelayseconds = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.ondelayseconds);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.offdelayseconds)) {
                this.offdelayseconds = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.offdelayseconds);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.maskedby)) {
                this.maskedby = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.maskedby);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.screenpath)) {
                this.screenpath = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.screenpath);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(RegisteredClass other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.location))) {
                this.location = (AlarmLocation)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.location));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.category))) {
                this.category = (AlarmCategory)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.category));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.priority))) {
                this.priority = (AlarmPriority)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.priority));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.latching)) {
                this.latching = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.latching);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.filterable)) {
                this.filterable = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.filterable);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.ondelayseconds)) {
                this.ondelayseconds = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.ondelayseconds);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.offdelayseconds)) {
                this.offdelayseconds = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.offdelayseconds);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.maskedby)) {
                this.maskedby = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.maskedby);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.screenpath)) {
                this.screenpath = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.screenpath);
                this.fieldSetFlags()[8] = true;
            }
        }

        public AlarmLocation getLocation() {
            return this.location;
        }

        public Builder setLocation(AlarmLocation value) {
            this.validate(this.fields()[0], (Object)value);
            this.location = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasLocation() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearLocation() {
            this.location = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public AlarmCategory getCategory() {
            return this.category;
        }

        public Builder setCategory(AlarmCategory value) {
            this.validate(this.fields()[1], (Object)value);
            this.category = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasCategory() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearCategory() {
            this.category = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public AlarmPriority getPriority() {
            return this.priority;
        }

        public Builder setPriority(AlarmPriority value) {
            this.validate(this.fields()[2], (Object)value);
            this.priority = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasPriority() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearPriority() {
            this.priority = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getLatching() {
            return this.latching;
        }

        public Builder setLatching(boolean value) {
            this.validate(this.fields()[3], value);
            this.latching = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLatching() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearLatching() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public boolean getFilterable() {
            return this.filterable;
        }

        public Builder setFilterable(boolean value) {
            this.validate(this.fields()[4], value);
            this.filterable = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFilterable() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFilterable() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getOndelayseconds() {
            return this.ondelayseconds;
        }

        public Builder setOndelayseconds(Long value) {
            this.validate(this.fields()[5], value);
            this.ondelayseconds = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasOndelayseconds() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearOndelayseconds() {
            this.ondelayseconds = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Long getOffdelayseconds() {
            return this.offdelayseconds;
        }

        public Builder setOffdelayseconds(Long value) {
            this.validate(this.fields()[6], value);
            this.offdelayseconds = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasOffdelayseconds() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearOffdelayseconds() {
            this.offdelayseconds = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getMaskedby() {
            return this.maskedby;
        }

        public Builder setMaskedby(String value) {
            this.validate(this.fields()[7], value);
            this.maskedby = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasMaskedby() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearMaskedby() {
            this.maskedby = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getScreenpath() {
            return this.screenpath;
        }

        public Builder setScreenpath(String value) {
            this.validate(this.fields()[8], value);
            this.screenpath = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasScreenpath() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearScreenpath() {
            this.screenpath = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public RegisteredClass build() {
            try {
                RegisteredClass record = new RegisteredClass();
                record.location = this.fieldSetFlags()[0] ? this.location : (AlarmLocation)((Object)this.defaultValue(this.fields()[0]));
                record.category = this.fieldSetFlags()[1] ? this.category : (AlarmCategory)((Object)this.defaultValue(this.fields()[1]));
                record.priority = this.fieldSetFlags()[2] ? this.priority : (AlarmPriority)((Object)this.defaultValue(this.fields()[2]));
                record.latching = this.fieldSetFlags()[3] ? this.latching : (Boolean)this.defaultValue(this.fields()[3]);
                record.filterable = this.fieldSetFlags()[4] ? this.filterable : (Boolean)this.defaultValue(this.fields()[4]);
                record.ondelayseconds = this.fieldSetFlags()[5] ? this.ondelayseconds : (Long)this.defaultValue(this.fields()[5]);
                record.offdelayseconds = this.fieldSetFlags()[6] ? this.offdelayseconds : (Long)this.defaultValue(this.fields()[6]);
                record.maskedby = this.fieldSetFlags()[7] ? this.maskedby : (String)this.defaultValue(this.fields()[7]);
                record.screenpath = this.fieldSetFlags()[8] ? this.screenpath : (String)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

