/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.jaws.entity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.jlab.jaws.entity.AlarmCategory;
import org.jlab.jaws.entity.AlarmClass;
import org.jlab.jaws.entity.AlarmLocation;
import org.jlab.jaws.entity.AlarmPriority;

@AvroGenerated
public class RegisteredAlarm
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6365010776730214930L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"RegisteredAlarm\",\"namespace\":\"org.jlab.jaws.entity\",\"doc\":\"Master alarm database record\",\"fields\":[{\"name\":\"class\",\"type\":{\"type\":\"enum\",\"name\":\"AlarmClass\",\"doc\":\"Enumeration of possible classes, a class provides inheritable (shared) values for registration fields.  The Base_Class provides the system defaults, otherwise it would be possible to have null values in required fields\",\"symbols\":[\"Base_Class\",\"BCM_Temperature\",\"Trim_Temperature\",\"Shunt_Temperature\",\"CAMAC_Temperature\",\"CAMAC_Voltage\",\"MPS_Voltage_Mismatch\",\"MPS_Voltage_Fault\",\"MPS_Setpoint_Invalid\",\"Magnet_Mismatch\",\"Magnet_Communication_Error\",\"Vacuum_Level\",\"LCW_Supply_Pressure\"]},\"doc\":\"The alarm class; provides inheritable shared field values, fields are only overridden if null, the producer field is required and cannot be overridden\",\"default\":\"Base_Class\"},{\"name\":\"producer\",\"type\":[{\"type\":\"record\",\"name\":\"SimpleProducer\",\"doc\":\"Alarm producer which has no specific source\",\"fields\":[]},{\"type\":\"record\",\"name\":\"EPICSProducer\",\"doc\":\"Alarm producer which sources alarms from EPICS\",\"fields\":[{\"name\":\"pv\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the EPICS CA PV, which can be correlated with the key of the epics-channels topic\"}]},{\"type\":\"record\",\"name\":\"CALCProducer\",\"doc\":\"Alarm producer which uses CALC-like expressions\",\"fields\":[{\"name\":\"expression\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The CALC expression used to generate alarms\"}]}],\"doc\":\"Indicates how this alarm is produced, useful for producers to monitor when new alarms are added/removed\"},{\"name\":\"location\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"AlarmLocation\",\"doc\":\"Enumeration of possible locations\",\"symbols\":[\"S1D\",\"S2D\",\"S3D\",\"S4D\",\"S5D\",\"L1\",\"L2\",\"L3\",\"L4\",\"L5\",\"L6\",\"L7\",\"L8\",\"L9\",\"LA\",\"LB\",\"A1\",\"A2\",\"A3\",\"A4\",\"A5\",\"A6\",\"A7\",\"A8\",\"A9\",\"AA\",\"BSY2\",\"BSY4\",\"BSY6\",\"BSY8\",\"BSYA\",\"BSYD\",\"INJ\",\"NL\",\"SL\",\"EA\",\"WA\",\"BSY\",\"HA\",\"HB\",\"HC\",\"HD\",\"ACC\",\"CHL\",\"MCC\",\"LERF\",\"UITF\"]}],\"doc\":\"The alarm location\"},{\"name\":\"category\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"AlarmCategory\",\"doc\":\"Enumeration of possible categories; useful for consumers to filter out alarms of interest\",\"symbols\":[\"Aperture\",\"BCM\",\"Box\",\"BPM\",\"CAMAC\",\"Crate\",\"Dump\",\"Gun\",\"Harp\",\"Helicity\",\"IC\",\"IOC\",\"Laser\",\"LCW\",\"Misc\",\"ODH\",\"RADCON\",\"RF\",\"Vacuum\"]}],\"doc\":\"The alarm category\"},{\"name\":\"priority\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"AlarmPriority\",\"doc\":\"Enumeration of possible priorities; useful for operators to know which alarms to handle first\",\"symbols\":[\"P1_CRITICAL\",\"P2_MAJOR\",\"P3_MINOR\",\"P4_INCIDENTAL\"]}],\"doc\":\"The alarm priority\"},{\"name\":\"rationale\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Markdown formatted text describing the reason this alarm is necessary\"},{\"name\":\"correctiveaction\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Markdown formatted text describing the corrective action to take when the alarm becomes active\"},{\"name\":\"pointofcontactusername\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Username (identifier) of point of contact.  Full contact info should be obtained from user database (LDAP for example)\"},{\"name\":\"latching\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Indicates whether this alarm latches when activated and can only be cleared after an explicit acknowledgement\"},{\"name\":\"filterable\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Indicates whether this alarm can be filtered out of view (typically done when a portion of the machine is turned off).  Some alarms must always be monitored, regardless of program.\"},{\"name\":\"ondelayseconds\",\"type\":[\"null\",\"long\"],\"doc\":\"The number of seconds of on-delay\"},{\"name\":\"offdelayseconds\",\"type\":[\"null\",\"long\"],\"doc\":\"The number of seconds of off-delay\"},{\"name\":\"maskedby\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of the parent alarm, which if active, masks this alarm (flood suppression via logical hierarchy)\"},{\"name\":\"screenpath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The path the alarm screen display\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<RegisteredAlarm> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<RegisteredAlarm> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private AlarmClass class$;
    private Object producer;
    private AlarmLocation location;
    private AlarmCategory category;
    private AlarmPriority priority;
    private String rationale;
    private String correctiveaction;
    private String pointofcontactusername;
    private Boolean latching;
    private Boolean filterable;
    private Long ondelayseconds;
    private Long offdelayseconds;
    private String maskedby;
    private String screenpath;
    private static final DatumWriter<RegisteredAlarm> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<RegisteredAlarm> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<RegisteredAlarm> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<RegisteredAlarm> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<RegisteredAlarm> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static RegisteredAlarm fromByteBuffer(ByteBuffer b) throws IOException {
        return (RegisteredAlarm)((Object)DECODER.decode(b));
    }

    public RegisteredAlarm() {
    }

    public RegisteredAlarm(AlarmClass class$, Object producer, AlarmLocation location, AlarmCategory category, AlarmPriority priority, String rationale, String correctiveaction, String pointofcontactusername, Boolean latching, Boolean filterable, Long ondelayseconds, Long offdelayseconds, String maskedby, String screenpath) {
        this.class$ = class$;
        this.producer = producer;
        this.location = location;
        this.category = category;
        this.priority = priority;
        this.rationale = rationale;
        this.correctiveaction = correctiveaction;
        this.pointofcontactusername = pointofcontactusername;
        this.latching = latching;
        this.filterable = filterable;
        this.ondelayseconds = ondelayseconds;
        this.offdelayseconds = offdelayseconds;
        this.maskedby = maskedby;
        this.screenpath = screenpath;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.class$;
            }
            case 1: {
                return this.producer;
            }
            case 2: {
                return this.location;
            }
            case 3: {
                return this.category;
            }
            case 4: {
                return this.priority;
            }
            case 5: {
                return this.rationale;
            }
            case 6: {
                return this.correctiveaction;
            }
            case 7: {
                return this.pointofcontactusername;
            }
            case 8: {
                return this.latching;
            }
            case 9: {
                return this.filterable;
            }
            case 10: {
                return this.ondelayseconds;
            }
            case 11: {
                return this.offdelayseconds;
            }
            case 12: {
                return this.maskedby;
            }
            case 13: {
                return this.screenpath;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.class$ = (AlarmClass)((Object)value$);
                break;
            }
            case 1: {
                this.producer = value$;
                break;
            }
            case 2: {
                this.location = (AlarmLocation)((Object)value$);
                break;
            }
            case 3: {
                this.category = (AlarmCategory)((Object)value$);
                break;
            }
            case 4: {
                this.priority = (AlarmPriority)((Object)value$);
                break;
            }
            case 5: {
                this.rationale = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.correctiveaction = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.pointofcontactusername = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.latching = (Boolean)value$;
                break;
            }
            case 9: {
                this.filterable = (Boolean)value$;
                break;
            }
            case 10: {
                this.ondelayseconds = (Long)value$;
                break;
            }
            case 11: {
                this.offdelayseconds = (Long)value$;
                break;
            }
            case 12: {
                this.maskedby = value$ != null ? value$.toString() : null;
                break;
            }
            case 13: {
                this.screenpath = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public AlarmClass getClass$() {
        return this.class$;
    }

    public void setClass$(AlarmClass value) {
        this.class$ = value;
    }

    public Object getProducer() {
        return this.producer;
    }

    public void setProducer(Object value) {
        this.producer = value;
    }

    public AlarmLocation getLocation() {
        return this.location;
    }

    public void setLocation(AlarmLocation value) {
        this.location = value;
    }

    public AlarmCategory getCategory() {
        return this.category;
    }

    public void setCategory(AlarmCategory value) {
        this.category = value;
    }

    public AlarmPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AlarmPriority value) {
        this.priority = value;
    }

    public String getRationale() {
        return this.rationale;
    }

    public void setRationale(String value) {
        this.rationale = value;
    }

    public String getCorrectiveaction() {
        return this.correctiveaction;
    }

    public void setCorrectiveaction(String value) {
        this.correctiveaction = value;
    }

    public String getPointofcontactusername() {
        return this.pointofcontactusername;
    }

    public void setPointofcontactusername(String value) {
        this.pointofcontactusername = value;
    }

    public Boolean getLatching() {
        return this.latching;
    }

    public void setLatching(Boolean value) {
        this.latching = value;
    }

    public Boolean getFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean value) {
        this.filterable = value;
    }

    public Long getOndelayseconds() {
        return this.ondelayseconds;
    }

    public void setOndelayseconds(Long value) {
        this.ondelayseconds = value;
    }

    public Long getOffdelayseconds() {
        return this.offdelayseconds;
    }

    public void setOffdelayseconds(Long value) {
        this.offdelayseconds = value;
    }

    public String getMaskedby() {
        return this.maskedby;
    }

    public void setMaskedby(String value) {
        this.maskedby = value;
    }

    public String getScreenpath() {
        return this.screenpath;
    }

    public void setScreenpath(String value) {
        this.screenpath = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(RegisteredAlarm other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<RegisteredAlarm>
    implements RecordBuilder<RegisteredAlarm> {
        private AlarmClass class$;
        private Object producer;
        private AlarmLocation location;
        private AlarmCategory category;
        private AlarmPriority priority;
        private String rationale;
        private String correctiveaction;
        private String pointofcontactusername;
        private Boolean latching;
        private Boolean filterable;
        private Long ondelayseconds;
        private Long offdelayseconds;
        private String maskedby;
        private String screenpath;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.class$))) {
                this.class$ = (AlarmClass)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.class$));
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.producer)) {
                this.producer = this.data().deepCopy(this.fields()[1].schema(), other.producer);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.location))) {
                this.location = (AlarmLocation)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.location));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.category))) {
                this.category = (AlarmCategory)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.category));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.priority))) {
                this.priority = (AlarmPriority)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.priority));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.rationale)) {
                this.rationale = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.rationale);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.correctiveaction)) {
                this.correctiveaction = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.correctiveaction);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.pointofcontactusername)) {
                this.pointofcontactusername = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.pointofcontactusername);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.latching)) {
                this.latching = (Boolean)this.data().deepCopy(this.fields()[8].schema(), (Object)other.latching);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.filterable)) {
                this.filterable = (Boolean)this.data().deepCopy(this.fields()[9].schema(), (Object)other.filterable);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.ondelayseconds)) {
                this.ondelayseconds = (Long)this.data().deepCopy(this.fields()[10].schema(), (Object)other.ondelayseconds);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.offdelayseconds)) {
                this.offdelayseconds = (Long)this.data().deepCopy(this.fields()[11].schema(), (Object)other.offdelayseconds);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.maskedby)) {
                this.maskedby = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.maskedby);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.screenpath)) {
                this.screenpath = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.screenpath);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
        }

        private Builder(RegisteredAlarm other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.class$))) {
                this.class$ = (AlarmClass)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.class$));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.producer)) {
                this.producer = this.data().deepCopy(this.fields()[1].schema(), other.producer);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.location))) {
                this.location = (AlarmLocation)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.location));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.category))) {
                this.category = (AlarmCategory)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.category));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.priority))) {
                this.priority = (AlarmPriority)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.priority));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.rationale)) {
                this.rationale = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.rationale);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.correctiveaction)) {
                this.correctiveaction = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.correctiveaction);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.pointofcontactusername)) {
                this.pointofcontactusername = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.pointofcontactusername);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.latching)) {
                this.latching = (Boolean)this.data().deepCopy(this.fields()[8].schema(), (Object)other.latching);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.filterable)) {
                this.filterable = (Boolean)this.data().deepCopy(this.fields()[9].schema(), (Object)other.filterable);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.ondelayseconds)) {
                this.ondelayseconds = (Long)this.data().deepCopy(this.fields()[10].schema(), (Object)other.ondelayseconds);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.offdelayseconds)) {
                this.offdelayseconds = (Long)this.data().deepCopy(this.fields()[11].schema(), (Object)other.offdelayseconds);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.maskedby)) {
                this.maskedby = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.maskedby);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.screenpath)) {
                this.screenpath = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.screenpath);
                this.fieldSetFlags()[13] = true;
            }
        }

        public AlarmClass getClass$() {
            return this.class$;
        }

        public Builder setClass$(AlarmClass value) {
            this.validate(this.fields()[0], (Object)value);
            this.class$ = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasClass$() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearClass$() {
            this.class$ = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Object getProducer() {
            return this.producer;
        }

        public Builder setProducer(Object value) {
            this.validate(this.fields()[1], value);
            this.producer = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasProducer() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearProducer() {
            this.producer = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public AlarmLocation getLocation() {
            return this.location;
        }

        public Builder setLocation(AlarmLocation value) {
            this.validate(this.fields()[2], (Object)value);
            this.location = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasLocation() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearLocation() {
            this.location = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public AlarmCategory getCategory() {
            return this.category;
        }

        public Builder setCategory(AlarmCategory value) {
            this.validate(this.fields()[3], (Object)value);
            this.category = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCategory() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCategory() {
            this.category = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public AlarmPriority getPriority() {
            return this.priority;
        }

        public Builder setPriority(AlarmPriority value) {
            this.validate(this.fields()[4], (Object)value);
            this.priority = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasPriority() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearPriority() {
            this.priority = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getRationale() {
            return this.rationale;
        }

        public Builder setRationale(String value) {
            this.validate(this.fields()[5], value);
            this.rationale = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasRationale() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearRationale() {
            this.rationale = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getCorrectiveaction() {
            return this.correctiveaction;
        }

        public Builder setCorrectiveaction(String value) {
            this.validate(this.fields()[6], value);
            this.correctiveaction = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasCorrectiveaction() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearCorrectiveaction() {
            this.correctiveaction = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getPointofcontactusername() {
            return this.pointofcontactusername;
        }

        public Builder setPointofcontactusername(String value) {
            this.validate(this.fields()[7], value);
            this.pointofcontactusername = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasPointofcontactusername() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearPointofcontactusername() {
            this.pointofcontactusername = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Boolean getLatching() {
            return this.latching;
        }

        public Builder setLatching(Boolean value) {
            this.validate(this.fields()[8], value);
            this.latching = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasLatching() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearLatching() {
            this.latching = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Boolean getFilterable() {
            return this.filterable;
        }

        public Builder setFilterable(Boolean value) {
            this.validate(this.fields()[9], value);
            this.filterable = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasFilterable() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearFilterable() {
            this.filterable = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Long getOndelayseconds() {
            return this.ondelayseconds;
        }

        public Builder setOndelayseconds(Long value) {
            this.validate(this.fields()[10], value);
            this.ondelayseconds = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasOndelayseconds() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearOndelayseconds() {
            this.ondelayseconds = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Long getOffdelayseconds() {
            return this.offdelayseconds;
        }

        public Builder setOffdelayseconds(Long value) {
            this.validate(this.fields()[11], value);
            this.offdelayseconds = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasOffdelayseconds() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearOffdelayseconds() {
            this.offdelayseconds = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public String getMaskedby() {
            return this.maskedby;
        }

        public Builder setMaskedby(String value) {
            this.validate(this.fields()[12], value);
            this.maskedby = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasMaskedby() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearMaskedby() {
            this.maskedby = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public String getScreenpath() {
            return this.screenpath;
        }

        public Builder setScreenpath(String value) {
            this.validate(this.fields()[13], value);
            this.screenpath = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasScreenpath() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearScreenpath() {
            this.screenpath = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public RegisteredAlarm build() {
            try {
                RegisteredAlarm record = new RegisteredAlarm();
                record.class$ = this.fieldSetFlags()[0] ? this.class$ : (AlarmClass)((Object)this.defaultValue(this.fields()[0]));
                record.producer = this.fieldSetFlags()[1] ? this.producer : this.defaultValue(this.fields()[1]);
                record.location = this.fieldSetFlags()[2] ? this.location : (AlarmLocation)((Object)this.defaultValue(this.fields()[2]));
                record.category = this.fieldSetFlags()[3] ? this.category : (AlarmCategory)((Object)this.defaultValue(this.fields()[3]));
                record.priority = this.fieldSetFlags()[4] ? this.priority : (AlarmPriority)((Object)this.defaultValue(this.fields()[4]));
                record.rationale = this.fieldSetFlags()[5] ? this.rationale : (String)this.defaultValue(this.fields()[5]);
                record.correctiveaction = this.fieldSetFlags()[6] ? this.correctiveaction : (String)this.defaultValue(this.fields()[6]);
                record.pointofcontactusername = this.fieldSetFlags()[7] ? this.pointofcontactusername : (String)this.defaultValue(this.fields()[7]);
                record.latching = this.fieldSetFlags()[8] ? this.latching : (Boolean)this.defaultValue(this.fields()[8]);
                record.filterable = this.fieldSetFlags()[9] ? this.filterable : (Boolean)this.defaultValue(this.fields()[9]);
                record.ondelayseconds = this.fieldSetFlags()[10] ? this.ondelayseconds : (Long)this.defaultValue(this.fields()[10]);
                record.offdelayseconds = this.fieldSetFlags()[11] ? this.offdelayseconds : (Long)this.defaultValue(this.fields()[11]);
                record.maskedby = this.fieldSetFlags()[12] ? this.maskedby : (String)this.defaultValue(this.fields()[12]);
                record.screenpath = this.fieldSetFlags()[13] ? this.screenpath : (String)this.defaultValue(this.fields()[13]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

