/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0017B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0007H\u0002J\u0006\u0010\u0014\u001a\u00020\u0007J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u000e\u0012\f0\fR\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f0\fR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;", "T", "", "windowSize", "Ljava/time/Duration;", "evictionHandler", "Lkotlin/Function1;", "", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function1;Ljava/time/Clock;)V", "evictionPredicate", "Lorg/jitsi/utils/stats/TimeBasedSlidingWindow$TimeEntry;", "", "queue", "Ljava/util/ArrayDeque;", "add", "value", "(Ljava/lang/Object;)V", "evict", "forceEviction", "values", "", "TimeEntry", "jitsi-utils"})
public class TimeBasedSlidingWindow<T> {
    private final ArrayDeque<TimeEntry> queue;
    private final Function1<TimeEntry, Boolean> evictionPredicate;
    private final Duration windowSize;
    private final Function1<T, Unit> evictionHandler;
    private final Clock clock;

    public final void add(@NotNull T value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.queue.addFirst(new TimeEntry(this, value));
        this.evict();
    }

    public final void forceEviction() {
        this.evict();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<T> values() {
        void $this$mapTo$iv$iv;
        this.evict();
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)this.queue);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimeEntry timeEntry = (TimeEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.getValue();
            collection.add(t);
        }
        return (List)destination$iv$iv;
    }

    private final void evict() {
        while (true) {
            Collection collection = this.queue;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            TimeEntry timeEntry = this.queue.getLast();
            Intrinsics.checkExpressionValueIsNotNull((Object)timeEntry, (String)"queue.last");
            if (!((Boolean)this.evictionPredicate.invoke((Object)timeEntry)).booleanValue()) break;
            this.evictionHandler.invoke(this.queue.getLast().getValue());
            this.queue.removeLast();
        }
    }

    public TimeBasedSlidingWindow(@NotNull Duration windowSize, @NotNull Function1<? super T, Unit> evictionHandler, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)windowSize, (String)"windowSize");
        Intrinsics.checkParameterIsNotNull(evictionHandler, (String)"evictionHandler");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.windowSize = windowSize;
        this.evictionHandler = evictionHandler;
        this.clock = clock;
        this.queue = new ArrayDeque();
        this.evictionPredicate = (Function1)new Function1<TimeEntry, Boolean>(this){
            final /* synthetic */ TimeBasedSlidingWindow this$0;

            public final boolean invoke(@NotNull TimeEntry entry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                return Duration.between(entry.getInsertionTime(), TimeBasedSlidingWindow.access$getClock$p(this.this$0).instant()).compareTo(TimeBasedSlidingWindow.access$getWindowSize$p(this.this$0)) > 0;
            }
            {
                this.this$0 = timeBasedSlidingWindow;
                super(1);
            }
        };
    }

    public /* synthetic */ TimeBasedSlidingWindow(Duration duration, Function1 function1, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        this(duration, function1, clock);
    }

    public static final /* synthetic */ Duration access$getWindowSize$p(TimeBasedSlidingWindow $this) {
        return $this.windowSize;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jitsi/utils/stats/TimeBasedSlidingWindow$TimeEntry;", "", "value", "(Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;Ljava/lang/Object;)V", "insertionTime", "Ljava/time/Instant;", "(Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;Ljava/lang/Object;Ljava/time/Instant;)V", "getInsertionTime", "()Ljava/time/Instant;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "jitsi-utils"})
    public final class TimeEntry {
        @NotNull
        private final T value;
        @NotNull
        private final Instant insertionTime;
        final /* synthetic */ TimeBasedSlidingWindow this$0;

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getInsertionTime() {
            return this.insertionTime;
        }

        public TimeEntry(@NotNull TimeBasedSlidingWindow $outer, @NotNull T value, Instant insertionTime) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)insertionTime, (String)"insertionTime");
            this.this$0 = $outer;
            this.value = value;
            this.insertionTime = insertionTime;
        }

        public TimeEntry(@NotNull TimeBasedSlidingWindow $outer, T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Instant instant = $outer.clock.instant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"clock.instant()");
            this($outer, value, instant);
        }
    }
}

