/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate3;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.Scanner;
import org.jboss.as.jpa.hibernate3.HibernatePatternFilter;
import org.jboss.as.jpa.hibernate3.HibernateVirtualFileNamedInputStream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jipijapa.core.JpaLogger;
import org.jipijapa.core.JpaMessages;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateAnnotationScanner
implements Scanner {
    private static final ThreadLocal<PersistenceUnitMetadata> persistenceUnitMetadataTLS = new ThreadLocal();
    private static final Map<PersistenceUnitMetadata, Map<URL, Set<Package>>> PACKAGES_IN_JAR_CACHE = new HashMap<PersistenceUnitMetadata, Map<URL, Set<Package>>>();
    private static final Map<PersistenceUnitMetadata, Map<URL, Map<Class<? extends Annotation>, Set<Class<?>>>>> CLASSES_IN_JAR_CACHE = new HashMap();

    public static void setThreadLocalPersistenceUnitMetadata(PersistenceUnitMetadata pu) {
        persistenceUnitMetadataTLS.set(pu);
    }

    public static void clearThreadLocalPersistenceUnitMetadata() {
        persistenceUnitMetadataTLS.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cachePackages(PersistenceUnitMetadata pu, URL jarToScan, Set<Package> packages) {
        Map<PersistenceUnitMetadata, Map<URL, Set<Package>>> map = PACKAGES_IN_JAR_CACHE;
        synchronized (map) {
            Map<URL, Set<Package>> packagesByUrl = PACKAGES_IN_JAR_CACHE.get(pu);
            if (packagesByUrl == null) {
                packagesByUrl = new HashMap<URL, Set<Package>>();
                PACKAGES_IN_JAR_CACHE.put(pu, packagesByUrl);
            }
            packagesByUrl.put(jarToScan, packages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Package> getCachedPackages(PersistenceUnitMetadata pu, URL jarToScan) {
        Map<PersistenceUnitMetadata, Map<URL, Set<Package>>> map = PACKAGES_IN_JAR_CACHE;
        synchronized (map) {
            Map<URL, Set<Package>> packagesByUrl = PACKAGES_IN_JAR_CACHE.get(pu);
            if (packagesByUrl == null) {
                return Collections.emptySet();
            }
            Set<Package> packages = packagesByUrl.get(jarToScan);
            if (packages == null) {
                return Collections.emptySet();
            }
            return packages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheClasses(PersistenceUnitMetadata pu, URL jarToScan, Class<? extends Annotation> annotation, Set<Class<?>> classes) {
        Map<PersistenceUnitMetadata, Map<URL, Map<Class<? extends Annotation>, Set<Class<?>>>>> map = CLASSES_IN_JAR_CACHE;
        synchronized (map) {
            Map<Class<Annotation>, Set<Class<?>>> classesByAnnotation;
            Map<URL, Map<Class<Annotation>, Set<Class<?>>>> classesByURL = CLASSES_IN_JAR_CACHE.get(pu);
            if (classesByURL == null) {
                classesByURL = new HashMap();
                CLASSES_IN_JAR_CACHE.put(pu, classesByURL);
            }
            if ((classesByAnnotation = classesByURL.get(jarToScan)) == null) {
                classesByAnnotation = new HashMap();
                classesByURL.put(jarToScan, classesByAnnotation);
            }
            classesByAnnotation.put(annotation, classes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Class<?>> getCachedClasses(PersistenceUnitMetadata pu, URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        Map<PersistenceUnitMetadata, Map<URL, Map<Class<? extends Annotation>, Set<Class<?>>>>> map = CLASSES_IN_JAR_CACHE;
        synchronized (map) {
            Map<URL, Map<Class<Annotation>, Set<Class<?>>>> classesByURL = CLASSES_IN_JAR_CACHE.get(pu);
            if (classesByURL == null) {
                return Collections.emptySet();
            }
            Map<Class<Annotation>, Set<Class<?>>> classesByAnnotation = classesByURL.get(jartoScan);
            if (classesByAnnotation == null) {
                return Collections.emptySet();
            }
            HashSet classes = new HashSet();
            for (Class<? extends Annotation> ann : annotationsToLookFor) {
                Set<Class<?>> classesForAnnotation = classesByAnnotation.get(ann);
                if (classesForAnnotation == null) continue;
                classes.addAll(classesForAnnotation);
            }
            return classes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanup(PersistenceUnitMetadata pu) {
        Map<PersistenceUnitMetadata, Map<URL, Object>> map = CLASSES_IN_JAR_CACHE;
        synchronized (map) {
            CLASSES_IN_JAR_CACHE.remove(pu);
        }
        map = PACKAGES_IN_JAR_CACHE;
        synchronized (map) {
            PACKAGES_IN_JAR_CACHE.remove(pu);
        }
    }

    public Set<Package> getPackagesInJar(URL jarToScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        if (jarToScan == null) {
            throw JpaMessages.MESSAGES.nullVar("jarToScan");
        }
        JpaLogger.JPA_LOGGER.tracef("getPackagesInJar url=%s annotations=%s", (Object)jarToScan.getPath(), annotationsToLookFor);
        Set<Object> resultClasses = new HashSet();
        PersistenceUnitMetadata pu = persistenceUnitMetadataTLS.get();
        if (pu == null) {
            throw JpaMessages.MESSAGES.missingPersistenceUnitMetadata();
        }
        if (annotationsToLookFor.size() > 0) {
            resultClasses = this.getClassesInJar(jarToScan, annotationsToLookFor);
        } else if (pu.getAnnotationIndex() != null) {
            Index index = this.getJarFileIndex(jarToScan, pu);
            if (index == null) {
                JpaLogger.JPA_LOGGER.tracef("No classes to scan for annotations in jar '%s' (jars with classes '%s')", (Object)jarToScan, pu.getAnnotationIndex().keySet());
                return new HashSet<Package>();
            }
            Collection allClasses = index.getKnownClasses();
            for (ClassInfo classInfo : allClasses) {
                String className = classInfo.name().toString();
                try {
                    resultClasses.add(pu.getClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    JpaLogger.JPA_LOGGER.cannotLoadEntityClass((Throwable)e, className);
                }
                catch (NoClassDefFoundError e) {
                    JpaLogger.JPA_LOGGER.cannotLoadEntityClass((Throwable)e, className);
                }
            }
        }
        if (pu.getAnnotationIndex() != null || annotationsToLookFor.size() > 0) {
            HashMap<String, Package> uniquePackages = new HashMap<String, Package>();
            for (Class clazz : resultClasses) {
                Package classPackage = clazz.getPackage();
                if (classPackage == null) continue;
                JpaLogger.JPA_LOGGER.tracef("getPackagesInJar found package %s", (Object)classPackage);
                uniquePackages.put(classPackage.getName(), classPackage);
            }
            HashSet<Package> packages = new HashSet<Package>(uniquePackages.values());
            HibernateAnnotationScanner.cachePackages(pu, jarToScan, packages);
            return new HashSet<Package>(packages);
        }
        return HibernateAnnotationScanner.getCachedPackages(pu, jarToScan);
    }

    private Index getJarFileIndex(URL jartoScan, PersistenceUnitMetadata pu) {
        return (Index)pu.getAnnotationIndex().get(jartoScan);
    }

    public Set<Class<?>> getClassesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        if (jartoScan == null) {
            throw JpaMessages.MESSAGES.nullVar("jartoScan");
        }
        JpaLogger.JPA_LOGGER.tracef("getClassesInJar url=%s annotations=%s", (Object)jartoScan.getPath(), annotationsToLookFor);
        PersistenceUnitMetadata pu = persistenceUnitMetadataTLS.get();
        if (pu == null) {
            throw JpaMessages.MESSAGES.missingPersistenceUnitMetadata();
        }
        if (pu.getAnnotationIndex() != null) {
            Index index = this.getJarFileIndex(jartoScan, pu);
            if (index == null) {
                JpaLogger.JPA_LOGGER.tracef("No classes to scan for annotations in jar '%s' (jars with classes '%s')", (Object)jartoScan, pu.getAnnotationIndex().keySet());
                return new HashSet();
            }
            if (annotationsToLookFor == null) {
                throw JpaMessages.MESSAGES.nullVar("annotationsToLookFor");
            }
            if (annotationsToLookFor.size() == 0) {
                throw JpaMessages.MESSAGES.emptyParameter("annotationsToLookFor");
            }
            HashSet result = new HashSet();
            for (Class<? extends Annotation> annClass : annotationsToLookFor) {
                DotName annotation = DotName.createSimple((String)annClass.getName());
                List classesWithAnnotation = index.getAnnotations(annotation);
                HashSet classesForAnnotation = new HashSet();
                for (AnnotationInstance annotationInstance : classesWithAnnotation) {
                    if (!(annotationInstance.target() instanceof ClassInfo)) continue;
                    String className = annotationInstance.target().toString();
                    try {
                        JpaLogger.JPA_LOGGER.tracef("getClassesInJar found class %s with annotation %s", (Object)className, (Object)annClass.getName());
                        Class<?> clazz = pu.getClassLoader().loadClass(className);
                        result.add(clazz);
                        classesForAnnotation.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        JpaLogger.JPA_LOGGER.cannotLoadEntityClass((Throwable)e, className);
                    }
                    catch (NoClassDefFoundError e) {
                        JpaLogger.JPA_LOGGER.cannotLoadEntityClass((Throwable)e, className);
                    }
                }
                HibernateAnnotationScanner.cacheClasses(pu, jartoScan, annClass, classesForAnnotation);
            }
            return result;
        }
        return HibernateAnnotationScanner.getCachedClasses(pu, jartoScan, annotationsToLookFor);
    }

    public Set<NamedInputStream> getFilesInJar(URL jartoScan, Set<String> filePatterns) {
        if (jartoScan == null) {
            throw JpaMessages.MESSAGES.nullVar("jartoScann");
        }
        if (filePatterns == null) {
            throw JpaMessages.MESSAGES.nullVar("filePatterns");
        }
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        HashMap<String, Set<NamedInputStream>> map = new HashMap<String, Set<NamedInputStream>>();
        this.findFiles(jartoScan, filePatterns, map, result);
        return result;
    }

    private void findFiles(URL jartoScan, Set<String> filePatterns, Map<String, Set<NamedInputStream>> map, Set<NamedInputStream> result) {
        if (filePatterns.isEmpty()) {
            for (Set<NamedInputStream> nims : map.values()) {
                result.addAll(nims);
            }
        } else {
            VirtualFile root = null;
            for (String pattern : filePatterns) {
                Set<NamedInputStream> niss = map.get(pattern);
                if (niss == null) {
                    if (root == null) {
                        root = this.getFile(jartoScan);
                    }
                    try {
                        List children = root.getChildrenRecursively((VirtualFileFilter)new HibernatePatternFilter(pattern));
                        niss = this.toNIS(children);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (niss == null) continue;
                result.addAll(niss);
            }
        }
    }

    private Set<NamedInputStream> toNIS(Iterable<VirtualFile> files) {
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        for (VirtualFile file : files) {
            HibernateVirtualFileNamedInputStream nis = new HibernateVirtualFileNamedInputStream(file);
            result.add(nis);
        }
        return result;
    }

    public Set<NamedInputStream> getFilesInClasspath(Set<String> filePatterns) {
        throw JpaMessages.MESSAGES.notYetImplemented();
    }

    public String getUnqualifiedJarName(URL jarUrl) {
        VirtualFile file = this.getFile(jarUrl);
        return file.getName();
    }

    private VirtualFile getFile(URL url) {
        try {
            return VFS.getChild((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

