/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.LambdaFactory;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jinq.jpa.jpqlquery.BinaryExpression;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.ConstantExpression;
import org.jinq.jpa.jpqlquery.CustomTupleRowReader;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.FunctionExpression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ParameterAsQuery;
import org.jinq.jpa.jpqlquery.ParameterExpression;
import org.jinq.jpa.jpqlquery.ReadFieldExpression;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.SimpleRowReader;
import org.jinq.jpa.jpqlquery.SubqueryExpression;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.jpqlquery.UnaryExpression;
import org.jinq.jpa.transform.AggregateTransform;
import org.jinq.jpa.transform.CustomTupleInfo;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.MethodChecker;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToSubQuery;
import org.jinq.rebased.org.objectweb.asm.Type;

public class SymbExToColumns
extends TypedValueVisitor<SymbExPassDown, ColumnExpressions<?>, TypedValueVisitorException> {
    final SymbExArgumentHandler argHandler;
    final JPQLQueryTransformConfiguration config;
    static Map<Type, Integer> numericPromotionPriority = new HashMap<Type, Integer>();

    SymbExToColumns(JPQLQueryTransformConfiguration config, SymbExArgumentHandler argumentHandler) {
        this.config = config;
        this.argHandler = argumentHandler;
    }

    public ColumnExpressions<?> defaultValue(TypedValue val, SymbExPassDown in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled symbolic execution operation: " + val);
    }

    public ColumnExpressions<?> argValue(TypedValue.ArgValue val, SymbExPassDown in) throws TypedValueVisitorException {
        int index = val.getIndex();
        return this.argHandler.handleArg(index, val.getType());
    }

    public ColumnExpressions<?> booleanConstantValue(ConstantValue.BooleanConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        if (in.isExpectingConditional) {
            return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(val.val ? "(1=1)" : "(1!=1)"));
        }
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(val.val ? "TRUE" : "FALSE"));
    }

    public ColumnExpressions<?> integerConstantValue(ConstantValue.IntegerConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(Integer.toString(val.val)));
    }

    public ColumnExpressions<?> longConstantValue(ConstantValue.LongConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(Long.toString(val.val)));
    }

    public ColumnExpressions<?> floatConstantValue(ConstantValue.FloatConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(Float.toString(val.val)));
    }

    public ColumnExpressions<?> doubleConstantValue(ConstantValue.DoubleConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(Double.toString(val.val)));
    }

    public ColumnExpressions<?> stringConstantValue(ConstantValue.StringConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression("'" + this.escapeStringConstant(val.val) + "'"));
    }

    private String escapeStringConstant(String val) {
        return val.replaceAll("'", "''");
    }

    public ColumnExpressions<?> nullConstantValue(ConstantValue.NullConstant val, SymbExPassDown in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unexpected NULL value");
    }

    public ColumnExpressions<?> unaryMathOpValue(TypedValue.UnaryMathOpValue val, SymbExPassDown in) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
        ColumnExpressions left = (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)passdown);
        return ColumnExpressions.singleColumn(left.reader, UnaryExpression.prefix(val.op.getOpString(), left.getOnlyColumn()));
    }

    public ColumnExpressions<?> notOpValue(TypedValue.NotValue val, SymbExPassDown in) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, true);
        ColumnExpressions left = (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)passdown);
        return ColumnExpressions.singleColumn(left.reader, UnaryExpression.prefix("NOT", left.getOnlyColumn()));
    }

    public ColumnExpressions<?> getStaticFieldValue(TypedValue.GetStaticFieldValue val, SymbExPassDown in) throws TypedValueVisitorException {
        if (this.config.metamodel.isKnownEnumType(val.owner)) {
            String enumFullName = this.config.metamodel.getFullEnumConstantName(val.owner, val.name);
            if (enumFullName != null) {
                return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression(enumFullName));
            }
        } else if ("java/lang/Boolean".equals(val.owner) && ("TRUE".equals(val.name) || "FALSE".equals(val.name))) {
            return ColumnExpressions.singleColumn(new SimpleRowReader(), new ConstantExpression("TRUE".equals(val.name) ? "TRUE" : "FALSE"));
        }
        return this.defaultValue((TypedValue)val, in);
    }

    public ColumnExpressions<?> castValue(TypedValue.CastValue val, SymbExPassDown in) throws TypedValueVisitorException {
        if (val.isPrimitive()) {
            throw new TypedValueVisitorException("Casts of primitive values are not support in JPQL");
        }
        return (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)SymbExPassDown.with((TypedValue)val, in.isExpectingConditional));
    }

    private boolean isWideningCast(TypedValue val) {
        MethodCallValue.StaticMethodCallValue methodCall;
        MethodSignature sig;
        if (val instanceof TypedValue.CastValue) {
            TypedValue.CastValue castedVal = (TypedValue.CastValue)val;
            Type toType = castedVal.getType();
            Type fromType = castedVal.operand.getType();
            if (!numericPromotionPriority.containsKey(fromType)) {
                return false;
            }
            if (!numericPromotionPriority.containsKey(toType)) {
                return false;
            }
            if (numericPromotionPriority.get(toType) > numericPromotionPriority.get(fromType)) {
                return true;
            }
        } else if (val instanceof MethodCallValue.VirtualMethodCallValue) {
            MethodCallValue.VirtualMethodCallValue methodCall2 = (MethodCallValue.VirtualMethodCallValue)val;
            MethodSignature sig2 = methodCall2.getSignature();
            if (sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalLong) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalInt) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalBigInteger)) {
                return true;
            }
            if (sig2.equals((Object)TransformationClassAnalyzer.bigDecimalDoubleValue) || sig2.equals((Object)TransformationClassAnalyzer.bigIntegerDoubleValue)) {
                return true;
            }
        } else if (val instanceof MethodCallValue.StaticMethodCallValue && (sig = (methodCall = (MethodCallValue.StaticMethodCallValue)val).getSignature()).equals((Object)TransformationClassAnalyzer.bigIntegerValueOfLong)) {
            return true;
        }
        return false;
    }

    private TypedValue skipWideningCast(TypedValue val) throws TypedValueVisitorException {
        MethodCallValue.StaticMethodCallValue methodCall;
        MethodSignature sig;
        if (!this.isWideningCast(val)) {
            return val;
        }
        if (val instanceof TypedValue.CastValue) {
            TypedValue.CastValue castedVal = (TypedValue.CastValue)val;
            return this.skipWideningCast(castedVal.operand);
        }
        if (val instanceof MethodCallValue.VirtualMethodCallValue) {
            MethodCallValue.VirtualMethodCallValue methodCall2 = (MethodCallValue.VirtualMethodCallValue)val;
            MethodSignature sig2 = methodCall2.getSignature();
            if (sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalLong) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalInt) || sig2.equals((Object)TransformationClassAnalyzer.newBigDecimalBigInteger)) {
                return this.skipWideningCast((TypedValue)methodCall2.args.get(0));
            }
            if (sig2.equals((Object)TransformationClassAnalyzer.bigDecimalDoubleValue) || sig2.equals((Object)TransformationClassAnalyzer.bigIntegerDoubleValue)) {
                return this.skipWideningCast(methodCall2.base);
            }
        } else if (val instanceof MethodCallValue.StaticMethodCallValue && (sig = (methodCall = (MethodCallValue.StaticMethodCallValue)val).getSignature()).equals((Object)TransformationClassAnalyzer.bigIntegerValueOfLong)) {
            return this.skipWideningCast((TypedValue)methodCall.args.get(0));
        }
        throw new IllegalArgumentException("Cannot skip an unknown widening cast type");
    }

    private <U> ColumnExpressions<U> binaryOpWithNull(String opString, TypedValue leftVal, TypedValue rightVal, SymbExPassDown passdown) throws TypedValueVisitorException {
        if (!"=".equals(opString) && !"<>".equals(opString)) {
            throw new TypedValueVisitorException("Unhandled operation involving NULL");
        }
        if (leftVal instanceof ConstantValue.NullConstant && rightVal instanceof ConstantValue.NullConstant) {
            throw new TypedValueVisitorException("Cannot handle comparisons involving two NULLs");
        }
        TypedValue operandVal = leftVal instanceof ConstantValue.NullConstant ? rightVal : leftVal;
        ColumnExpressions operand = (ColumnExpressions)operandVal.visit((TypedValueVisitor)this, (Object)passdown);
        if ("=".equals(opString)) {
            return ColumnExpressions.singleColumn(new SimpleRowReader(), UnaryExpression.postfix("IS NULL", operand.getOnlyColumn()));
        }
        return ColumnExpressions.singleColumn(new SimpleRowReader(), UnaryExpression.postfix("IS NOT NULL", operand.getOnlyColumn()));
    }

    private <U> ColumnExpressions<U> binaryOpWithNumericPromotion(String opString, TypedValue leftVal, TypedValue rightVal, SymbExPassDown passdown) throws TypedValueVisitorException {
        boolean isFinalTypeFromLeft = true;
        if (leftVal instanceof ConstantValue.NullConstant || rightVal instanceof ConstantValue.NullConstant) {
            return this.binaryOpWithNull(opString, leftVal, rightVal, passdown);
        }
        assert (leftVal.getType().equals((Object)rightVal.getType()) || leftVal.getType().getInternalName().equals("java/lang/Object") && this.config.isObjectEqualsSafe || rightVal.getType().getInternalName().equals("java/lang/Object") && this.config.isObjectEqualsSafe);
        if (this.isWideningCast(leftVal)) {
            if (!this.isWideningCast(rightVal)) {
                leftVal = this.skipWideningCast(leftVal);
                isFinalTypeFromLeft = false;
            }
        } else if (this.isWideningCast(rightVal)) {
            rightVal = this.skipWideningCast(rightVal);
        }
        ColumnExpressions left = (ColumnExpressions)leftVal.visit((TypedValueVisitor)this, (Object)passdown);
        ColumnExpressions right = (ColumnExpressions)rightVal.visit((TypedValueVisitor)this, (Object)passdown);
        return ColumnExpressions.singleColumn(isFinalTypeFromLeft ? left.reader : right.reader, new BinaryExpression(opString, left.getOnlyColumn(), right.getOnlyColumn()));
    }

    public ColumnExpressions<?> mathOpValue(TypedValue.MathOpValue val, SymbExPassDown in) throws TypedValueVisitorException {
        if (val.op == TypedValue.MathOpValue.Op.cmp) {
            throw new TypedValueVisitorException("cmp operator was not converted to a boolean operator");
        }
        if (val.op == TypedValue.MathOpValue.Op.mod) {
            if (val.left.getType().equals((Object)Type.INT_TYPE) || val.right.getType().equals((Object)Type.INT_TYPE)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions left = (ColumnExpressions)val.left.visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions right = (ColumnExpressions)val.right.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(left.reader, FunctionExpression.twoParam("MOD", left.getOnlyColumn(), right.getOnlyColumn()));
            }
            throw new TypedValueVisitorException("mod operator cannot be used for the given types.");
        }
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
        return this.binaryOpWithNumericPromotion(val.sqlOpString(), val.left, val.right, passdown);
    }

    public ColumnExpressions<?> comparisonOpValue(TypedValue.ComparisonValue val, SymbExPassDown in) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
        return this.binaryOpWithNumericPromotion(val.sqlOpString(), val.left, val.right, passdown);
    }

    private boolean isAggregateMethod(MethodSignature sig) {
        return sig.equals((Object)MethodChecker.streamSumInt) || sig.equals((Object)MethodChecker.streamSumDouble) || sig.equals((Object)MethodChecker.streamSumLong) || sig.equals((Object)MethodChecker.streamSumBigInteger) || sig.equals((Object)MethodChecker.streamSumBigDecimal) || sig.equals((Object)MethodChecker.streamMax) || sig.equals((Object)MethodChecker.streamMin) || sig.equals((Object)MethodChecker.streamAvg) || sig.equals((Object)MethodChecker.streamCount);
    }

    public ColumnExpressions<?> virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (TransformationClassAnalyzer.newPair.equals((Object)sig) || TransformationClassAnalyzer.newTuple3.equals((Object)sig) || TransformationClassAnalyzer.newTuple4.equals((Object)sig) || TransformationClassAnalyzer.newTuple5.equals((Object)sig) || TransformationClassAnalyzer.newTuple6.equals((Object)sig) || TransformationClassAnalyzer.newTuple7.equals((Object)sig) || TransformationClassAnalyzer.newTuple8.equals((Object)sig)) {
            Function<RowReader<?>[], RowReader<?>> tupleReaderMaker = valReaders -> TupleRowReader.createReaderForTuple(sig.owner, valReaders);
            return this.handleMakeTupleMethodCall((MethodCallValue)val, in, tupleReaderMaker);
        }
        if (this.config.metamodel.customTupleConstructorMethods.containsKey(sig)) {
            CustomTupleInfo tupleInfo = this.config.metamodel.customTupleConstructorMethods.get(sig);
            Function<RowReader<?>[], RowReader<?>> tupleReaderMaker = valReaders -> new CustomTupleRowReader(null, tupleInfo.constructor, (RowReader<?>[])valReaders);
            return this.handleMakeTupleMethodCall((MethodCallValue)val, in, tupleReaderMaker);
        }
        if (this.config.metamodel.isSingularAttributeFieldMethod(sig)) {
            String fieldName = this.config.metamodel.fieldMethodToFieldName(sig);
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            if (base.getOnlyColumn() instanceof ParameterExpression) {
                throw new IllegalArgumentException("Cannot access fields and members of complex query parameters inside a query. Use simpler types for parameters (i.e. store the fields in local variables, then use these local variables as parameters for the query instead)");
            }
            if (in.isExpectingConditional && (sig.getReturnType().equals((Object)Type.BOOLEAN_TYPE) || sig.getReturnType().equals((Object)Type.getObjectType((String)"java/lang/Boolean")))) {
                return ColumnExpressions.singleColumn(new SimpleRowReader(), new BinaryExpression("=", new ReadFieldExpression(base.getOnlyColumn(), fieldName), new ConstantExpression("TRUE")));
            }
            return ColumnExpressions.singleColumn(new SimpleRowReader(), new ReadFieldExpression(base.getOnlyColumn(), fieldName));
        }
        if (MetamodelUtil.TUPLE_ACCESSORS.containsKey(sig)) {
            int idx = MetamodelUtil.TUPLE_ACCESSORS.get(sig) - 1;
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            RowReader<?> subreader = ((TupleRowReader)base.reader).getReaderForIndex(idx);
            ColumnExpressions toReturn = new ColumnExpressions(subreader);
            int baseOffset = ((TupleRowReader)base.reader).getColumnForIndex(idx);
            for (int n = 0; n < subreader.getNumColumns(); ++n) {
                toReturn.columns.add(base.columns.get(n + baseOffset));
            }
            return toReturn;
        }
        if (this.config.metamodel.customTupleAccessorMethods.containsKey(sig)) {
            int idx = this.config.metamodel.customTupleAccessorMethods.get(sig) - 1;
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            RowReader<?> subreader = ((CustomTupleRowReader)base.reader).getReaderForIndex(idx);
            ColumnExpressions toReturn = new ColumnExpressions(subreader);
            int baseOffset = ((CustomTupleRowReader)base.reader).getColumnForIndex(idx);
            for (int n = 0; n < subreader.getNumColumns(); ++n) {
                toReturn.columns.add(base.columns.get(n + baseOffset));
            }
            return toReturn;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.integerIntValue) || sig.equals((Object)TransformationClassAnalyzer.longLongValue) || sig.equals((Object)TransformationClassAnalyzer.floatFloatValue) || sig.equals((Object)TransformationClassAnalyzer.doubleDoubleValue) || sig.equals((Object)TransformationClassAnalyzer.booleanBooleanValue)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
            return base;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.newBigDecimalLong) || sig.equals((Object)TransformationClassAnalyzer.newBigDecimalDouble) || sig.equals((Object)TransformationClassAnalyzer.newBigDecimalInt) || sig.equals((Object)TransformationClassAnalyzer.newBigDecimalBigInteger)) {
            throw new TypedValueVisitorException("New BigDecimals can only be created in the context of numeric promotion");
        }
        if (this.isAggregateMethod(sig)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, true);
            JPQLQuery subQuery = (JPQLQuery)val.base.visit((TypedValueVisitor)translator, (Object)passdown);
            LambdaAnalysis lambda = null;
            if (val.args.size() > 0) {
                if (!(val.args.get(0) instanceof LambdaFactory)) {
                    throw new TypedValueVisitorException("Expecting a lambda factory for aggregate method");
                }
                LambdaFactory lambdaFactory = (LambdaFactory)val.args.get(0);
                try {
                    lambda = LambdaAnalysis.analyzeMethod(this.config.metamodel, this.config.alternateClassLoader, this.config.isObjectEqualsSafe, this.config.isAllEqualsSafe, this.config.isCollectionContainsSafe, lambdaFactory.getLambdaMethod(), lambdaFactory.getCapturedArgs(), true);
                }
                catch (Exception e) {
                    throw new TypedValueVisitorException("Could not analyze the lambda code", (Throwable)e);
                }
            }
            try {
                AggregateTransform transform;
                if (sig.equals((Object)MethodChecker.streamSumInt) || sig.equals((Object)MethodChecker.streamSumLong) || sig.equals((Object)MethodChecker.streamSumDouble) || sig.equals((Object)MethodChecker.streamSumBigDecimal) || sig.equals((Object)MethodChecker.streamSumBigInteger)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.SUM);
                } else if (sig.equals((Object)MethodChecker.streamMax)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.MAX);
                } else if (sig.equals((Object)MethodChecker.streamMin)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.MIN);
                } else if (sig.equals((Object)MethodChecker.streamAvg)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.AVG);
                } else if (sig.equals((Object)MethodChecker.streamCount)) {
                    transform = new AggregateTransform(this.config, AggregateTransform.AggregateType.COUNT);
                } else {
                    throw new TypedValueVisitorException("Unhandled aggregate operation");
                }
                JPQLQuery aggregatedQuery = transform.apply(subQuery, lambda, this.argHandler);
                if (aggregatedQuery.getClass() == SelectOnly.class) {
                    SelectOnly select = (SelectOnly)aggregatedQuery;
                    return select.cols;
                }
                if (aggregatedQuery.isValidSubquery() && aggregatedQuery instanceof SelectFromWhere) {
                    SelectFromWhere sfw = (SelectFromWhere)aggregatedQuery;
                    ColumnExpressions toReturn = new ColumnExpressions(sfw.cols.reader);
                    for (Expression col : sfw.cols.columns) {
                        SelectOnly oneColQuery = sfw.shallowCopy();
                        ((SelectFromWhere)oneColQuery).cols = ColumnExpressions.singleColumn(new SimpleRowReader(), col);
                        toReturn.columns.add(SubqueryExpression.from(oneColQuery));
                    }
                    return toReturn;
                }
                throw new TypedValueVisitorException("Unknown subquery type");
            }
            catch (QueryTransformException e) {
                throw new TypedValueVisitorException("Could not derive an aggregate function for a lambda", (Throwable)e);
            }
        }
        if (sig.equals((Object)MethodChecker.streamGetOnlyValue)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, true);
            JPQLQuery subQuery = (JPQLQuery)val.base.visit((TypedValueVisitor)translator, (Object)passdown);
            if (subQuery.isValidSubquery() && subQuery instanceof SelectFromWhere) {
                SelectFromWhere sfw = (SelectFromWhere)subQuery;
                ColumnExpressions toReturn = new ColumnExpressions(sfw.cols.reader);
                for (Expression col : sfw.cols.columns) {
                    SelectOnly oneColQuery = sfw.shallowCopy();
                    ((SelectFromWhere)oneColQuery).cols = ColumnExpressions.singleColumn(new SimpleRowReader(), col);
                    toReturn.columns.add(SubqueryExpression.from(oneColQuery));
                }
                return toReturn;
            }
            throw new TypedValueVisitorException("Cannot apply getOnlyValue() to the given subquery");
        }
        if (sig.equals((Object)MethodChecker.streamExists)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, true);
            JPQLQuery subQuery = (JPQLQuery)val.base.visit((TypedValueVisitor)translator, (Object)passdown);
            if (subQuery.isValidSubquery() && subQuery instanceof SelectFromWhere) {
                SelectFromWhere sfw = (SelectFromWhere)subQuery;
                return ColumnExpressions.singleColumn(new SimpleRowReader(), UnaryExpression.prefix("EXISTS", SubqueryExpression.from(sfw)));
            }
            throw new TypedValueVisitorException("Cannot apply exists() to the given subquery");
        }
        if (MethodChecker.jpqlFunctionMethods.contains(sig)) {
            if (sig.equals((Object)MethodChecker.bigDecimalAbs) || sig.equals((Object)MethodChecker.bigIntegerAbs)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.singleParam("ABS", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.bigDecimalNegate) || sig.equals((Object)MethodChecker.bigIntegerNegate)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, UnaryExpression.prefix("-", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.stringToUpper)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.singleParam("UPPER", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.stringToLower)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.singleParam("LOWER", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.stringLength)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.singleParam("LENGTH", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.stringTrim)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.singleParam("TRIM", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.stringSubstring)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions startIndex = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions endIndex = (ColumnExpressions)((TypedValue)val.args.get(1)).visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.threeParam("SUBSTRING", base.getOnlyColumn(), new BinaryExpression("+", startIndex.getOnlyColumn(), new ConstantExpression("1")), new BinaryExpression("-", endIndex.getOnlyColumn(), startIndex.getOnlyColumn())));
            }
            if (sig.equals((Object)MethodChecker.stringIndexOf)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions search = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, new BinaryExpression("-", FunctionExpression.twoParam("LOCATE", search.getOnlyColumn(), base.getOnlyColumn()), new ConstantExpression("1")));
            }
            if (sig.equals((Object)MethodChecker.stringContains)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions search = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown.acceptingCharSequence());
                return ColumnExpressions.singleColumn(base.reader, new BinaryExpression(">", FunctionExpression.twoParam("LOCATE", search.getOnlyColumn(), base.getOnlyColumn()), new ConstantExpression("0")));
            }
            if (sig.equals((Object)MethodChecker.stringStartsWith)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions search = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, new BinaryExpression("=", FunctionExpression.twoParam("LOCATE", search.getOnlyColumn(), base.getOnlyColumn()), new ConstantExpression("1")));
            }
            throw new TypedValueVisitorException("Do not know how to translate the method " + sig + " into a JPQL function");
        }
        if (sig.equals((Object)TransformationClassAnalyzer.stringBuilderToString)) {
            if (!(val.base instanceof MethodCallValue.VirtualMethodCallValue)) {
                throw new TypedValueVisitorException("Unexpected use of StringBuilder");
            }
            return this.buildStringBuilderString((MethodCallValue.VirtualMethodCallValue)val.base);
        }
        if (sig.equals((Object)TransformationClassAnalyzer.stringBuilderAppendString) && in.canAcceptCharSequence) {
            return this.buildStringBuilderString(val);
        }
        try {
            Method reflectedMethod = Annotations.asmMethodSignatureToReflectionMethod((MethodSignature)sig);
            if ("contains".equals(sig.name) && "(Ljava/lang/Object;)Z".equals(sig.desc) && Collection.class.isAssignableFrom(reflectedMethod.getDeclaringClass())) {
                TypedValue listVal = val.base;
                TypedValue itemVal = (TypedValue)val.args.get(0);
                return this.handleIsIn((TypedValue)val, listVal, itemVal, false);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        return (ColumnExpressions)super.virtualMethodCallValue(val, (Object)in);
    }

    private ColumnExpressions<?> buildStringBuilderString(MethodCallValue.VirtualMethodCallValue baseVal) throws TypedValueVisitorException {
        ArrayList<ColumnExpressions> concatenatedStrings;
        block5: {
            concatenatedStrings = new ArrayList<ColumnExpressions>();
            while (true) {
                SymbExPassDown passdown;
                if (baseVal.getSignature().equals((Object)TransformationClassAnalyzer.newStringBuilderString)) {
                    passdown = SymbExPassDown.with((TypedValue)baseVal, false);
                    concatenatedStrings.add((ColumnExpressions)((TypedValue)baseVal.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown));
                    break block5;
                }
                if (baseVal.getSignature().equals((Object)TransformationClassAnalyzer.newStringBuilder)) break block5;
                if (!baseVal.getSignature().equals((Object)TransformationClassAnalyzer.stringBuilderAppendString)) break;
                passdown = SymbExPassDown.with((TypedValue)baseVal, false);
                concatenatedStrings.add((ColumnExpressions)((TypedValue)baseVal.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown));
                if (!(baseVal.base instanceof MethodCallValue.VirtualMethodCallValue)) {
                    throw new TypedValueVisitorException("Unexpected use of StringBuilder");
                }
                baseVal = (MethodCallValue.VirtualMethodCallValue)baseVal.base;
            }
            throw new TypedValueVisitorException("Unexpected use of StringBuilder");
        }
        if (concatenatedStrings.size() == 1) {
            return (ColumnExpressions)concatenatedStrings.get(0);
        }
        Expression head = ((ColumnExpressions)concatenatedStrings.get(concatenatedStrings.size() - 1)).getOnlyColumn();
        for (int n = concatenatedStrings.size() - 2; n >= 0; --n) {
            head = FunctionExpression.twoParam("CONCAT", head, ((ColumnExpressions)concatenatedStrings.get(n)).getOnlyColumn());
        }
        return ColumnExpressions.singleColumn(new SimpleRowReader(), head);
    }

    public ColumnExpressions<?> invokeDynamicStringConcatCallValue(MethodCallValue.InvokeDynamicStringConcatCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        ArrayList<ColumnExpressions> concatenatedStrings = new ArrayList<ColumnExpressions>();
        int argIdx = 0;
        int constantIdx = 0;
        String recipe = (String)val.bsmArgs.get(0);
        for (int n = 0; n < recipe.length(); ++n) {
            char code = recipe.charAt(n);
            if (code == '\u0001') {
                TypedValue arg = (TypedValue)val.args.get(argIdx);
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                concatenatedStrings.add((ColumnExpressions)arg.visit((TypedValueVisitor)this, (Object)passdown));
                ++argIdx;
                continue;
            }
            if (code == '\u0002') {
                ++constantIdx;
                throw new TypedValueVisitorException("Unhandled use of constants in string concatenation lambda");
            }
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
            concatenatedStrings.add((ColumnExpressions)new ConstantValue.StringConstant(String.valueOf(code)).visit((TypedValueVisitor)this, (Object)passdown));
        }
        if (concatenatedStrings.size() == 1) {
            return (ColumnExpressions)concatenatedStrings.get(0);
        }
        Expression head = ((ColumnExpressions)concatenatedStrings.get(concatenatedStrings.size() - 1)).getOnlyColumn();
        for (int n = concatenatedStrings.size() - 2; n >= 0; --n) {
            head = FunctionExpression.twoParam("CONCAT", head, ((ColumnExpressions)concatenatedStrings.get(n)).getOnlyColumn());
        }
        return ColumnExpressions.singleColumn(new SimpleRowReader(), head);
    }

    public ColumnExpressions<?> staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (sig.equals((Object)TransformationClassAnalyzer.integerValueOf) || sig.equals((Object)TransformationClassAnalyzer.longValueOf) || sig.equals((Object)TransformationClassAnalyzer.floatValueOf) || sig.equals((Object)TransformationClassAnalyzer.doubleValueOf) || sig.equals((Object)TransformationClassAnalyzer.booleanValueOf)) {
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
            return base;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.bigIntegerValueOfLong)) {
            throw new TypedValueVisitorException("New BigIntegers can only be created in the context of numeric promotion");
        }
        if (sig.equals((Object)MethodChecker.stringValueOfObject)) {
            if (!((TypedValue)val.args.get(0)).getType().equals((Object)Type.getObjectType((String)"java/lang/String"))) {
                throw new TypedValueVisitorException("Do not know how to convert type " + ((TypedValue)val.args.get(0)).getType() + " to a string");
            }
            SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
            ColumnExpressions base = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
            return base;
        }
        if (MethodChecker.jpqlFunctionStaticMethods.contains(sig)) {
            if (sig.equals((Object)MethodChecker.jpqlLike)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
                ColumnExpressions base = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
                ColumnExpressions pattern = (ColumnExpressions)((TypedValue)val.args.get(1)).visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(new SimpleRowReader(), new BinaryExpression("LIKE", base.getOnlyColumn(), pattern.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.jpqlIsIn) || sig.equals((Object)MethodChecker.jpqlIsInList) || sig.equals((Object)MethodChecker.jpqlListContains)) {
                boolean isItemFirst = sig.equals((Object)MethodChecker.jpqlIsIn) || sig.equals((Object)MethodChecker.jpqlIsInList);
                boolean isExpectingStream = sig.equals((Object)MethodChecker.jpqlIsIn);
                TypedValue listVal = isItemFirst ? (TypedValue)val.args.get(1) : (TypedValue)val.args.get(0);
                TypedValue itemVal = isItemFirst ? (TypedValue)val.args.get(0) : (TypedValue)val.args.get(1);
                return this.handleIsIn((TypedValue)val, listVal, itemVal, isExpectingStream);
            }
            if (sig.equals((Object)MethodChecker.mathAbsDouble) || sig.equals((Object)MethodChecker.mathAbsInt) || sig.equals((Object)MethodChecker.mathAbsLong)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
                ColumnExpressions base = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(base.reader, FunctionExpression.singleParam("ABS", base.getOnlyColumn()));
            }
            if (sig.equals((Object)MethodChecker.mathSqrt)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
                TypedValue baseVal = (TypedValue)val.args.get(0);
                if (this.isWideningCast(baseVal)) {
                    baseVal = this.skipWideningCast(baseVal);
                }
                ColumnExpressions base = (ColumnExpressions)baseVal.visit((TypedValueVisitor)this, (Object)passdown);
                return ColumnExpressions.singleColumn(new SimpleRowReader(), FunctionExpression.singleParam("SQRT", base.getOnlyColumn()));
            }
            throw new TypedValueVisitorException("Do not know how to translate the method " + sig + " into a JPQL function");
        }
        if (this.config.metamodel.customTupleStaticBuilderMethods.containsKey(sig)) {
            CustomTupleInfo tupleInfo = this.config.metamodel.customTupleStaticBuilderMethods.get(sig);
            Function<RowReader<?>[], RowReader<?>> tupleReaderMaker = valReaders -> new CustomTupleRowReader(tupleInfo.staticBuilder, null, (RowReader<?>[])valReaders);
            return this.handleMakeTupleMethodCall((MethodCallValue)val, in, tupleReaderMaker);
        }
        if (this.config.metamodel.customSqlFunctionMethods.containsKey(sig)) {
            String functionName = this.escapeStringConstant(this.config.metamodel.customSqlFunctionMethods.get(sig));
            Expression[] subVals = new Expression[val.args.size()];
            for (int n = 0; n < subVals.length; ++n) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                TypedValue baseVal = (TypedValue)val.args.get(n);
                if (this.isWideningCast(baseVal)) {
                    baseVal = this.skipWideningCast(baseVal);
                }
                subVals[n] = ((ColumnExpressions)baseVal.visit((TypedValueVisitor)this, (Object)passdown)).getOnlyColumn();
            }
            return ColumnExpressions.singleColumn(new SimpleRowReader(), FunctionExpression.customSqlFunction(functionName, subVals));
        }
        return (ColumnExpressions)super.staticMethodCallValue(val, (Object)in);
    }

    private ColumnExpressions<?> handleMakeTupleMethodCall(MethodCallValue val, SymbExPassDown in, Function<RowReader<?>[], RowReader<?>> tupleReaderMaker) throws TypedValueVisitorException {
        ColumnExpressions[] vals = new ColumnExpressions[val.args.size()];
        SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, in.isExpectingConditional);
        for (int n = 0; n < vals.length; ++n) {
            vals[n] = (ColumnExpressions)((TypedValue)val.args.get(n)).visit((TypedValueVisitor)this, (Object)passdown);
        }
        RowReader[] valReaders = new RowReader[vals.length];
        for (int n = 0; n < vals.length; ++n) {
            valReaders[n] = vals[n].reader;
        }
        ColumnExpressions toReturn = new ColumnExpressions(tupleReaderMaker.apply(valReaders));
        for (int n = 0; n < vals.length; ++n) {
            toReturn.columns.addAll(vals[n].columns);
        }
        return toReturn;
    }

    protected ColumnExpressions<?> handleIsIn(TypedValue parent, TypedValue listVal, TypedValue itemVal, boolean isExpectingStream) throws TypedValueVisitorException {
        SymbExPassDown passdown = SymbExPassDown.with(parent, false);
        ColumnExpressions item = (ColumnExpressions)itemVal.visit((TypedValueVisitor)this, (Object)passdown);
        SymbExToSubQuery translator = this.config.newSymbExToSubQuery(this.argHandler, isExpectingStream);
        JPQLQuery subQuery = (JPQLQuery)listVal.visit((TypedValueVisitor)translator, (Object)passdown);
        if (subQuery.isValidSubquery() && subQuery instanceof SelectFromWhere) {
            SelectFromWhere sfw = (SelectFromWhere)subQuery;
            return ColumnExpressions.singleColumn(new SimpleRowReader(), new BinaryExpression("IN", item.getOnlyColumn(), SubqueryExpression.from(sfw)));
        }
        if (subQuery.isValidSubquery() && subQuery instanceof ParameterAsQuery) {
            ParameterAsQuery paramQuery = (ParameterAsQuery)subQuery;
            return ColumnExpressions.singleColumn(new SimpleRowReader(), new BinaryExpression("IN", item.getOnlyColumn(), paramQuery.cols.getOnlyColumn()));
        }
        throw new TypedValueVisitorException("Trying to create a query using IN but with an unhandled subquery type");
    }

    static {
        int n = 0;
        numericPromotionPriority.put(Type.INT_TYPE, n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Integer"), n);
        numericPromotionPriority.put(Type.LONG_TYPE, ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Long"), n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/math/BigInteger"), ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/math/BigDecimal"), ++n);
        numericPromotionPriority.put(Type.FLOAT_TYPE, ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Float"), n);
        numericPromotionPriority.put(Type.DOUBLE_TYPE, ++n);
        numericPromotionPriority.put(Type.getObjectType((String)"java/lang/Double"), n);
        ++n;
    }
}

