/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ReadFieldExpression;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.JPQLQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JoinTransform;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.OuterJoinOnLambdaArgumentHandler;
import org.jinq.jpa.transform.OuterJoinTransform;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToSubQuery;
import org.jinq.jpa.transform.WhereTransform;

public class OuterJoinOnTransform
extends JPQLQueryTransform {
    boolean isExpectingStream;
    boolean isJoinFetch;

    public OuterJoinOnTransform(JPQLQueryTransformConfiguration config, boolean isExpectingStream, boolean isJoinFetch) {
        super(config);
        this.isExpectingStream = isExpectingStream;
        this.isJoinFetch = isJoinFetch;
    }

    public OuterJoinOnTransform(JPQLQueryTransformConfiguration config) {
        this(config, true, false);
    }

    public OuterJoinOnTransform setIsExpectingStream(boolean isExpectingStream) {
        this.isExpectingStream = isExpectingStream;
        return this;
    }

    public OuterJoinOnTransform setIsJoinFetch(boolean isJoinFetch) {
        this.isJoinFetch = isJoinFetch;
        return this;
    }

    static boolean isChainedLink(Expression links) {
        if (links instanceof ReadFieldExpression) {
            return ((ReadFieldExpression)links).base instanceof ReadFieldExpression;
        }
        return false;
    }

    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis joinLambda, LambdaAnalysis onLambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, joinLambda, this.config.metamodel, parentArgumentScope, true), this.isExpectingStream);
                if (joinLambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JPQLQuery returnExpr = (JPQLQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)joinLambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods(), this.config.getComparisonStaticMethods(), (boolean)this.config.isAllEqualsSafe).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    From from = toMerge.froms.get(0);
                    if (this.isJoinFetch) {
                        throw new QueryTransformException("Generating queries with LEFT OUTER JOIN FETCH ... ON is currently not supported");
                    }
                    From.FromLeftOuterJoinSettableOn outerJoinFrom = From.forLeftOuterJoinOn(from);
                    ((SelectFromWhere)toReturn).froms.add((From)((Object)outerJoinFrom));
                    OuterJoinTransform.rewriteFromAliases(toMerge, from, (From)((Object)outerJoinFrom));
                    Expression onExpr = WhereTransform.computeWhereReturnExpr(this.config, onLambda, sfw, new OuterJoinOnLambdaArgumentHandler(sfw.cols, toMerge.cols, onLambda, this.config.metamodel, parentArgumentScope));
                    outerJoinFrom.setOn(onExpr);
                    ((SelectFromWhere)toReturn).cols = new ColumnExpressions<U>(this.createPairReader(sfw.cols.reader, toMerge.cols.reader));
                    ((SelectFromWhere)toReturn).cols.columns.addAll(sfw.cols.columns);
                    ((SelectFromWhere)toReturn).cols.columns.addAll(toMerge.cols.columns);
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createPairReader(RowReader<?> a, RowReader<?> b) {
        return TupleRowReader.createReaderForTuple(TupleRowReader.PAIR_CLASS, a, b);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return OuterJoinOnTransform.class.getName();
    }
}

