/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ReadFieldExpression;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JoinTransform;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.OuterJoinTransform;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToSubQuery;

public class JoinFetchTransform
extends JPQLOneLambdaQueryTransform {
    boolean isExpectingStream;
    boolean isOuterJoinFetch;

    public JoinFetchTransform(JPQLQueryTransformConfiguration config, boolean isExpectingStream, boolean isOuterJoinFetch) {
        super(config);
        this.isExpectingStream = isExpectingStream;
        this.isOuterJoinFetch = isOuterJoinFetch;
    }

    public JoinFetchTransform(JPQLQueryTransformConfiguration config) {
        this(config, false, false);
    }

    public JoinFetchTransform setIsExpectingStream(boolean isExpectingStream) {
        this.isExpectingStream = isExpectingStream;
        return this;
    }

    public JoinFetchTransform setIsOuterJoinFetch(boolean isOuterJoinFetch) {
        this.isOuterJoinFetch = isOuterJoinFetch;
        return this;
    }

    private static boolean isJoinFetchCompatible(SelectFromWhere<?> toMerge) {
        From from = toMerge.froms.get(0);
        if (!(from instanceof From.FromNavigationalLinks)) {
            return false;
        }
        Expression navLink = ((From.FromNavigationalLinks)from).links;
        return navLink instanceof ReadFieldExpression;
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, false), this.isExpectingStream);
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JPQLQuery returnExpr = (JPQLQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods(), this.config.getComparisonStaticMethods(), (boolean)this.config.isAllEqualsSafe).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    From from = toMerge.froms.get(0);
                    if (!JoinFetchTransform.isJoinFetchCompatible(toMerge)) {
                        throw new QueryTransformException("Join fetch must be a single navigational link");
                    }
                    From.FromNavigationalLinksGeneric joinFetchFrom = this.isOuterJoinFetch ? From.forNavigationalLinksLeftOuterJoinFetch((From.FromNavigationalLinks)from) : From.forNavigationalLinksJoinFetch((From.FromNavigationalLinks)from);
                    ((SelectFromWhere)toReturn).froms.add(joinFetchFrom);
                    OuterJoinTransform.rewriteFromAliases(toMerge, from, joinFetchFrom);
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return JoinFetchTransform.class.getName() + ":" + (this.isOuterJoinFetch ? "1" : "0");
    }
}

