/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.utils;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.jimmutable.core.utils.FileUtils;
import org.jimmutable.core.utils.Validator;

public class PropertiesReader {
    private File src;
    private Properties properties = new Properties();

    public PropertiesReader(String file_name_in_home_directory) {
        Validator.notNull((Object)file_name_in_home_directory);
        this.src = new File(FileUtils.getSimpleHomeDirectory(), file_name_in_home_directory);
        try {
            if (this.src.exists()) {
                this.properties.load(new FileReader(this.src));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String readString(String property_name, String default_value) {
        if (property_name == null) {
            return default_value;
        }
        String ret = this.properties.getProperty(property_name = this.normalizePropertyName(property_name));
        if (ret != null) {
            ret = ret.trim();
        }
        if (ret == null || ret.length() == 0) {
            return default_value;
        }
        return ret;
    }

    public boolean readBoolean(String property_name, boolean default_value) {
        String str = this.readString(property_name, null);
        if (str == null) {
            return default_value;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("t")) {
            return true;
        }
        if (str.equalsIgnoreCase("yes")) {
            return true;
        }
        if (str.equalsIgnoreCase("y")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        if (str.equalsIgnoreCase("f")) {
            return false;
        }
        if (str.equalsIgnoreCase("no")) {
            return false;
        }
        if (str.equalsIgnoreCase("n")) {
            return false;
        }
        return default_value;
    }

    public int readInt(String property_name, int default_value) {
        String str = this.readString(property_name, null);
        if (str == null) {
            return default_value;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            LogManager.getRootLogger().error("Error parsing property: " + property_name, (Throwable)e);
            return default_value;
        }
    }

    public long readLong(String property_name, long default_value) {
        String str = this.readString(property_name, null);
        if (str == null) {
            return default_value;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            LogManager.getRootLogger().error("Error parsing property: " + property_name, (Throwable)e);
            e.printStackTrace();
            return default_value;
        }
    }

    private String normalizePropertyName(String src) {
        if (src == null) {
            return src;
        }
        return src.trim().toLowerCase();
    }
}

