/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.utils;

import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionUtils {
    private static Charset utf8 = Charset.forName("UTF-8");

    public static byte[] gzip(byte[] src, byte[] default_value) {
        try {
            if (src == null) {
                return default_value;
            }
            ByteArrayOutputStream out_raw = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(out_raw);
            ByteArrayInputStream in = new ByteArrayInputStream(src);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            return out_raw.toByteArray();
        }
        catch (Exception e) {
            return default_value;
        }
    }

    public static byte[] gzipString(String src, byte[] default_value) {
        if (src == null) {
            return default_value;
        }
        return CompressionUtils.gzip(src.getBytes(utf8), default_value);
    }

    public static byte[] gunzip(byte[] src, byte[] default_value) {
        try {
            if (src == null) {
                return default_value;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(src));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            return out.toByteArray();
        }
        catch (Exception e) {
            return default_value;
        }
    }

    public static String gunzipToString(byte[] src, String default_value) {
        byte[] uncompressed_data = CompressionUtils.gunzip(src, null);
        if (uncompressed_data == null) {
            return default_value;
        }
        return new String(uncompressed_data, utf8);
    }
}

