/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.simple_object_store.scan;

import org.jimmutable.aws.s3.S3Path;
import org.jimmutable.aws.simple_object_store.SimpleObjectStore;
import org.jimmutable.aws.simple_object_store.scan.ScanListener;
import org.jimmutable.core.utils.Validator;

public class ScanRequest {
    private S3Path root_path;
    private ScanListener listener;
    private int processing_threads;
    private SimpleObjectStore store;

    public ScanRequest(SimpleObjectStore store, S3Path root_path, ScanListener listener, int processing_threads) {
        Validator.notNull((Object[])new Object[]{store, root_path, listener});
        if (processing_threads < 1) {
            processing_threads = 1;
        }
        this.store = store;
        this.root_path = root_path;
        this.listener = listener;
        this.processing_threads = processing_threads;
    }

    public SimpleObjectStore getSimpleObjectStore() {
        return this.store;
    }

    public S3Path getSimpleRootPath() {
        return this.root_path;
    }

    public ScanListener getSimpleScanListener() {
        return this.listener;
    }

    public int getSimpleProcessingThreadCount() {
        return this.processing_threads;
    }
}

