/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.simple_object_store.scan;

import org.jimmutable.aws.simple_object_store.scan.OperationList;
import org.jimmutable.aws.simple_object_store.scan.ScanRequest;
import org.jimmutable.core.threading.OperationMonitor;
import org.jimmutable.core.threading.OperationPool;
import org.jimmutable.core.threading.OperationRunnable;

public class OperationScan
extends OperationRunnable {
    public static final int THREAD_COUNT = 100;
    private ScanRequest request;
    private OperationPool child_operations;
    volatile int stats_objects_listed = 0;
    volatile int stats_objects_processed_by_listener = 0;

    public OperationScan(ScanRequest request) {
        this.request = request;
    }

    public ScanRequest getSimpleRequest() {
        return this.request;
    }

    public OperationPool getSimpleChildOperations() {
        return this.child_operations;
    }

    public int getSimpleStatsObjectsListed() {
        return this.stats_objects_listed;
    }

    public int getSimpleStatsObjectsProcessedByListener() {
        return this.stats_objects_processed_by_listener;
    }

    protected OperationRunnable.Result performOperation() throws Exception {
        if (this.shouldStop()) {
            return OperationRunnable.Result.STOPPED;
        }
        OperationList list_operation = new OperationList(this);
        this.child_operations = new OperationPool((OperationRunnable)list_operation, this.getSimpleRequest().getSimpleProcessingThreadCount() + 1);
        OperationRunnable.Result result = OperationRunnable.executeWithMonitor((OperationRunnable)this.child_operations, (long)500L, (OperationMonitor)new ScanMonitor(), (OperationRunnable.Result)OperationRunnable.Result.ERROR);
        this.getSimpleRequest().getSimpleScanListener().onScanComplete(this);
        return result;
    }

    private class ScanMonitor
    implements OperationMonitor {
        private ScanMonitor() {
        }

        public void onOperationMonitorHeartbeat(OperationRunnable runnable) {
            if (!(runnable instanceof OperationScan)) {
                return;
            }
            OperationScan scan_op = (OperationScan)runnable;
            scan_op.getSimpleRequest().getSimpleScanListener().onScanHearbeat(scan_op);
        }
    }
}

