/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.simple_object_store.scan;

import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import org.jimmutable.aws.s3.S3Path;
import org.jimmutable.aws.simple_object_store.scan.OperationProcessObject;
import org.jimmutable.aws.simple_object_store.scan.OperationScan;
import org.jimmutable.aws.simple_object_store.scan.ScanRequest;
import org.jimmutable.core.threading.OperationRunnable;
import org.jimmutable.core.utils.Validator;

public class OperationList
extends OperationRunnable {
    private OperationScan scan_operation;

    public OperationList(OperationScan scan_operation) {
        Validator.notNull((Object)((Object)scan_operation));
        this.scan_operation = scan_operation;
    }

    protected OperationRunnable.Result performOperation() throws Exception {
        if (this.shouldStop()) {
            return OperationRunnable.Result.STOPPED;
        }
        ScanRequest request = this.scan_operation.getSimpleRequest();
        ListObjectsV2Request req = new ListObjectsV2Request();
        req = req.withBucketName(request.getSimpleObjectStore().getSimpleS3BucketNameString());
        req = req.withMaxKeys(Integer.valueOf(1000));
        if (!request.getSimpleRootPath().equals((Object)S3Path.PATH_BUCKET_ROOT)) {
            req = req.withPrefix(request.getSimpleRootPath().getSimpleValue());
        }
        int object_count = 0;
        while (!this.shouldStop()) {
            ListObjectsV2Result result = request.getSimpleObjectStore().getSimpleAmazonS3().listObjectsV2(req);
            for (S3ObjectSummary summary : result.getObjectSummaries()) {
                if (this.shouldStop()) {
                    return OperationRunnable.Result.STOPPED;
                }
                OperationProcessObject task = new OperationProcessObject(this.scan_operation, summary);
                this.scan_operation.getSimpleChildOperations().submitOperation((OperationRunnable)task);
                ++object_count;
            }
            if (!result.isTruncated()) {
                return OperationRunnable.Result.SUCCESS;
            }
            req.setContinuationToken(result.getNextContinuationToken());
        }
        return OperationRunnable.Result.STOPPED;
    }
}

