/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.simple_object_store;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.jimmutable.aws.environment.ApplicationEnvironment;
import org.jimmutable.aws.environment.CloudResource;
import org.jimmutable.aws.s3.BucketPuppet;
import org.jimmutable.aws.s3.S3BucketName;
import org.jimmutable.aws.s3.S3DefaultClientCreator;
import org.jimmutable.aws.s3.S3Path;
import org.jimmutable.aws.simple_object_store.SimpleObjectStorable;
import org.jimmutable.aws.simple_object_store.SimpleStoreName;
import org.jimmutable.aws.simple_object_store.scan.OperationScan;
import org.jimmutable.aws.simple_object_store.scan.ScanListener;
import org.jimmutable.aws.simple_object_store.scan.ScanRequest;
import org.jimmutable.aws.utils.CompressionUtils;
import org.jimmutable.core.objects.StandardObject;
import org.jimmutable.core.serialization.Format;
import org.jimmutable.core.threading.OperationRunnable;
import org.jimmutable.core.utils.Validator;

public class SimpleObjectStore
extends CloudResource {
    private AmazonS3 client;
    private SimpleStoreName store_name;
    private boolean is_read_only;

    public SimpleObjectStore(ApplicationEnvironment env, SimpleStoreName store_name, boolean is_read_only) {
        super(env.getSimpleCloudName());
        Validator.notNull((Object)((Object)store_name));
        this.store_name = store_name;
        this.is_read_only = is_read_only;
        this.client = S3DefaultClientCreator.createDefaultAmazonS3Client(env);
        try {
            BucketPuppet.BucketConfiguration bucket_config = new BucketPuppet.BucketConfiguration(this.getSimpleS3BucketName(), 180, false);
            BucketPuppet.execute(this.client, bucket_config);
        }
        catch (Exception e) {
            LogManager.getRootLogger().error(String.format("Unable to verify the configuration of the bucket %s", new Object[]{this.getSimpleS3BucketName()}), (Throwable)e);
        }
    }

    public SimpleStoreName getSimpleStoreName() {
        return this.store_name;
    }

    public boolean isReadOnly() {
        return this.is_read_only;
    }

    public AmazonS3 getSimpleAmazonS3() {
        return this.client;
    }

    public S3BucketName getSimpleS3BucketName() {
        return new S3BucketName(String.format("%s.%s.store.digitalpanda", this.getSimpleCloudName().getSimpleValue(), this.store_name.getSimpleValue()));
    }

    public String getSimpleS3BucketNameString() {
        return this.getSimpleS3BucketName().toString();
    }

    public boolean upsert(SimpleObjectStorable obj) {
        if (obj == null) {
            LogManager.getRootLogger().error("Failed attempt to write null object to SimpleObjectStore");
            return false;
        }
        if (this.isReadOnly()) {
            LogManager.getRootLogger().debug("Attempt to write " + (Object)((Object)obj.getSimplePath()) + " to a read only SimpleObjectStore");
            return false;
        }
        try {
            byte[] compressed_data = CompressionUtils.gzipString(obj.serialize(Format.XML_PRETTY_PRINT), null);
            if (compressed_data == null) {
                LogManager.getRootLogger().error("Unable to compress the XML serialization of " + (Object)((Object)obj.getSimplePath()) + ": This is very unusual");
                return false;
            }
            ByteArrayInputStream input = new ByteArrayInputStream(compressed_data);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength((long)compressed_data.length);
            meta.setContentEncoding("gzip");
            this.client.putObject(this.getSimpleS3BucketNameString(), obj.getSimplePath().getSimpleValue(), (InputStream)input, meta);
            return true;
        }
        catch (Exception e) {
            LogManager.getRootLogger().error("Failure to write object " + (Object)((Object)obj.getSimplePath()), (Throwable)e);
            return false;
        }
    }

    public StandardObject get(S3Path path, StandardObject default_value) {
        if (path == null) {
            return default_value;
        }
        try {
            S3Object obj = this.client.getObject(this.getSimpleS3BucketNameString(), path.getSimpleValue());
            byte[] compressed_data = IOUtils.toByteArray((InputStream)obj.getObjectContent());
            String uncompressed_string = CompressionUtils.gunzipToString(compressed_data, null);
            if (uncompressed_string == null) {
                LogManager.getRootLogger().error("Unable to un-compres the XML serialization of " + (Object)((Object)path) + ": This is very unusual");
                return default_value;
            }
            return StandardObject.deserialize((String)uncompressed_string);
        }
        catch (Exception e) {
            LogManager.getRootLogger().error("Failure to get object " + (Object)((Object)path), (Throwable)e);
            return default_value;
        }
    }

    public boolean objectExists(S3Path path, boolean default_value) {
        if (path == null) {
            return default_value;
        }
        try {
            return this.client.doesObjectExist(this.getSimpleS3BucketNameString(), path.toString());
        }
        catch (Exception e) {
            LogManager.getRootLogger().error("Failure to list object " + (Object)((Object)path), (Throwable)e);
            return default_value;
        }
    }

    public boolean delete(S3Path path) {
        if (path == null) {
            return false;
        }
        try {
            this.client.deleteObject(this.getSimpleS3BucketNameString(), path.toString());
            return true;
        }
        catch (Exception e) {
            LogManager.getRootLogger().error("Failure to delete object " + (Object)((Object)path), (Throwable)e);
            return false;
        }
    }

    public OperationRunnable.Result scan(S3Path path, ScanListener listener, int processing_threads) {
        ScanRequest request = new ScanRequest(this, path, listener, processing_threads);
        return OperationRunnable.execute((OperationRunnable)new OperationScan(request), (OperationRunnable.Result)OperationRunnable.Result.ERROR);
    }

    public void startScanAsycn(S3Path path, ScanListener listener, int processing_threads) {
        ScanRequest request = new ScanRequest(this, path, listener, processing_threads);
        new Thread((Runnable)((Object)new OperationScan(request)));
    }
}

