/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.s3;

import java.util.List;
import org.jimmutable.core.exceptions.ValidationException;
import org.jimmutable.core.fields.FieldArrayList;
import org.jimmutable.core.fields.FieldList;
import org.jimmutable.core.objects.Stringable;
import org.jimmutable.core.utils.Validator;

public class S3Path
extends Stringable {
    public static S3Path PATH_BUCKET_ROOT = new S3Path("");
    public static final MyConverter CONVERTER = new MyConverter();
    private transient FieldList<String> cached_parts = null;

    public S3Path(String code) {
        super(code);
    }

    public void normalize() {
        this.normalizeTrim();
        this.normalizeLowerCase();
        if (super.getSimpleValue() != null) {
            while (this.getSimpleValue().length() != 0) {
                char first_ch = this.getSimpleValue().charAt(0);
                if (first_ch == '/' || Character.isWhitespace(first_ch)) {
                    this.setValue(this.getSimpleValue().substring(1));
                    continue;
                }
                char last_ch = this.getSimpleValue().charAt(this.getSimpleValue().length() - 1);
                if (last_ch != '/' && !Character.isWhitespace(last_ch)) break;
                this.setValue(this.getSimpleValue().substring(0, this.getSimpleValue().length() - 1));
            }
        }
    }

    public void validate() {
        char[] chars;
        Validator.notNull((Object)this.getSimpleValue());
        for (char ch : chars = this.getSimpleValue().toCharArray()) {
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.' || ch == '/') continue;
            throw new ValidationException(String.format("Illegal character '%c' in S3ObjectPath %s.  Only lower case letters, numbers, dash (-) and dot (.) are allowed.", Character.valueOf(ch), this.getSimpleValue()));
        }
        if (this.getSimpleValue().startsWith(".")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not start with a dot (.) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().startsWith("-")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not start with a dash (-) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().startsWith("/")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not start with a slash (/) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().endsWith(".")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not end with a dot (.) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().endsWith("-")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not end with a dash (-) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().endsWith("/")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not end with a slash (/) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().contains("..")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not contain two dots in a row (..) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().contains("//")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not contain two forward slashes in a row (//) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().contains("--")) {
            throw new ValidationException(String.format("S3ObjectPath %s is invalid, object names may not contain two dashes in a row (--) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().length() > 1024) {
            throw new ValidationException(String.format("S3ObjectPath %s is too long, object names are limited to 1024 characters", this.getSimpleValue()));
        }
    }

    public List<String> getSimpleParts() {
        if (this.cached_parts != null) {
            return this.cached_parts;
        }
        FieldArrayList tmp_parts = new FieldArrayList();
        for (String part : this.getSimpleValue().split("/")) {
            if (part.length() == 0) continue;
            tmp_parts.add((Object)part);
        }
        tmp_parts.freeze();
        this.cached_parts = tmp_parts;
        return this.cached_parts;
    }

    public int getSimpleNumberOfParts() {
        return this.getSimpleParts().size();
    }

    public String getOptionalPart(int idx, String default_value) {
        if (idx < 0) {
            return default_value;
        }
        List<String> parts = this.getSimpleParts();
        if (idx >= parts.size()) {
            return default_value;
        }
        return parts.get(idx);
    }

    public boolean hasLastPart() {
        return !this.getSimpleParts().isEmpty();
    }

    public String getOptionalLastPart(String default_value) {
        List<String> parts = this.getSimpleParts();
        if (parts.isEmpty()) {
            return default_value;
        }
        return parts.get(parts.size() - 1);
    }

    public boolean hasExtension() {
        return this.getOptionalExtension(null) != null;
    }

    public String getOptionalExtension(String default_value) {
        String last_part = this.getOptionalLastPart(null);
        if (last_part == null) {
            return default_value;
        }
        int idx = last_part.lastIndexOf(46);
        if (idx == -1) {
            return default_value;
        }
        return last_part.substring(idx + 1);
    }

    public boolean hasParent() {
        return this.getSimpleNumberOfParts() > 0;
    }

    public S3Path getOptionalParent(S3Path default_value) {
        if (!this.hasParent()) {
            return default_value;
        }
        StringBuilder parent_path = new StringBuilder();
        List<String> parts = this.getSimpleParts();
        for (int i = 0; i < parts.size() - 1; ++i) {
            if (parent_path.length() != 0) {
                parent_path.append("/");
            }
            parent_path.append(parts.get(i));
        }
        return new S3Path(parent_path.toString());
    }

    public static class MyConverter
    extends Stringable.Converter<S3Path> {
        public S3Path fromString(String str, S3Path default_value) {
            try {
                return new S3Path(str);
            }
            catch (Exception e) {
                return default_value;
            }
        }
    }
}

