/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.s3;

import org.jimmutable.core.exceptions.ValidationException;
import org.jimmutable.core.objects.Stringable;
import org.jimmutable.core.utils.Validator;

public class S3BucketName
extends Stringable {
    public static final MyConverter CONVERTER = new MyConverter();

    public S3BucketName(String code) {
        super(code);
    }

    public void normalize() {
        this.normalizeTrim();
        this.normalizeLowerCase();
    }

    public void validate() {
        char[] chars;
        Validator.notNull((Object)this.getSimpleValue());
        Validator.min((int)this.getSimpleValue().length(), (int)1);
        for (char ch : chars = this.getSimpleValue().toCharArray()) {
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.') continue;
            throw new ValidationException(String.format("Illegal character '%c' in bucket name %s.  Only lower case letters, numbers, dash (-) and dot (.) are allowed.", Character.valueOf(ch), this.getSimpleValue()));
        }
        if (this.getSimpleValue().startsWith(".")) {
            throw new ValidationException(String.format("Bucket name %s is invalid, bucket names may not start with a dot (.) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().endsWith(".")) {
            throw new ValidationException(String.format("Bucket name %s is invalid, bucket names may not end with a dot (.) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().contains("..")) {
            throw new ValidationException(String.format("Bucket name %s is invalid, bucket names may not contain two dots in a row (..) ", this.getSimpleValue()));
        }
    }

    public static class MyConverter
    extends Stringable.Converter<S3BucketName> {
        public S3BucketName fromString(String str, S3BucketName default_value) {
            try {
                return new S3BucketName(str);
            }
            catch (Exception e) {
                return default_value;
            }
        }
    }
}

