/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.s3;

import org.jimmutable.aws.s3.S3BucketName;
import org.jimmutable.aws.s3.S3Path;
import org.jimmutable.core.exceptions.ValidationException;
import org.jimmutable.core.objects.Stringable;
import org.jimmutable.core.utils.Validator;

public class S3AbsolutePath
extends Stringable {
    public static final MyConverter CONVERTER = new MyConverter();
    private transient S3BucketName bucket_name;
    private transient S3Path path;

    public S3AbsolutePath(String code) {
        super(code);
    }

    public void normalize() {
        this.normalizeTrim();
        this.normalizeLowerCase();
    }

    public void validate() {
        Validator.notNull((Object)this.getSimpleValue());
        String[] value = this.getSimpleValue().split(":");
        if (value.length != 2) {
            throw new ValidationException(String.format("Invalid S3 absolute path name %s, must contain one : to seperate the bucket name from the object path", this.getSimpleValue()));
        }
        this.bucket_name = new S3BucketName(value[0]);
        this.path = new S3Path(value[1]);
        this.setValue(String.format("%s:%s", this.bucket_name.getSimpleValue(), this.path.getSimpleValue()));
    }

    public static class MyConverter
    extends Stringable.Converter<S3AbsolutePath> {
        public S3AbsolutePath fromString(String str, S3AbsolutePath default_value) {
            try {
                return new S3AbsolutePath(str);
            }
            catch (Exception e) {
                return default_value;
            }
        }
    }
}

