/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.jimmutable.aws.s3.S3BucketName;
import org.jimmutable.core.utils.Validator;

public class BucketPuppet {
    public static void execute(AmazonS3 client, BucketConfiguration desired_configuration) throws Exception {
        BucketVersioningConfiguration versioning_config;
        Validator.notNull((Object)desired_configuration);
        if (!client.doesBucketExist(desired_configuration.getSimpleS3BucketNameString())) {
            LogManager.getRootLogger().debug(String.format("Creating bucket: %s", desired_configuration.getSimpleS3BucketNameString()));
            client.createBucket(new CreateBucketRequest(desired_configuration.getSimpleS3BucketNameString()));
        }
        if (desired_configuration.getSimpleIsVersioningEnabled()) {
            if (!client.getBucketVersioningConfiguration(desired_configuration.getSimpleS3BucketNameString()).getStatus().equalsIgnoreCase("Enabled")) {
                LogManager.getRootLogger().debug(String.format("Enabling versioning on bucket: %s ... ", desired_configuration.getSimpleS3BucketNameString()));
                versioning_config = new BucketVersioningConfiguration("Enabled");
                client.setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(desired_configuration.getSimpleS3BucketNameString(), versioning_config));
            }
        } else if (client.getBucketVersioningConfiguration(desired_configuration.getSimpleS3BucketNameString()).getStatus().equalsIgnoreCase("Enabled")) {
            LogManager.getRootLogger().debug(String.format("Suspending versioning on bucket: %s", desired_configuration.getSimpleS3BucketNameString()));
            versioning_config = new BucketVersioningConfiguration("Suspended");
            client.setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(desired_configuration.getSimpleS3BucketNameString(), versioning_config));
        }
        if (desired_configuration.getSimpleRetainOldVersionsInDays() != 0 && BucketPuppet.doesLifecyleConfigurationNeedModification(client, desired_configuration)) {
            LogManager.getRootLogger().debug(String.format("Updating lifecyle configuration on bucket %s to retain old versions for %d days", desired_configuration.getSimpleS3BucketNameString(), desired_configuration.getSimpleRetainOldVersionsInDays()));
            BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule();
            rule = rule.withId(String.format("Retain old versions for %d days", desired_configuration.getSimpleRetainOldVersionsInDays()));
            rule = rule.withNoncurrentVersionExpirationInDays(desired_configuration.getSimpleRetainOldVersionsInDays());
            rule = rule.withStatus("Enabled".toString());
            rule = rule.withExpiredObjectDeleteMarker(true);
            rule = rule.withAbortIncompleteMultipartUpload(new AbortIncompleteMultipartUpload().withDaysAfterInitiation(2));
            BucketLifecycleConfiguration config = new BucketLifecycleConfiguration().withRules(Arrays.asList(rule));
            client.setBucketLifecycleConfiguration(desired_configuration.getSimpleS3BucketNameString(), config);
        }
        if (desired_configuration.getSimpleIsWebAccessible() && !BucketPuppet.isBucketPolicyConfiguredAsWebAccessible(client, desired_configuration)) {
            LogManager.getRootLogger().debug(String.format("Modifying bucket %s to be web accessible", desired_configuration.getSimpleS3BucketNameString()));
            client.setBucketPolicy(desired_configuration.getSimpleS3BucketNameString(), desired_configuration.createMakeWebAccessibleBucketPolicy());
        }
        if (!desired_configuration.getSimpleIsWebAccessible() && BucketPuppet.isBucketPolicyConfiguredAsWebAccessible(client, desired_configuration)) {
            LogManager.getRootLogger().debug(String.format("Modifying bucket %s to be web *non* accessible", desired_configuration.getSimpleS3BucketNameString()));
            client.deleteBucketPolicy(desired_configuration.getSimpleS3BucketNameString());
        }
        LogManager.getRootLogger().debug(String.format("BucketPuppet: bucket configuration verified: %s", new Object[]{desired_configuration.getSimpleS3BucketName()}));
    }

    private static boolean doesLifecyleConfigurationNeedModification(AmazonS3 client, BucketConfiguration desired_configuration) {
        if (desired_configuration.getSimpleRetainOldVersionsInDays() == 0) {
            return false;
        }
        BucketLifecycleConfiguration current_lifecyle_configuration = client.getBucketLifecycleConfiguration(desired_configuration.getSimpleS3BucketNameString());
        if (current_lifecyle_configuration.getRules().size() != 1) {
            return true;
        }
        BucketLifecycleConfiguration.Rule cur_rule = (BucketLifecycleConfiguration.Rule)current_lifecyle_configuration.getRules().get(0);
        if (cur_rule.getNoncurrentVersionExpirationInDays() != desired_configuration.getSimpleRetainOldVersionsInDays()) {
            return true;
        }
        return !cur_rule.getStatus().equals("Enabled".toString());
    }

    private static boolean isBucketPolicyConfiguredAsWebAccessible(AmazonS3 client, BucketConfiguration desired_configuration) {
        BucketPolicy cur_policy = client.getBucketPolicy(desired_configuration.getSimpleS3BucketNameString());
        if (cur_policy.getPolicyText() == null) {
            return false;
        }
        String text = cur_policy.getPolicyText();
        return text.toLowerCase().contains("web_bucket_policy");
    }

    public static class BucketConfiguration {
        private S3BucketName bucket_name;
        private int retain_old_versions_in_days;
        private boolean is_web_accessible;

        public BucketConfiguration(S3BucketName bucket_name, int retain_old_versions_in_days, boolean is_web_accessible) {
            Validator.notNull((Object)((Object)bucket_name));
            if (retain_old_versions_in_days < 0) {
                retain_old_versions_in_days = 0;
            }
            this.bucket_name = bucket_name;
            this.retain_old_versions_in_days = retain_old_versions_in_days;
            this.is_web_accessible = is_web_accessible;
        }

        public S3BucketName getSimpleS3BucketName() {
            return this.bucket_name;
        }

        public String getSimpleS3BucketNameString() {
            return this.bucket_name.toString();
        }

        public int getSimpleRetainOldVersionsInDays() {
            return this.retain_old_versions_in_days;
        }

        public boolean getSimpleIsWebAccessible() {
            return this.is_web_accessible;
        }

        public boolean getSimpleIsVersioningEnabled() {
            return this.retain_old_versions_in_days > 0;
        }

        public String createMakeWebAccessibleBucketPolicy() {
            return "{ \"Id\": \"web_bucket_policy\", \"Version\": \"2012-10-17\", \"Statement\": [ { \"Sid\": \"readonly policy\", \"Action\": [ \"s3:GetObject\" ], \"Effect\": \"Allow\", \"Resource\":\"arn:aws:s3:::" + this.getSimpleS3BucketNameString() + "/*\", \"Principal\": \"*\" } ] }";
        }
    }
}

