/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.environment;

import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.jimmutable.core.exceptions.ValidationException;
import org.jimmutable.core.objects.Stringable;
import org.jimmutable.core.utils.Validator;

public class HostName
extends Stringable {
    public static final HostName CURRENT_COMPUTER_NAME = HostName.getThisComputerName();
    public static final MyConverter CONVERTER = new MyConverter();

    public HostName(String code) {
        super(code);
    }

    public void normalize() {
        this.normalizeTrim();
        this.normalizeLowerCase();
    }

    public void validate() {
        char[] chars;
        Validator.notNull((Object)this.getSimpleValue());
        Validator.min((int)this.getSimpleValue().length(), (int)1);
        for (char ch : chars = this.getSimpleValue().toCharArray()) {
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '.') continue;
            throw new ValidationException(String.format("Illegal character '%c' in host name %s.  Only lower case letters, numbers, underscore (_), dash (-) and dot (.) are allowed", Character.valueOf(ch), this.getSimpleValue()));
        }
    }

    private static HostName getThisComputerName() {
        try {
            return new HostName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogManager.getRootLogger().error("Unable to determine a valid computer name!");
            System.exit(1);
            return null;
        }
    }

    public static class MyConverter
    extends Stringable.Converter<HostName> {
        public HostName fromString(String str, HostName default_value) {
            try {
                return new HostName(str);
            }
            catch (Exception e) {
                return default_value;
            }
        }
    }
}

