/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.environment;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.jimmutable.core.serialization.JavaCodeUtils;
import org.jimmutable.core.utils.FileUtils;

public class DefaultLoggingSetup {
    public static void configureLogging() {
        try {
            File src = FileUtils.getSimpleFileInHomeDirectory((String)"log4j2_configuration.xml");
            if (!src.exists()) {
                System.out.println(String.format("Unable to logging configuration from %s, creating default", src.getAbsolutePath()));
                String default_config = String.format("%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<Configuration status=\"WARN\">", "  <Appenders>", "    <Console name=\"Console\" target=\"SYSTEM_OUT\">", "      <PatternLayout pattern=\"%d{dd MMM HH:mm:ss} [%t] %-5level %logger{36} - %msg%n\"/>", "    </Console>", "  </Appenders>", "  <Loggers>", "    <Root level=\"debug\">", "      <AppenderRef ref=\"Console\"/>", "    </Root>", "  </Loggers>", "</Configuration>");
                FileUtils.quietWriteFile((File)src, (String)default_config);
            }
            ConfigurationSource source = new ConfigurationSource((InputStream)new FileInputStream(src));
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to configure logging");
            System.exit(1);
        }
    }

    private static void printJavaCode() {
        File src = FileUtils.getSimpleFileInHomeDirectory((String)"log4j2_configuration.xml");
        String str = FileUtils.getComplexFileContentsAsString((File)src, (String)"");
        System.out.println(JavaCodeUtils.toJavaStringLiteral((String)str));
    }
}

