/*
 * Decompiled with CFR 0.152.
 */
package org.jimmutable.aws.environment;

import org.jimmutable.core.exceptions.ValidationException;
import org.jimmutable.core.objects.Stringable;
import org.jimmutable.core.utils.Validator;

public class CloudName
extends Stringable {
    public static final MyConverter CONVERTER = new MyConverter();

    public CloudName(String code) {
        super(code);
    }

    public void normalize() {
        this.normalizeTrim();
        this.normalizeLowerCase();
    }

    public void validate() {
        char[] chars;
        Validator.notNull((Object)this.getSimpleValue());
        Validator.min((int)this.getSimpleValue().length(), (int)1);
        for (char ch : chars = this.getSimpleValue().toCharArray()) {
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-') continue;
            throw new ValidationException(String.format("Illegal character '%c' in cloud name %s.  Only lower case letters, numbers, and dash (-) are allowed.", Character.valueOf(ch), this.getSimpleValue()));
        }
        if (this.getSimpleValue().startsWith("-")) {
            throw new ValidationException(String.format("Cloud name %s is invalid, bucket names may not start with a dash (-) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().endsWith("-")) {
            throw new ValidationException(String.format("Cloud name %s is invalid, bucket names may not end with a dash (-) ", this.getSimpleValue()));
        }
        if (this.getSimpleValue().contains("--")) {
            throw new ValidationException(String.format("Cloud name %s is invalid, bucket names may not contain two dashes in a row (--) ", this.getSimpleValue()));
        }
    }

    public static class MyConverter
    extends Stringable.Converter<CloudName> {
        public CloudName fromString(String str, CloudName default_value) {
            try {
                return new CloudName(str);
            }
            catch (Exception e) {
                return default_value;
            }
        }
    }
}

